/*
 * Decompiled with CFR 0.152.
 */
package co.dapi;

import co.dapi.types.UserInput;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DapiRequest {
    public static final String Dapi_URL = "https://api.dapi.co";
    public static final String DD_URL = "https://dd.dapi.co";
    static final Gson jsonAgent = new Gson().newBuilder().disableHtmlEscaping().registerTypeAdapter(HashMap.class, (Object)new SDKRequestSerializer()).create();
    private static final OkHttpClient httpClient = new OkHttpClient().newBuilder().readTimeout(2L, TimeUnit.MINUTES).build();

    public static Response HandleSDK(String bodyJson, HashMap<String, String> headersMap) throws IOException {
        return DapiRequest.doRequest(bodyJson, DD_URL, headersMap);
    }

    public static String Do(String bodyJson, String url) throws IOException {
        return DapiRequest.Do(bodyJson, url, new HashMap<String, String>());
    }

    public static String Do(String bodyJson, String url, HashMap<String, String> headersMap) throws IOException {
        Response resp = DapiRequest.doRequest(bodyJson, url, headersMap);
        ResponseBody respBody = resp.body();
        if (respBody == null) {
            return "";
        }
        return respBody.string();
    }

    private static Response doRequest(String bodyJson, String url, HashMap<String, String> headersMap) throws IOException {
        Headers.Builder headers = new Headers.Builder().add("Content-Type", "application/json");
        for (Map.Entry<String, String> header : headersMap.entrySet()) {
            headers.add(header.getKey(), header.getValue());
        }
        RequestBody reqBody = RequestBody.create((String)bodyJson, (MediaType)MediaType.parse((String)"application/json"));
        Request req = new Request.Builder().url(url).method("POST", reqBody).headers(headers.build()).build();
        return httpClient.newCall(req).execute();
    }

    static class SDKRequestSerializer
    implements JsonSerializer<HashMap<String, Object>> {
        SDKRequestSerializer() {
        }

        public JsonElement serialize(HashMap<String, Object> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject output = new JsonObject();
            for (Map.Entry<String, Object> kv : src.entrySet()) {
                String fieldName = kv.getKey();
                Object fieldValue = kv.getValue();
                if (!fieldName.equals("userInputs") || !(fieldValue instanceof List)) {
                    output.add(fieldName, context.serialize(fieldValue));
                    continue;
                }
                JsonArray userInputsOutput = new JsonArray();
                for (Object ui : (List)fieldValue) {
                    if (!(ui instanceof Map)) {
                        userInputsOutput.add(context.serialize(ui));
                        continue;
                    }
                    JsonObject outputUiObj = new JsonObject();
                    for (Map.Entry uiEntry : ((Map)ui).entrySet()) {
                        String uiFieldName = (String)uiEntry.getKey();
                        Object uiFieldValue = uiEntry.getValue();
                        if (!uiFieldName.equals("index")) {
                            outputUiObj.add(uiFieldName, context.serialize(uiFieldValue));
                            continue;
                        }
                        int index = (int)((Double)uiFieldValue).doubleValue();
                        outputUiObj.add(uiFieldName, (JsonElement)new JsonPrimitive((Number)index));
                    }
                    userInputsOutput.add((JsonElement)outputUiObj);
                }
                output.add(fieldName, (JsonElement)userInputsOutput);
            }
            return output;
        }
    }

    static class BaseRequest {
        private final String appSecret;
        private final String userSecret;
        private final String operationID;
        private final UserInput[] userInputs;

        public BaseRequest(String appSecret, String userSecret, String operationID, UserInput[] userInputs) {
            this.appSecret = appSecret;
            this.userSecret = userSecret;
            this.operationID = operationID;
            this.userInputs = userInputs;
        }
    }
}

