/*
 * Decompiled with CFR 0.152.
 */
package co.dapi;

import co.dapi.Config;
import co.dapi.DapiRequest;
import co.dapi.response.GetAccountsResponse;
import co.dapi.response.GetBalanceResponse;
import co.dapi.response.GetIdentityResponse;
import co.dapi.response.GetTransactionsResponse;
import co.dapi.types.UserInput;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;

public class Data {
    private final Config config;

    public Data(Config config) {
        this.config = config;
    }

    GetIdentityResponse getIdentity(String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        GetIdentityRequest body = new GetIdentityRequest(this.config.getAppSecret(), userSecret, operationID, userInputs);
        String bodyJson = DapiRequest.jsonAgent.toJson((Object)body, GetIdentityRequest.class);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        String respJson = DapiRequest.Do(bodyJson, "https://api.dapi.co/v2" + body.action, headers);
        GetIdentityResponse resp = null;
        try {
            resp = (GetIdentityResponse)DapiRequest.jsonAgent.fromJson(respJson, GetIdentityResponse.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (resp == null || resp.getStatus() == null && resp.getType().isEmpty()) {
            return new GetIdentityResponse("UNEXPECTED_RESPONSE", "Unexpected response body");
        }
        return resp;
    }

    GetAccountsResponse getAccounts(String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        GetAccountsRequest body = new GetAccountsRequest(this.config.getAppSecret(), userSecret, operationID, userInputs);
        String bodyJson = DapiRequest.jsonAgent.toJson((Object)body, GetAccountsRequest.class);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        String respJson = DapiRequest.Do(bodyJson, "https://api.dapi.co/v2" + body.action, headers);
        GetAccountsResponse resp = null;
        try {
            resp = (GetAccountsResponse)DapiRequest.jsonAgent.fromJson(respJson, GetAccountsResponse.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (resp == null || resp.getStatus() == null && resp.getType().isEmpty()) {
            return new GetAccountsResponse("UNEXPECTED_RESPONSE", "Unexpected response body");
        }
        return resp;
    }

    GetBalanceResponse getBalance(String accountID, String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        GetBalanceRequest body = new GetBalanceRequest(accountID, this.config.getAppSecret(), userSecret, operationID, userInputs);
        String bodyJson = DapiRequest.jsonAgent.toJson((Object)body, GetBalanceRequest.class);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        String respJson = DapiRequest.Do(bodyJson, "https://api.dapi.co/v2" + body.action, headers);
        GetBalanceResponse resp = null;
        try {
            resp = (GetBalanceResponse)DapiRequest.jsonAgent.fromJson(respJson, GetBalanceResponse.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (resp == null || resp.getStatus() == null && resp.getType().isEmpty()) {
            return new GetBalanceResponse("UNEXPECTED_RESPONSE", "Unexpected response body");
        }
        return resp;
    }

    GetTransactionsResponse getTransactions(String accountID, LocalDate fromDate, LocalDate toDate, String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        GetTransactionsRequest body = new GetTransactionsRequest(accountID, fromDate, toDate, this.config.getAppSecret(), userSecret, operationID, userInputs);
        String bodyJson = DapiRequest.jsonAgent.toJson((Object)body, GetTransactionsRequest.class);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        String respJson = DapiRequest.Do(bodyJson, "https://api.dapi.co/v2" + body.action, headers);
        GetTransactionsResponse resp = null;
        try {
            resp = (GetTransactionsResponse)DapiRequest.jsonAgent.fromJson(respJson, GetTransactionsResponse.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (resp == null || resp.getStatus() == null && resp.getType().isEmpty()) {
            return new GetTransactionsResponse("UNEXPECTED_RESPONSE", "Unexpected response body");
        }
        return resp;
    }

    private static class GetIdentityRequest
    extends DapiRequest.BaseRequest {
        private final String action = "/data/identity/get";

        public GetIdentityRequest(String appSecret, String userSecret, String operationID, UserInput[] userInputs) {
            super(appSecret, userSecret, operationID, userInputs);
        }
    }

    private static class GetAccountsRequest
    extends DapiRequest.BaseRequest {
        private final String action = "/data/accounts/get";

        public GetAccountsRequest(String appSecret, String userSecret, String operationID, UserInput[] userInputs) {
            super(appSecret, userSecret, operationID, userInputs);
        }
    }

    private static class GetBalanceRequest
    extends DapiRequest.BaseRequest {
        private final String action = "/data/balance/get";
        private final String accountID;

        public GetBalanceRequest(String accountID, String appSecret, String userSecret, String operationID, UserInput[] userInputs) {
            super(appSecret, userSecret, operationID, userInputs);
            this.accountID = accountID;
        }
    }

    private static class GetTransactionsRequest
    extends DapiRequest.BaseRequest {
        private final String action = "/data/transactions/get";
        private final String accountID;
        private final String fromDate;
        private final String toDate;
        private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        public GetTransactionsRequest(String accountID, LocalDate fromDate, LocalDate toDate, String appSecret, String userSecret, String operationID, UserInput[] userInputs) {
            super(appSecret, userSecret, operationID, userInputs);
            this.accountID = accountID;
            this.fromDate = dateFormatter.format(fromDate);
            this.toDate = dateFormatter.format(toDate);
        }
    }
}

