/*
 * Decompiled with CFR 0.152.
 */
package co.dapi;

import co.dapi.Config;
import co.dapi.DapiRequest;
import co.dapi.response.CreateBeneficiaryResponse;
import co.dapi.response.CreateTransferResponse;
import co.dapi.response.GetBeneficiariesResponse;
import co.dapi.response.TransferAutoflowResponse;
import co.dapi.types.Beneficiary;
import co.dapi.types.BeneficiaryAddress;
import co.dapi.types.UserInput;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;

public class Payment {
    private final Config config;

    public Payment(Config config) {
        this.config = config;
    }

    public CreateBeneficiaryResponse createBeneficiary(BeneficiaryInfo beneficiary, String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        CreateBenefRequest bodyObj = new CreateBenefRequest(beneficiary, this.config.getAppSecret(), userSecret, operationID, userInputs);
        String bodyJson = DapiRequest.jsonAgent.toJson((Object)bodyObj, CreateBenefRequest.class);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        String respJson = DapiRequest.Do(bodyJson, "https://api.dapi.co/v2" + bodyObj.action, headers);
        CreateBeneficiaryResponse resp = null;
        try {
            resp = (CreateBeneficiaryResponse)DapiRequest.jsonAgent.fromJson(respJson, CreateBeneficiaryResponse.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (resp == null || resp.getStatus() == null && resp.getType().isEmpty()) {
            return new CreateBeneficiaryResponse("UNEXPECTED_RESPONSE", "Unexpected response body");
        }
        return resp;
    }

    public GetBeneficiariesResponse getBeneficiaries(String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        GetBenefsRequest bodyObj = new GetBenefsRequest(this.config.getAppSecret(), userSecret, operationID, userInputs);
        String bodyJson = DapiRequest.jsonAgent.toJson((Object)bodyObj, GetBenefsRequest.class);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        String respJson = DapiRequest.Do(bodyJson, "https://api.dapi.co/v2" + bodyObj.action, headers);
        GetBeneficiariesResponse resp = null;
        try {
            resp = (GetBeneficiariesResponse)DapiRequest.jsonAgent.fromJson(respJson, GetBeneficiariesResponse.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (resp == null || resp.getStatus() == null && resp.getType().isEmpty()) {
            return new GetBeneficiariesResponse("UNEXPECTED_RESPONSE", "Unexpected response body");
        }
        return resp;
    }

    public CreateTransferResponse createTransfer(Transfer transfer, String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        CreateTransferRequest body = new CreateTransferRequest(transfer, this.config.getAppSecret(), userSecret, operationID, userInputs);
        String bodyJson = DapiRequest.jsonAgent.toJson((Object)body, CreateTransferRequest.class);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        String respJson = DapiRequest.Do(bodyJson, "https://api.dapi.co/v2" + body.action, headers);
        CreateTransferResponse resp = null;
        try {
            resp = (CreateTransferResponse)DapiRequest.jsonAgent.fromJson(respJson, CreateTransferResponse.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (resp == null || resp.getStatus() == null && resp.getType().isEmpty()) {
            return new CreateTransferResponse("UNEXPECTED_RESPONSE", "Unexpected response body");
        }
        return resp;
    }

    public TransferAutoflowResponse transferAutoflow(TransferAutoflow transferAutoflow, String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        TransferAutoflowRequest body = new TransferAutoflowRequest(transferAutoflow, this.config.getAppSecret(), userSecret, operationID, userInputs);
        String bodyJson = DapiRequest.jsonAgent.toJson((Object)body, TransferAutoflowRequest.class);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        String respJson = DapiRequest.Do(bodyJson, "https://api.dapi.co/v2" + body.action, headers);
        TransferAutoflowResponse resp = null;
        try {
            resp = (TransferAutoflowResponse)DapiRequest.jsonAgent.fromJson(respJson, TransferAutoflowResponse.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (resp == null || resp.getStatus() == null && resp.getType().isEmpty()) {
            return new TransferAutoflowResponse("UNEXPECTED_RESPONSE", "Unexpected response body");
        }
        return resp;
    }

    private static class CreateBenefRequest
    extends DapiRequest.BaseRequest {
        private final String action = "/payment/beneficiaries/create";
        private final String name;
        private final String accountNumber;
        private final String iban;
        private final String swiftCode;
        private final Beneficiary.BeneficiaryType type;
        private final BeneficiaryAddress address;
        private final String country;
        private final String branchAddress;
        private final String branchName;
        private final String bankName;
        private final String phoneNumber;
        private final String sortCode;
        private final String nickname;
        private final String routingNumber;

        public CreateBenefRequest(BeneficiaryInfo beneficiary, String appSecret, String userSecret, String operationID, UserInput[] userInputs) {
            super(appSecret, userSecret, operationID, userInputs);
            this.name = beneficiary.name;
            this.accountNumber = beneficiary.accountNumber;
            this.iban = beneficiary.iban;
            this.swiftCode = beneficiary.swiftCode;
            this.type = beneficiary.type;
            this.address = beneficiary.address;
            this.country = beneficiary.country;
            this.branchAddress = beneficiary.branchAddress;
            this.branchName = beneficiary.branchName;
            this.bankName = beneficiary.bankName;
            this.phoneNumber = beneficiary.phoneNumber;
            this.sortCode = beneficiary.sortCode;
            this.nickname = beneficiary.nickname;
            this.routingNumber = beneficiary.routingNumber;
        }
    }

    public static class BeneficiaryInfo {
        private final String name;
        private final String accountNumber;
        private final String iban;
        private final String swiftCode;
        private final Beneficiary.BeneficiaryType type;
        private final BeneficiaryAddress address;
        private final String country;
        private final String branchAddress;
        private final String branchName;
        private final String bankName;
        private final String phoneNumber;
        private final String sortCode;
        private final String nickname;
        private final String routingNumber;

        public BeneficiaryInfo(String name, String accountNumber, String iban, String swiftCode, Beneficiary.BeneficiaryType type, BeneficiaryAddress address, String country, String branchAddress, String branchName, String bankName, String phoneNumber, String sortCode, String nickname, String routingNumber) {
            this.name = name;
            this.accountNumber = accountNumber;
            this.iban = iban;
            this.swiftCode = swiftCode;
            this.type = type;
            this.address = address;
            this.country = country;
            this.branchAddress = branchAddress;
            this.branchName = branchName;
            this.bankName = bankName;
            this.phoneNumber = phoneNumber;
            this.sortCode = sortCode;
            this.nickname = nickname;
            this.routingNumber = routingNumber;
        }

        public BeneficiaryInfo(String name, String accountNumber, String iban, String swiftCode, Beneficiary.BeneficiaryType type, BeneficiaryAddress address, String country, String branchAddress, String branchName) {
            this.name = name;
            this.accountNumber = accountNumber;
            this.iban = iban;
            this.swiftCode = swiftCode;
            this.type = type;
            this.address = address;
            this.country = country;
            this.branchAddress = branchAddress;
            this.branchName = branchName;
            this.bankName = null;
            this.phoneNumber = null;
            this.sortCode = null;
            this.nickname = null;
            this.routingNumber = null;
        }

        public String getName() {
            return this.name;
        }

        public String getIban() {
            return this.iban;
        }

        public String getAccountNumber() {
            return this.accountNumber;
        }

        public String getSwiftCode() {
            return this.swiftCode;
        }

        public Beneficiary.BeneficiaryType getType() {
            return this.type;
        }

        public BeneficiaryAddress getAddress() {
            return this.address;
        }

        public String getCountry() {
            return this.country;
        }

        public String getBranchAddress() {
            return this.branchAddress;
        }

        public String getBranchName() {
            return this.branchName;
        }

        public Optional<String> getBankName() {
            return Optional.ofNullable(this.bankName);
        }

        public Optional<String> getPhoneNumber() {
            return Optional.ofNullable(this.phoneNumber);
        }

        public Optional<String> getSortCode() {
            return Optional.ofNullable(this.sortCode);
        }

        public Optional<String> getNickname() {
            return Optional.ofNullable(this.nickname);
        }

        public Optional<String> getRoutingNumber() {
            return Optional.ofNullable(this.routingNumber);
        }
    }

    private static class GetBenefsRequest
    extends DapiRequest.BaseRequest {
        private final String action = "/payment/beneficiaries/get";

        public GetBenefsRequest(String appSecret, String userSecret, String operationID, UserInput[] userInputs) {
            super(appSecret, userSecret, operationID, userInputs);
        }
    }

    private static class CreateTransferRequest
    extends DapiRequest.BaseRequest {
        private final String action = "/payment/transfer/create";
        private final String senderID;
        private final float amount;
        private final String receiverID;
        private final String name;
        private final String iban;
        private final String accountNumber;

        public CreateTransferRequest(Transfer transfer, String appSecret, String userSecret, String operationID, UserInput[] userInputs) {
            super(appSecret, userSecret, operationID, userInputs);
            this.senderID = transfer.senderID;
            this.amount = transfer.amount;
            this.receiverID = transfer.receiverID;
            this.name = transfer.name;
            this.iban = transfer.iban;
            this.accountNumber = transfer.accountNumber;
        }
    }

    public static class Transfer {
        private final String senderID;
        private final float amount;
        private final String receiverID;
        private final String name;
        private final String iban;
        private final String accountNumber;

        public Transfer(String senderID, float amount, String receiverID) {
            this.senderID = senderID;
            this.amount = amount;
            this.receiverID = receiverID;
            this.name = null;
            this.iban = null;
            this.accountNumber = null;
        }

        public Transfer(String senderID, float amount, String name, String iban, String accountNumber) {
            this.senderID = senderID;
            this.amount = amount;
            this.receiverID = null;
            this.name = name;
            this.iban = iban;
            this.accountNumber = accountNumber;
        }

        public String getSenderID() {
            return this.senderID;
        }

        public float getAmount() {
            return this.amount;
        }

        public Optional<String> getReceiverID() {
            return Optional.ofNullable(this.receiverID);
        }

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public Optional<String> getIban() {
            return Optional.ofNullable(this.iban);
        }

        public Optional<String> getAccountNumber() {
            return Optional.ofNullable(this.accountNumber);
        }
    }

    private static class TransferAutoflowRequest
    extends DapiRequest.BaseRequest {
        private final String action = "/payment/transfer/autoflow";
        private final String bundleID;
        private final String appKey;
        private final String userID;
        private final String bankID;
        private final String senderID;
        private final float amount;
        private final BeneficiaryInfo beneficiary;

        public TransferAutoflowRequest(TransferAutoflow transferAutoflow, String appSecret, String userSecret, String operationID, UserInput[] userInputs) {
            super(appSecret, userSecret, operationID, userInputs);
            this.bundleID = transferAutoflow.bundleID;
            this.appKey = transferAutoflow.appKey;
            this.userID = transferAutoflow.userID;
            this.bankID = transferAutoflow.bankID;
            this.senderID = transferAutoflow.senderID;
            this.amount = transferAutoflow.amount;
            this.beneficiary = transferAutoflow.beneficiary;
        }
    }

    public static class TransferAutoflow {
        private final String bundleID;
        private final String appKey;
        private final String userID;
        private final String bankID;
        private final String senderID;
        private final float amount;
        private final BeneficiaryInfo beneficiary;

        public TransferAutoflow(String bundleID, String appKey, String userID, String bankID, String senderID, float amount, BeneficiaryInfo beneficiary) {
            this.bundleID = bundleID;
            this.appKey = appKey;
            this.userID = userID;
            this.bankID = bankID;
            this.senderID = senderID;
            this.amount = amount;
            this.beneficiary = beneficiary;
        }

        public String getBundleID() {
            return this.bundleID;
        }

        public String getAppKey() {
            return this.appKey;
        }

        public String getUserID() {
            return this.userID;
        }

        public String getSenderID() {
            return this.senderID;
        }

        public float getAmount() {
            return this.amount;
        }

        public BeneficiaryInfo getBeneficiary() {
            return this.beneficiary;
        }
    }
}

