/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.CommitmentPolicy;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class EncryptionMaterialsRequest {
    private final Map<String, String> context;
    private final CryptoAlgorithm requestedAlgorithm;
    private final long plaintextSize;
    private final byte[] plaintext;
    private final CommitmentPolicy commitmentPolicy;

    private EncryptionMaterialsRequest(Builder builder) {
        this.context = builder.context;
        this.requestedAlgorithm = builder.requestedAlgorithm;
        this.plaintextSize = builder.plaintextSize;
        this.plaintext = builder.plaintext;
        this.commitmentPolicy = builder.commitmentPolicy;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public CryptoAlgorithm getRequestedAlgorithm() {
        return this.requestedAlgorithm;
    }

    public long getPlaintextSize() {
        return this.plaintextSize;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getPlaintext() {
        return this.plaintext;
    }

    public CommitmentPolicy getCommitmentPolicy() {
        return this.commitmentPolicy;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionMaterialsRequest request = (EncryptionMaterialsRequest)o;
        return this.plaintextSize == request.plaintextSize && Objects.equals(this.context, request.context) && this.requestedAlgorithm == request.requestedAlgorithm && Arrays.equals(this.plaintext, request.plaintext);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.context, this.requestedAlgorithm, this.plaintextSize, this.plaintext});
    }

    public static class Builder {
        private Map<String, String> context = Collections.emptyMap();
        private CryptoAlgorithm requestedAlgorithm = null;
        private long plaintextSize = -1L;
        private byte[] plaintext = null;
        private CommitmentPolicy commitmentPolicy = null;

        private Builder() {
        }

        private Builder(EncryptionMaterialsRequest request) {
            this.context = request.getContext();
            this.requestedAlgorithm = request.getRequestedAlgorithm();
            this.plaintextSize = request.getPlaintextSize();
            this.plaintext = request.getPlaintext();
            this.commitmentPolicy = request.getCommitmentPolicy();
        }

        public EncryptionMaterialsRequest build() {
            return new EncryptionMaterialsRequest(this);
        }

        public Map<String, String> getContext() {
            return this.context;
        }

        public Builder setContext(Map<String, String> context) {
            this.context = Collections.unmodifiableMap(new HashMap<String, String>(context));
            return this;
        }

        public CryptoAlgorithm getRequestedAlgorithm() {
            return this.requestedAlgorithm;
        }

        public Builder setRequestedAlgorithm(CryptoAlgorithm requestedAlgorithm) {
            this.requestedAlgorithm = requestedAlgorithm;
            return this;
        }

        public long getPlaintextSize() {
            return this.plaintextSize;
        }

        public Builder setPlaintextSize(long plaintextSize) {
            if (plaintextSize < -1L) {
                throw new IllegalArgumentException("Bad plaintext size");
            }
            this.plaintextSize = plaintextSize;
            return this;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public byte[] getPlaintext() {
            return this.plaintext;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Builder setPlaintext(byte[] plaintext) {
            this.plaintext = plaintext;
            if (plaintext != null) {
                return this.setPlaintextSize(plaintext.length);
            }
            return this.setPlaintextSize(-1L);
        }

        public CommitmentPolicy getCommitmentPolicy() {
            return this.commitmentPolicy;
        }

        public Builder setCommitmentPolicy(CommitmentPolicy commitmentPolicy) {
            this.commitmentPolicy = commitmentPolicy;
            return this;
        }
    }
}

