/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.entityresolution.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.OutputSource;
import java.util.List;

@SdkInternalApi
public class OutputSourceMarshaller {
    private static final MarshallingInfo<String> KMSARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KMSArn").build();
    private static final MarshallingInfo<Boolean> APPLYNORMALIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applyNormalization").build();
    private static final MarshallingInfo<List> OUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("output").build();
    private static final MarshallingInfo<String> OUTPUTS3PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputS3Path").build();
    private static final OutputSourceMarshaller instance = new OutputSourceMarshaller();

    public static OutputSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(OutputSource outputSource, ProtocolMarshaller protocolMarshaller) {
        if (outputSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)outputSource.getKMSArn(), KMSARN_BINDING);
            protocolMarshaller.marshall((Object)outputSource.getApplyNormalization(), APPLYNORMALIZATION_BINDING);
            protocolMarshaller.marshall(outputSource.getOutput(), OUTPUT_BINDING);
            protocolMarshaller.marshall((Object)outputSource.getOutputS3Path(), OUTPUTS3PATH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

