/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.IOUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class InvokeResultJsonUnmarshaller
implements Unmarshaller<InvokeResult, JsonUnmarshallerContext> {
    private static InvokeResultJsonUnmarshaller instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvokeResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        InvokeResult invokeResult = new InvokeResult();
        if (context.isStartOfDocument()) {
            if (context.getHeader("X-Amz-Function-Error") != null) {
                context.setCurrentHeader("X-Amz-Function-Error");
                invokeResult.setFunctionError(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
            }
            if (context.getHeader("X-Amz-Log-Result") != null) {
                context.setCurrentHeader("X-Amz-Log-Result");
                invokeResult.setLogResult(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
            }
        }
        invokeResult.setStatusCode(context.getHttpResponse().getStatusCode());
        InputStream is = context.getHttpResponse().getContent();
        if (is != null) {
            try {
                invokeResult.setPayload(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)is)));
            }
            finally {
                IOUtils.closeQuietly((Closeable)is, null);
            }
        }
        return invokeResult;
    }

    public static InvokeResultJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InvokeResultJsonUnmarshaller();
        }
        return instance;
    }
}

