/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.ListVersionsByFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListVersionsByFunctionRequestMarshaller
implements Marshaller<Request<ListVersionsByFunctionRequest>, ListVersionsByFunctionRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<ListVersionsByFunctionRequest> marshall(ListVersionsByFunctionRequest listVersionsByFunctionRequest) {
        if (listVersionsByFunctionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listVersionsByFunctionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/versions";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", listVersionsByFunctionRequest.getFunctionName() != null ? StringUtils.fromString((String)listVersionsByFunctionRequest.getFunctionName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (listVersionsByFunctionRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listVersionsByFunctionRequest.getMarker()));
        }
        if (listVersionsByFunctionRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listVersionsByFunctionRequest.getMaxItems()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

