/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.AddPermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        if (addPermissionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addPermissionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/policy";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", addPermissionRequest.getFunctionName() != null ? StringUtils.fromString((String)addPermissionRequest.getFunctionName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (addPermissionRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString((String)addPermissionRequest.getQualifier()));
        }
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (addPermissionRequest.getStatementId() != null) {
                jsonGenerator.writeFieldName("StatementId").writeValue(addPermissionRequest.getStatementId());
            }
            if (addPermissionRequest.getAction() != null) {
                jsonGenerator.writeFieldName("Action").writeValue(addPermissionRequest.getAction());
            }
            if (addPermissionRequest.getPrincipal() != null) {
                jsonGenerator.writeFieldName("Principal").writeValue(addPermissionRequest.getPrincipal());
            }
            if (addPermissionRequest.getSourceArn() != null) {
                jsonGenerator.writeFieldName("SourceArn").writeValue(addPermissionRequest.getSourceArn());
            }
            if (addPermissionRequest.getSourceAccount() != null) {
                jsonGenerator.writeFieldName("SourceAccount").writeValue(addPermissionRequest.getSourceAccount());
            }
            if (addPermissionRequest.getEventSourceToken() != null) {
                jsonGenerator.writeFieldName("EventSourceToken").writeValue(addPermissionRequest.getEventSourceToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

