/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.lambda.AWSLambdaAsync;
import com.amazonaws.services.lambda.AWSLambdaClient;
import com.amazonaws.services.lambda.model.AddPermissionRequest;
import com.amazonaws.services.lambda.model.AddPermissionResult;
import com.amazonaws.services.lambda.model.CreateAliasRequest;
import com.amazonaws.services.lambda.model.CreateAliasResult;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.DeleteAliasRequest;
import com.amazonaws.services.lambda.model.DeleteAliasResult;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingResult;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.services.lambda.model.DeleteFunctionResult;
import com.amazonaws.services.lambda.model.GetAliasRequest;
import com.amazonaws.services.lambda.model.GetAliasResult;
import com.amazonaws.services.lambda.model.GetEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.GetEventSourceMappingResult;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.model.GetPolicyRequest;
import com.amazonaws.services.lambda.model.GetPolicyResult;
import com.amazonaws.services.lambda.model.InvokeAsyncRequest;
import com.amazonaws.services.lambda.model.InvokeAsyncResult;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.ListAliasesRequest;
import com.amazonaws.services.lambda.model.ListAliasesResult;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsRequest;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsResult;
import com.amazonaws.services.lambda.model.ListFunctionsRequest;
import com.amazonaws.services.lambda.model.ListFunctionsResult;
import com.amazonaws.services.lambda.model.ListVersionsByFunctionRequest;
import com.amazonaws.services.lambda.model.ListVersionsByFunctionResult;
import com.amazonaws.services.lambda.model.PublishVersionRequest;
import com.amazonaws.services.lambda.model.PublishVersionResult;
import com.amazonaws.services.lambda.model.RemovePermissionRequest;
import com.amazonaws.services.lambda.model.RemovePermissionResult;
import com.amazonaws.services.lambda.model.UpdateAliasRequest;
import com.amazonaws.services.lambda.model.UpdateAliasResult;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSLambdaAsyncClient
extends AWSLambdaClient
implements AWSLambdaAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSLambdaAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSLambdaAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLambdaAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSLambdaAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSLambdaAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSLambdaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSLambdaAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(AddPermissionRequest request) {
        return this.addPermissionAsync(request, null);
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(final AddPermissionRequest request, final AsyncHandler<AddPermissionRequest, AddPermissionResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddPermissionResult>(){

            @Override
            public AddPermissionResult call() throws Exception {
                AddPermissionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.addPermission(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(CreateAliasRequest request) {
        return this.createAliasAsync(request, null);
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(final CreateAliasRequest request, final AsyncHandler<CreateAliasRequest, CreateAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAliasResult>(){

            @Override
            public CreateAliasResult call() throws Exception {
                CreateAliasResult result;
                try {
                    result = AWSLambdaAsyncClient.this.createAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateEventSourceMappingResult> createEventSourceMappingAsync(CreateEventSourceMappingRequest request) {
        return this.createEventSourceMappingAsync(request, null);
    }

    @Override
    public Future<CreateEventSourceMappingResult> createEventSourceMappingAsync(final CreateEventSourceMappingRequest request, final AsyncHandler<CreateEventSourceMappingRequest, CreateEventSourceMappingResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateEventSourceMappingResult>(){

            @Override
            public CreateEventSourceMappingResult call() throws Exception {
                CreateEventSourceMappingResult result;
                try {
                    result = AWSLambdaAsyncClient.this.createEventSourceMapping(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFunctionResult> createFunctionAsync(CreateFunctionRequest request) {
        return this.createFunctionAsync(request, null);
    }

    @Override
    public Future<CreateFunctionResult> createFunctionAsync(final CreateFunctionRequest request, final AsyncHandler<CreateFunctionRequest, CreateFunctionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateFunctionResult>(){

            @Override
            public CreateFunctionResult call() throws Exception {
                CreateFunctionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.createFunction(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAliasResult> deleteAliasAsync(DeleteAliasRequest request) {
        return this.deleteAliasAsync(request, null);
    }

    @Override
    public Future<DeleteAliasResult> deleteAliasAsync(final DeleteAliasRequest request, final AsyncHandler<DeleteAliasRequest, DeleteAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteAliasResult>(){

            @Override
            public DeleteAliasResult call() throws Exception {
                DeleteAliasResult result;
                try {
                    result = AWSLambdaAsyncClient.this.deleteAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEventSourceMappingResult> deleteEventSourceMappingAsync(DeleteEventSourceMappingRequest request) {
        return this.deleteEventSourceMappingAsync(request, null);
    }

    @Override
    public Future<DeleteEventSourceMappingResult> deleteEventSourceMappingAsync(final DeleteEventSourceMappingRequest request, final AsyncHandler<DeleteEventSourceMappingRequest, DeleteEventSourceMappingResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteEventSourceMappingResult>(){

            @Override
            public DeleteEventSourceMappingResult call() throws Exception {
                DeleteEventSourceMappingResult result;
                try {
                    result = AWSLambdaAsyncClient.this.deleteEventSourceMapping(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFunctionResult> deleteFunctionAsync(DeleteFunctionRequest request) {
        return this.deleteFunctionAsync(request, null);
    }

    @Override
    public Future<DeleteFunctionResult> deleteFunctionAsync(final DeleteFunctionRequest request, final AsyncHandler<DeleteFunctionRequest, DeleteFunctionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteFunctionResult>(){

            @Override
            public DeleteFunctionResult call() throws Exception {
                DeleteFunctionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.deleteFunction(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAliasResult> getAliasAsync(GetAliasRequest request) {
        return this.getAliasAsync(request, null);
    }

    @Override
    public Future<GetAliasResult> getAliasAsync(final GetAliasRequest request, final AsyncHandler<GetAliasRequest, GetAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetAliasResult>(){

            @Override
            public GetAliasResult call() throws Exception {
                GetAliasResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEventSourceMappingResult> getEventSourceMappingAsync(GetEventSourceMappingRequest request) {
        return this.getEventSourceMappingAsync(request, null);
    }

    @Override
    public Future<GetEventSourceMappingResult> getEventSourceMappingAsync(final GetEventSourceMappingRequest request, final AsyncHandler<GetEventSourceMappingRequest, GetEventSourceMappingResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetEventSourceMappingResult>(){

            @Override
            public GetEventSourceMappingResult call() throws Exception {
                GetEventSourceMappingResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getEventSourceMapping(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFunctionResult> getFunctionAsync(GetFunctionRequest request) {
        return this.getFunctionAsync(request, null);
    }

    @Override
    public Future<GetFunctionResult> getFunctionAsync(final GetFunctionRequest request, final AsyncHandler<GetFunctionRequest, GetFunctionResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetFunctionResult>(){

            @Override
            public GetFunctionResult call() throws Exception {
                GetFunctionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getFunction(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFunctionConfigurationResult> getFunctionConfigurationAsync(GetFunctionConfigurationRequest request) {
        return this.getFunctionConfigurationAsync(request, null);
    }

    @Override
    public Future<GetFunctionConfigurationResult> getFunctionConfigurationAsync(final GetFunctionConfigurationRequest request, final AsyncHandler<GetFunctionConfigurationRequest, GetFunctionConfigurationResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetFunctionConfigurationResult>(){

            @Override
            public GetFunctionConfigurationResult call() throws Exception {
                GetFunctionConfigurationResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getFunctionConfiguration(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(GetPolicyRequest request) {
        return this.getPolicyAsync(request, null);
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(final GetPolicyRequest request, final AsyncHandler<GetPolicyRequest, GetPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPolicyResult>(){

            @Override
            public GetPolicyResult call() throws Exception {
                GetPolicyResult result;
                try {
                    result = AWSLambdaAsyncClient.this.getPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InvokeResult> invokeAsync(InvokeRequest request) {
        return this.invokeAsync(request, null);
    }

    @Override
    public Future<InvokeResult> invokeAsync(final InvokeRequest request, final AsyncHandler<InvokeRequest, InvokeResult> asyncHandler) {
        return this.executorService.submit(new Callable<InvokeResult>(){

            @Override
            public InvokeResult call() throws Exception {
                InvokeResult result;
                try {
                    result = AWSLambdaAsyncClient.this.invoke(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<InvokeAsyncResult> invokeAsyncAsync(InvokeAsyncRequest request) {
        return this.invokeAsyncAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<InvokeAsyncResult> invokeAsyncAsync(final InvokeAsyncRequest request, final AsyncHandler<InvokeAsyncRequest, InvokeAsyncResult> asyncHandler) {
        return this.executorService.submit(new Callable<InvokeAsyncResult>(){

            @Override
            public InvokeAsyncResult call() throws Exception {
                InvokeAsyncResult result;
                try {
                    result = AWSLambdaAsyncClient.this.invokeAsync(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(ListAliasesRequest request) {
        return this.listAliasesAsync(request, null);
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(final ListAliasesRequest request, final AsyncHandler<ListAliasesRequest, ListAliasesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAliasesResult>(){

            @Override
            public ListAliasesResult call() throws Exception {
                ListAliasesResult result;
                try {
                    result = AWSLambdaAsyncClient.this.listAliases(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEventSourceMappingsResult> listEventSourceMappingsAsync(ListEventSourceMappingsRequest request) {
        return this.listEventSourceMappingsAsync(request, null);
    }

    @Override
    public Future<ListEventSourceMappingsResult> listEventSourceMappingsAsync(final ListEventSourceMappingsRequest request, final AsyncHandler<ListEventSourceMappingsRequest, ListEventSourceMappingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListEventSourceMappingsResult>(){

            @Override
            public ListEventSourceMappingsResult call() throws Exception {
                ListEventSourceMappingsResult result;
                try {
                    result = AWSLambdaAsyncClient.this.listEventSourceMappings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEventSourceMappingsResult> listEventSourceMappingsAsync() {
        return this.listEventSourceMappingsAsync(new ListEventSourceMappingsRequest());
    }

    @Override
    public Future<ListEventSourceMappingsResult> listEventSourceMappingsAsync(AsyncHandler<ListEventSourceMappingsRequest, ListEventSourceMappingsResult> asyncHandler) {
        return this.listEventSourceMappingsAsync(new ListEventSourceMappingsRequest(), asyncHandler);
    }

    @Override
    public Future<ListFunctionsResult> listFunctionsAsync(ListFunctionsRequest request) {
        return this.listFunctionsAsync(request, null);
    }

    @Override
    public Future<ListFunctionsResult> listFunctionsAsync(final ListFunctionsRequest request, final AsyncHandler<ListFunctionsRequest, ListFunctionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListFunctionsResult>(){

            @Override
            public ListFunctionsResult call() throws Exception {
                ListFunctionsResult result;
                try {
                    result = AWSLambdaAsyncClient.this.listFunctions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFunctionsResult> listFunctionsAsync() {
        return this.listFunctionsAsync(new ListFunctionsRequest());
    }

    @Override
    public Future<ListFunctionsResult> listFunctionsAsync(AsyncHandler<ListFunctionsRequest, ListFunctionsResult> asyncHandler) {
        return this.listFunctionsAsync(new ListFunctionsRequest(), asyncHandler);
    }

    @Override
    public Future<ListVersionsByFunctionResult> listVersionsByFunctionAsync(ListVersionsByFunctionRequest request) {
        return this.listVersionsByFunctionAsync(request, null);
    }

    @Override
    public Future<ListVersionsByFunctionResult> listVersionsByFunctionAsync(final ListVersionsByFunctionRequest request, final AsyncHandler<ListVersionsByFunctionRequest, ListVersionsByFunctionResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListVersionsByFunctionResult>(){

            @Override
            public ListVersionsByFunctionResult call() throws Exception {
                ListVersionsByFunctionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.listVersionsByFunction(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PublishVersionResult> publishVersionAsync(PublishVersionRequest request) {
        return this.publishVersionAsync(request, null);
    }

    @Override
    public Future<PublishVersionResult> publishVersionAsync(final PublishVersionRequest request, final AsyncHandler<PublishVersionRequest, PublishVersionResult> asyncHandler) {
        return this.executorService.submit(new Callable<PublishVersionResult>(){

            @Override
            public PublishVersionResult call() throws Exception {
                PublishVersionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.publishVersion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest request) {
        return this.removePermissionAsync(request, null);
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(final RemovePermissionRequest request, final AsyncHandler<RemovePermissionRequest, RemovePermissionResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemovePermissionResult>(){

            @Override
            public RemovePermissionResult call() throws Exception {
                RemovePermissionResult result;
                try {
                    result = AWSLambdaAsyncClient.this.removePermission(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAliasResult> updateAliasAsync(UpdateAliasRequest request) {
        return this.updateAliasAsync(request, null);
    }

    @Override
    public Future<UpdateAliasResult> updateAliasAsync(final UpdateAliasRequest request, final AsyncHandler<UpdateAliasRequest, UpdateAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateAliasResult>(){

            @Override
            public UpdateAliasResult call() throws Exception {
                UpdateAliasResult result;
                try {
                    result = AWSLambdaAsyncClient.this.updateAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEventSourceMappingResult> updateEventSourceMappingAsync(UpdateEventSourceMappingRequest request) {
        return this.updateEventSourceMappingAsync(request, null);
    }

    @Override
    public Future<UpdateEventSourceMappingResult> updateEventSourceMappingAsync(final UpdateEventSourceMappingRequest request, final AsyncHandler<UpdateEventSourceMappingRequest, UpdateEventSourceMappingResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateEventSourceMappingResult>(){

            @Override
            public UpdateEventSourceMappingResult call() throws Exception {
                UpdateEventSourceMappingResult result;
                try {
                    result = AWSLambdaAsyncClient.this.updateEventSourceMapping(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFunctionCodeResult> updateFunctionCodeAsync(UpdateFunctionCodeRequest request) {
        return this.updateFunctionCodeAsync(request, null);
    }

    @Override
    public Future<UpdateFunctionCodeResult> updateFunctionCodeAsync(final UpdateFunctionCodeRequest request, final AsyncHandler<UpdateFunctionCodeRequest, UpdateFunctionCodeResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateFunctionCodeResult>(){

            @Override
            public UpdateFunctionCodeResult call() throws Exception {
                UpdateFunctionCodeResult result;
                try {
                    result = AWSLambdaAsyncClient.this.updateFunctionCode(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFunctionConfigurationResult> updateFunctionConfigurationAsync(UpdateFunctionConfigurationRequest request) {
        return this.updateFunctionConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateFunctionConfigurationResult> updateFunctionConfigurationAsync(final UpdateFunctionConfigurationRequest request, final AsyncHandler<UpdateFunctionConfigurationRequest, UpdateFunctionConfigurationResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateFunctionConfigurationResult>(){

            @Override
            public UpdateFunctionConfigurationResult call() throws Exception {
                UpdateFunctionConfigurationResult result;
                try {
                    result = AWSLambdaAsyncClient.this.updateFunctionConfiguration(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

