/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lambda.model.RemovePermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RemovePermissionRequestMarshaller
implements Marshaller<Request<RemovePermissionRequest>, RemovePermissionRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public RemovePermissionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RemovePermissionRequest> marshall(RemovePermissionRequest removePermissionRequest) {
        if (removePermissionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removePermissionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/policy/{StatementId}";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", removePermissionRequest.getFunctionName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)removePermissionRequest.getFunctionName()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{StatementId}", removePermissionRequest.getStatementId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)removePermissionRequest.getStatementId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (removePermissionRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString((String)removePermissionRequest.getQualifier()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

