/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.lambda.model.RemovePermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RemovePermissionRequestMarshaller
implements Marshaller<Request<RemovePermissionRequest>, RemovePermissionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public RemovePermissionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RemovePermissionRequest> marshall(RemovePermissionRequest removePermissionRequest) {
        if (removePermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removePermissionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/policy/{StatementId}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "FunctionName", removePermissionRequest.getFunctionName());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "StatementId", removePermissionRequest.getStatementId());
        request.setResourcePath(uriResourcePath);
        if (removePermissionRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString((String)removePermissionRequest.getQualifier()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

