/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.CreateAliasRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateAliasRequestMarshaller
implements Marshaller<Request<CreateAliasRequest>, CreateAliasRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateAliasRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateAliasRequest> marshall(CreateAliasRequest createAliasRequest) {
        if (createAliasRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAliasRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/aliases";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "FunctionName", createAliasRequest.getFunctionName());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createAliasRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createAliasRequest.getName());
            }
            if (createAliasRequest.getFunctionVersion() != null) {
                jsonGenerator.writeFieldName("FunctionVersion").writeValue(createAliasRequest.getFunctionVersion());
            }
            if (createAliasRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createAliasRequest.getDescription());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

