/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.lambda.model.EventSourceConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListEventSourcesResult
implements Serializable,
Cloneable {
    private String nextMarker;
    private ListWithAutoConstructFlag<EventSourceConfiguration> eventSources;

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public ListEventSourcesResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public List<EventSourceConfiguration> getEventSources() {
        if (this.eventSources == null) {
            this.eventSources = new ListWithAutoConstructFlag();
            this.eventSources.setAutoConstruct(true);
        }
        return this.eventSources;
    }

    public void setEventSources(Collection<EventSourceConfiguration> eventSources) {
        if (eventSources == null) {
            this.eventSources = null;
            return;
        }
        ListWithAutoConstructFlag eventSourcesCopy = new ListWithAutoConstructFlag(eventSources.size());
        eventSourcesCopy.addAll(eventSources);
        this.eventSources = eventSourcesCopy;
    }

    public ListEventSourcesResult withEventSources(EventSourceConfiguration ... eventSources) {
        if (this.getEventSources() == null) {
            this.setEventSources(new ArrayList<EventSourceConfiguration>(eventSources.length));
        }
        for (EventSourceConfiguration value : eventSources) {
            this.getEventSources().add(value);
        }
        return this;
    }

    public ListEventSourcesResult withEventSources(Collection<EventSourceConfiguration> eventSources) {
        if (eventSources == null) {
            this.eventSources = null;
        } else {
            ListWithAutoConstructFlag eventSourcesCopy = new ListWithAutoConstructFlag(eventSources.size());
            eventSourcesCopy.addAll(eventSources);
            this.eventSources = eventSourcesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.getEventSources() != null) {
            sb.append("EventSources: " + this.getEventSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getEventSources() == null ? 0 : this.getEventSources().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventSourcesResult)) {
            return false;
        }
        ListEventSourcesResult other = (ListEventSourcesResult)obj;
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getEventSources() == null ^ this.getEventSources() == null) {
            return false;
        }
        return other.getEventSources() == null || other.getEventSources().equals(this.getEventSources());
    }

    public ListEventSourcesResult clone() {
        try {
            return (ListEventSourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

