/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.memorydb.model.AuthenticationMode;
import com.amazonaws.services.memorydb.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateUserRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String userName;
    private AuthenticationMode authenticationMode;
    private String accessString;
    private List<Tag> tags;

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public CreateUserRequest withUserName(String userName) {
        this.setUserName(userName);
        return this;
    }

    public void setAuthenticationMode(AuthenticationMode authenticationMode) {
        this.authenticationMode = authenticationMode;
    }

    public AuthenticationMode getAuthenticationMode() {
        return this.authenticationMode;
    }

    public CreateUserRequest withAuthenticationMode(AuthenticationMode authenticationMode) {
        this.setAuthenticationMode(authenticationMode);
        return this;
    }

    public void setAccessString(String accessString) {
        this.accessString = accessString;
    }

    public String getAccessString() {
        return this.accessString;
    }

    public CreateUserRequest withAccessString(String accessString) {
        this.setAccessString(accessString);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateUserRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateUserRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserName() != null) {
            sb.append("UserName: ").append(this.getUserName()).append(",");
        }
        if (this.getAuthenticationMode() != null) {
            sb.append("AuthenticationMode: ").append(this.getAuthenticationMode()).append(",");
        }
        if (this.getAccessString() != null) {
            sb.append("AccessString: ").append(this.getAccessString()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)obj;
        if (other.getUserName() == null ^ this.getUserName() == null) {
            return false;
        }
        if (other.getUserName() != null && !other.getUserName().equals(this.getUserName())) {
            return false;
        }
        if (other.getAuthenticationMode() == null ^ this.getAuthenticationMode() == null) {
            return false;
        }
        if (other.getAuthenticationMode() != null && !other.getAuthenticationMode().equals(this.getAuthenticationMode())) {
            return false;
        }
        if (other.getAccessString() == null ^ this.getAccessString() == null) {
            return false;
        }
        if (other.getAccessString() != null && !other.getAccessString().equals(this.getAccessString())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserName() == null ? 0 : this.getUserName().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationMode() == null ? 0 : this.getAuthenticationMode().hashCode());
        hashCode = 31 * hashCode + (this.getAccessString() == null ? 0 : this.getAccessString().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateUserRequest clone() {
        return (CreateUserRequest)super.clone();
    }
}

