/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.os.Build;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.androidplot.PlotListener;
import com.androidplot.Series;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.ui.BoxModel;
import com.androidplot.ui.Formatter;
import com.androidplot.ui.LayoutManager;
import com.androidplot.ui.Resizable;
import com.androidplot.ui.SeriesAndFormatterList;
import com.androidplot.ui.SeriesRenderer;
import com.androidplot.ui.SizeLayoutType;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.TextOrientationType;
import com.androidplot.ui.XLayoutStyle;
import com.androidplot.ui.YLayoutStyle;
import com.androidplot.ui.widget.TextLabelWidget;
import com.androidplot.util.Configurator;
import com.androidplot.util.DisplayDimensions;
import com.androidplot.util.PixelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class Plot<SeriesType extends Series, FormatterType extends Formatter, RendererType extends SeriesRenderer>
extends View
implements Resizable {
    private static final String TAG = Plot.class.getName();
    private static final String XML_ATTR_PREFIX = "androidplot";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_RENDER_MODE = "renderMode";
    private BoxModel boxModel = new BoxModel(3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f);
    private BorderStyle borderStyle = BorderStyle.SQUARE;
    private float borderRadiusX = 15.0f;
    private float borderRadiusY = 15.0f;
    private boolean drawBorderEnabled = true;
    private Paint borderPaint;
    private Paint backgroundPaint;
    private LayoutManager layoutManager;
    private TextLabelWidget titleWidget;
    private DisplayDimensions displayDims = new DisplayDimensions();
    private RenderMode renderMode = RenderMode.USE_MAIN_THREAD;
    private final BufferedCanvas pingPong = new BufferedCanvas();
    private final Object renderSynch = new Object();
    private LinkedList<RendererType> renderers;
    private LinkedHashMap<Class, SeriesAndFormatterList<SeriesType, FormatterType>> seriesRegistry;
    private final ArrayList<PlotListener> listeners = new ArrayList();
    private Thread renderThread;
    private boolean keepRunning = false;
    private boolean isIdle = true;

    public DisplayDimensions getDisplayDimensions() {
        return this.displayDims;
    }

    public Plot(Context context, String title) {
        this(context, title, RenderMode.USE_MAIN_THREAD);
    }

    public Plot(Context context, String title, RenderMode mode) {
        super(context);
        this.seriesRegistry = new LinkedHashMap();
        this.renderers = new LinkedList();
        this.borderPaint = new Paint();
        this.borderPaint.setColor(Color.rgb((int)150, (int)150, (int)150));
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setStrokeWidth(1.0f);
        this.borderPaint.setAntiAlias(true);
        this.backgroundPaint = new Paint();
        this.backgroundPaint.setColor(-12303292);
        this.backgroundPaint.setStyle(Paint.Style.FILL);
        this.renderMode = mode;
        this.init(null, null);
        this.setTitle(title);
    }

    public Plot(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.seriesRegistry = new LinkedHashMap();
        this.renderers = new LinkedList();
        this.borderPaint = new Paint();
        this.borderPaint.setColor(Color.rgb((int)150, (int)150, (int)150));
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setStrokeWidth(1.0f);
        this.borderPaint.setAntiAlias(true);
        this.backgroundPaint = new Paint();
        this.backgroundPaint.setColor(-12303292);
        this.backgroundPaint.setStyle(Paint.Style.FILL);
        this.init(context, attrs);
    }

    public Plot(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.seriesRegistry = new LinkedHashMap();
        this.renderers = new LinkedList();
        this.borderPaint = new Paint();
        this.borderPaint.setColor(Color.rgb((int)150, (int)150, (int)150));
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setStrokeWidth(1.0f);
        this.borderPaint.setAntiAlias(true);
        this.backgroundPaint = new Paint();
        this.backgroundPaint.setColor(-12303292);
        this.backgroundPaint.setStyle(Paint.Style.FILL);
        this.init(context, attrs);
    }

    protected boolean isHwAccelerationSupported() {
        return false;
    }

    public void setRenderMode(RenderMode mode) {
        this.renderMode = mode;
    }

    protected abstract void onPreInit();

    private void init(Context context, AttributeSet attrs) {
        PixelUtils.init(this.getContext());
        this.layoutManager = new LayoutManager();
        this.titleWidget = new TextLabelWidget(this.layoutManager, new SizeMetrics(25.0f, SizeLayoutType.ABSOLUTE, 100.0f, SizeLayoutType.ABSOLUTE), TextOrientationType.HORIZONTAL);
        this.titleWidget.position(0.0f, XLayoutStyle.RELATIVE_TO_CENTER, 0.0f, YLayoutStyle.ABSOLUTE_FROM_TOP, AnchorPosition.TOP_MIDDLE);
        this.onPreInit();
        this.layoutManager.moveToTop(this.titleWidget);
        if (context != null && attrs != null) {
            this.loadAttrs(attrs);
        }
        this.layoutManager.onPostInit();
        if (this.renderMode == RenderMode.USE_BACKGROUND_THREAD) {
            this.renderThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Plot.this.keepRunning = true;
                    while (Plot.this.keepRunning) {
                        Plot.this.isIdle = false;
                        Object object = Plot.this.pingPong;
                        synchronized (object) {
                            Canvas c = Plot.this.pingPong.getCanvas();
                            Plot.this.renderOnCanvas(c);
                            Plot.this.pingPong.swap();
                        }
                        object = Plot.this.renderSynch;
                        synchronized (object) {
                            Plot.this.postInvalidate();
                            if (Plot.this.keepRunning) {
                                try {
                                    Plot.this.renderSynch.wait();
                                }
                                catch (InterruptedException e) {
                                    Plot.this.keepRunning = false;
                                }
                            }
                        }
                    }
                    System.out.println("AndroidPlot render thread finished.");
                }
            });
        }
    }

    private void loadAttrs(AttributeSet attrs) {
        if (attrs != null) {
            HashMap<String, String> attrHash = new HashMap<String, String>();
            for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                String attrName = attrs.getAttributeName(i);
                if (!attrName.toUpperCase().startsWith(XML_ATTR_PREFIX.toUpperCase())) continue;
                attrHash.put(attrName.substring(XML_ATTR_PREFIX.length() + 1), attrs.getAttributeValue(i));
            }
            Configurator.configure(this.getContext(), (Object)this, attrHash);
        }
    }

    public RenderMode getRenderMode() {
        return this.renderMode;
    }

    public synchronized boolean addListener(PlotListener listener) {
        return !this.listeners.contains(listener) && this.listeners.add(listener);
    }

    public synchronized boolean removeListener(PlotListener listener) {
        return this.listeners.remove(listener);
    }

    protected void notifyListenersBeforeDraw(Canvas canvas) {
        for (PlotListener listener : this.listeners) {
            listener.onBeforeDraw(this, canvas);
        }
    }

    protected void notifyListenersAfterDraw(Canvas canvas) {
        for (PlotListener listener : this.listeners) {
            listener.onAfterDraw(this, canvas);
        }
    }

    public synchronized boolean addSeries(SeriesType series, FormatterType formatter) {
        Class<SeriesRenderer> rendererClass = ((Formatter)formatter).getRendererClass();
        SeriesAndFormatterList<SeriesType, FormatterType> sfList = this.seriesRegistry.get(rendererClass);
        if (sfList == null) {
            if (this.getRenderer(rendererClass) == null) {
                this.renderers.add(((Formatter)formatter).getRendererInstance((Plot)this));
            }
            sfList = new SeriesAndFormatterList();
            this.seriesRegistry.put(rendererClass, sfList);
        }
        if (series instanceof PlotListener) {
            this.addListener((PlotListener)series);
        }
        if (sfList.contains(series)) {
            return false;
        }
        sfList.add(series, formatter);
        return true;
    }

    public synchronized boolean removeSeries(SeriesType series, Class rendererClass) {
        boolean result = this.seriesRegistry.get(rendererClass).remove(series);
        if (this.seriesRegistry.get(rendererClass).size() <= 0) {
            this.seriesRegistry.remove(rendererClass);
        }
        if (series instanceof PlotListener) {
            this.removeListener((PlotListener)series);
        }
        return result;
    }

    public synchronized void removeSeries(SeriesType series) {
        for (Class rendererClass : this.seriesRegistry.keySet()) {
            this.seriesRegistry.get(rendererClass).remove(series);
        }
        Iterator<SeriesAndFormatterList<SeriesType, FormatterType>> it = this.seriesRegistry.values().iterator();
        while (it.hasNext()) {
            if (it.next().size() > 0) continue;
            it.remove();
        }
        if (series instanceof PlotListener) {
            this.removeListener((PlotListener)series);
        }
    }

    public void clear() {
        Iterator<SeriesAndFormatterList<SeriesType, FormatterType>> it = this.seriesRegistry.values().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public boolean isEmpty() {
        return this.seriesRegistry.isEmpty();
    }

    public FormatterType getFormatter(SeriesType series, Class rendererClass) {
        return (FormatterType)((Formatter)this.seriesRegistry.get(rendererClass).getFormatter(series));
    }

    public SeriesAndFormatterList<SeriesType, FormatterType> getSeriesAndFormatterListForRenderer(Class rendererClass) {
        return this.seriesRegistry.get(rendererClass);
    }

    public Set<SeriesType> getSeriesSet() {
        LinkedHashSet<Series> seriesSet = new LinkedHashSet<Series>();
        for (SeriesRenderer renderer : this.getRendererList()) {
            List<SeriesType> seriesList = this.getSeriesListForRenderer(renderer.getClass());
            if (seriesList == null) continue;
            for (Series series : seriesList) {
                seriesSet.add(series);
            }
        }
        return seriesSet;
    }

    public List<SeriesType> getSeriesListForRenderer(Class rendererClass) {
        SeriesAndFormatterList<SeriesType, FormatterType> lst = this.seriesRegistry.get(rendererClass);
        if (lst == null) {
            return null;
        }
        return lst.getSeriesList();
    }

    public RendererType getRenderer(Class rendererClass) {
        for (SeriesRenderer renderer : this.renderers) {
            if (renderer.getClass() != rendererClass) continue;
            return (RendererType)renderer;
        }
        return null;
    }

    public List<RendererType> getRendererList() {
        return this.renderers;
    }

    public void setMarkupEnabled(boolean enabled) {
        this.layoutManager.setMarkupEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw() {
        if (this.renderMode == RenderMode.USE_BACKGROUND_THREAD) {
            if (this.isIdle) {
                Object object = this.renderSynch;
                synchronized (object) {
                    this.renderSynch.notify();
                }
            }
        } else if (this.renderMode == RenderMode.USE_MAIN_THREAD) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                this.invalidate();
            } else {
                this.postInvalidate();
            }
        } else {
            throw new IllegalArgumentException("Unsupported Render Mode: " + (Object)((Object)this.renderMode));
        }
    }

    @Override
    public synchronized void layout(DisplayDimensions dims) {
        this.displayDims = dims;
        this.layoutManager.layout(this.displayDims);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.renderSynch;
        synchronized (object) {
            this.keepRunning = false;
            this.renderSynch.notify();
        }
    }

    protected synchronized void onSizeChanged(int w, int h, int oldw, int oldh) {
        PixelUtils.init(this.getContext());
        if (Build.VERSION.SDK_INT >= 11 && !this.isHwAccelerationSupported() && this.isHardwareAccelerated()) {
            this.setLayerType(1, null);
        }
        if (this.renderMode == RenderMode.USE_BACKGROUND_THREAD) {
            this.pingPong.resize(h, w);
        }
        RectF cRect = new RectF(0.0f, 0.0f, (float)w, (float)h);
        RectF mRect = this.boxModel.getMarginatedRect(cRect);
        RectF pRect = this.boxModel.getPaddedRect(mRect);
        this.layout(new DisplayDimensions(cRect, mRect, pRect));
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.renderThread != null && !this.renderThread.isAlive()) {
            this.renderThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        if (this.renderMode == RenderMode.USE_BACKGROUND_THREAD) {
            BufferedCanvas bufferedCanvas = this.pingPong;
            synchronized (bufferedCanvas) {
                Bitmap bmp = this.pingPong.getBitmap();
                if (bmp != null) {
                    canvas.drawBitmap(bmp, 0.0f, 0.0f, null);
                }
            }
        } else if (this.renderMode == RenderMode.USE_MAIN_THREAD) {
            this.renderOnCanvas(canvas);
        } else {
            throw new IllegalArgumentException("Unsupported Render Mode: " + (Object)((Object)this.renderMode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void renderOnCanvas(Canvas canvas) {
        try {
            this.notifyListenersBeforeDraw(canvas);
            try {
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                if (this.backgroundPaint != null) {
                    this.drawBackground(canvas, this.displayDims.marginatedRect);
                }
                this.layoutManager.draw(canvas);
                if (this.getBorderPaint() != null) {
                    this.drawBorder(canvas, this.displayDims.marginatedRect);
                }
            }
            catch (PlotRenderException e) {
                Log.e((String)TAG, (String)"Exception while rendering Plot.", (Throwable)e);
                e.printStackTrace();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception while rendering Plot.", (Throwable)e);
            }
        }
        finally {
            this.isIdle = true;
            this.notifyListenersAfterDraw(canvas);
        }
    }

    public void setBorderStyle(BorderStyle style, Float radiusX, Float radiusY) {
        if (style == BorderStyle.ROUNDED) {
            if (radiusX == null || radiusY == null) {
                throw new IllegalArgumentException("radiusX and radiusY cannot be null when using BorderStyle.ROUNDED");
            }
            this.borderRadiusX = radiusX.floatValue();
            this.borderRadiusY = radiusY.floatValue();
        }
        this.borderStyle = style;
    }

    protected void drawBorder(Canvas canvas, RectF dims) {
        switch (this.borderStyle) {
            case ROUNDED: {
                canvas.drawRoundRect(dims, this.borderRadiusX, this.borderRadiusY, this.borderPaint);
                break;
            }
            case SQUARE: {
                canvas.drawRect(dims, this.borderPaint);
                break;
            }
        }
    }

    protected void drawBackground(Canvas canvas, RectF dims) {
        switch (this.borderStyle) {
            case ROUNDED: {
                canvas.drawRoundRect(dims, this.borderRadiusX, this.borderRadiusY, this.backgroundPaint);
                break;
            }
            case SQUARE: {
                canvas.drawRect(dims, this.backgroundPaint);
                break;
            }
        }
    }

    public String getTitle() {
        return this.getTitleWidget().getText();
    }

    public void setTitle(String title) {
        this.titleWidget.setText(title);
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    public TextLabelWidget getTitleWidget() {
        return this.titleWidget;
    }

    public void setTitleWidget(TextLabelWidget titleWidget) {
        this.titleWidget = titleWidget;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
    }

    public void setPlotMargins(float left, float top, float right, float bottom) {
        this.setPlotMarginLeft(left);
        this.setPlotMarginTop(top);
        this.setPlotMarginRight(right);
        this.setPlotMarginBottom(bottom);
    }

    public void setPlotPadding(float left, float top, float right, float bottom) {
        this.setPlotPaddingLeft(left);
        this.setPlotPaddingTop(top);
        this.setPlotPaddingRight(right);
        this.setPlotPaddingBottom(bottom);
    }

    public float getPlotMarginTop() {
        return this.boxModel.getMarginTop();
    }

    public void setPlotMarginTop(float plotMarginTop) {
        this.boxModel.setMarginTop(plotMarginTop);
    }

    public float getPlotMarginBottom() {
        return this.boxModel.getMarginBottom();
    }

    public void setPlotMarginBottom(float plotMarginBottom) {
        this.boxModel.setMarginBottom(plotMarginBottom);
    }

    public float getPlotMarginLeft() {
        return this.boxModel.getMarginLeft();
    }

    public void setPlotMarginLeft(float plotMarginLeft) {
        this.boxModel.setMarginLeft(plotMarginLeft);
    }

    public float getPlotMarginRight() {
        return this.boxModel.getMarginRight();
    }

    public void setPlotMarginRight(float plotMarginRight) {
        this.boxModel.setMarginRight(plotMarginRight);
    }

    public float getPlotPaddingTop() {
        return this.boxModel.getPaddingTop();
    }

    public void setPlotPaddingTop(float plotPaddingTop) {
        this.boxModel.setPaddingTop(plotPaddingTop);
    }

    public float getPlotPaddingBottom() {
        return this.boxModel.getPaddingBottom();
    }

    public void setPlotPaddingBottom(float plotPaddingBottom) {
        this.boxModel.setPaddingBottom(plotPaddingBottom);
    }

    public float getPlotPaddingLeft() {
        return this.boxModel.getPaddingLeft();
    }

    public void setPlotPaddingLeft(float plotPaddingLeft) {
        this.boxModel.setPaddingLeft(plotPaddingLeft);
    }

    public float getPlotPaddingRight() {
        return this.boxModel.getPaddingRight();
    }

    public void setPlotPaddingRight(float plotPaddingRight) {
        this.boxModel.setPaddingRight(plotPaddingRight);
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint borderPaint) {
        if (borderPaint == null) {
            this.borderPaint = null;
        } else {
            this.borderPaint = new Paint(borderPaint);
            this.borderPaint.setStyle(Paint.Style.STROKE);
        }
    }

    private class BufferedCanvas {
        private volatile Bitmap bgBuffer;
        private volatile Bitmap fgBuffer;
        private Canvas canvas = new Canvas();

        private BufferedCanvas() {
        }

        public synchronized void swap() {
            Bitmap tmp = this.bgBuffer;
            this.bgBuffer = this.fgBuffer;
            this.fgBuffer = tmp;
        }

        public synchronized void resize(int h, int w) {
            if (w <= 0 || h <= 0) {
                this.bgBuffer = null;
                this.fgBuffer = null;
            } else {
                this.bgBuffer = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_4444);
                this.fgBuffer = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_4444);
            }
        }

        public synchronized Canvas getCanvas() {
            if (this.bgBuffer != null) {
                this.canvas.setBitmap(this.bgBuffer);
                return this.canvas;
            }
            return null;
        }

        public Bitmap getBitmap() {
            return this.fgBuffer;
        }
    }

    public static enum RenderMode {
        USE_BACKGROUND_THREAD,
        USE_MAIN_THREAD;

    }

    public static enum BorderStyle {
        ROUNDED,
        SQUARE,
        NONE;

    }
}

