/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui;

import android.graphics.RectF;
import com.androidplot.ui.TableModel;
import com.androidplot.ui.TableOrder;
import java.util.Iterator;

public class DynamicTableModel
extends TableModel {
    private int numRows;
    private int numColumns;
    private Float cellWidth;
    private Float cellHeight;
    private TableModel.CellSizingMethod rowSizingMethod;
    private TableModel.CellSizingMethod columnSizingMethod;

    public DynamicTableModel(int numColumns, int numRows) {
        this(numColumns, numRows, TableOrder.ROW_MAJOR);
    }

    public DynamicTableModel(int numColumns, int numRows, TableOrder order) {
        super(order);
        this.numColumns = numColumns;
        this.numRows = numRows;
    }

    public TableModelIterator getIterator(RectF tableRect, int totalElements) {
        return new TableModelIterator(this, tableRect, totalElements);
    }

    public RectF getCellRect(RectF tableRect, int numElements) {
        RectF cellRect = new RectF();
        cellRect.left = tableRect.left;
        cellRect.top = tableRect.top;
        cellRect.bottom = tableRect.top + this.calculateCellSize(tableRect, TableModel.Axis.ROW, numElements);
        cellRect.right = tableRect.left + this.calculateCellSize(tableRect, TableModel.Axis.COLUMN, numElements);
        return cellRect;
    }

    private float calculateCellSize(RectF tableRect, TableModel.Axis axis, int numElementsInTable) {
        int axisElements = 0;
        float axisSizePix = 0.0f;
        switch (axis) {
            case ROW: {
                axisElements = this.numRows;
                axisSizePix = tableRect.height();
                break;
            }
            case COLUMN: {
                axisElements = this.numColumns;
                axisSizePix = tableRect.width();
            }
        }
        if (axisElements != 0) {
            return axisSizePix / (float)axisElements;
        }
        return axisSizePix / (float)numElementsInTable;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    private class TableModelIterator
    implements Iterator<RectF> {
        private boolean isOk = true;
        int lastColumn = 0;
        int lastRow = 0;
        int lastElement = 0;
        private DynamicTableModel dynamicTableModel;
        private RectF tableRect;
        private RectF lastElementRect;
        private int totalElements;
        private TableOrder order;
        private int calculatedNumElements;
        private int calculatedRows;
        private int calculatedColumns;

        public TableModelIterator(DynamicTableModel dynamicTableModel2, RectF tableRect, int totalElements) {
            this.dynamicTableModel = dynamicTableModel2;
            this.tableRect = tableRect;
            this.totalElements = totalElements;
            this.order = dynamicTableModel2.getOrder();
            if (dynamicTableModel2.getNumColumns() == 0 && dynamicTableModel2.getNumRows() >= 1) {
                this.calculatedRows = dynamicTableModel2.getNumRows();
                this.calculatedColumns = new Float((double)((float)totalElements / (float)this.calculatedRows) + 0.5).intValue();
            } else if (dynamicTableModel2.getNumRows() == 0 && dynamicTableModel2.getNumColumns() >= 1) {
                this.calculatedColumns = dynamicTableModel2.getNumColumns();
                this.calculatedRows = new Float((double)((float)totalElements / (float)this.calculatedColumns) + 0.5).intValue();
            } else if (dynamicTableModel2.getNumColumns() == 0 && dynamicTableModel2.getNumRows() == 0) {
                this.calculatedRows = 1;
                this.calculatedColumns = totalElements;
            } else {
                this.calculatedRows = dynamicTableModel2.getNumRows();
                this.calculatedColumns = dynamicTableModel2.getNumColumns();
            }
            this.calculatedNumElements = this.calculatedRows * this.calculatedColumns;
            this.lastElementRect = dynamicTableModel2.getCellRect(tableRect, totalElements);
        }

        @Override
        public boolean hasNext() {
            return this.isOk && this.lastElement < this.calculatedNumElements;
        }

        @Override
        public RectF next() {
            if (!this.hasNext()) {
                this.isOk = false;
                throw new IndexOutOfBoundsException();
            }
            if (this.lastElement == 0) {
                ++this.lastElement;
                return this.lastElementRect;
            }
            RectF nextElementRect = new RectF(this.lastElementRect);
            switch (this.order) {
                case ROW_MAJOR: {
                    if (this.dynamicTableModel.getNumColumns() > 0 && this.lastColumn >= this.dynamicTableModel.getNumColumns() - 1) {
                        nextElementRect.offsetTo(this.tableRect.left, this.lastElementRect.bottom);
                        this.lastColumn = 0;
                        ++this.lastRow;
                        break;
                    }
                    nextElementRect.offsetTo(this.lastElementRect.right, this.lastElementRect.top);
                    ++this.lastColumn;
                    break;
                }
                case COLUMN_MAJOR: {
                    if (this.dynamicTableModel.getNumRows() > 0 && this.lastRow >= this.dynamicTableModel.getNumRows() - 1) {
                        nextElementRect.offsetTo(this.lastElementRect.right, this.tableRect.top);
                        this.lastRow = 0;
                        ++this.lastColumn;
                        break;
                    }
                    nextElementRect.offsetTo(this.lastElementRect.left, this.lastElementRect.bottom);
                    ++this.lastRow;
                    break;
                }
                default: {
                    this.isOk = false;
                    throw new IllegalArgumentException();
                }
            }
            ++this.lastElement;
            this.lastElementRect = nextElementRect;
            return nextElementRect;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

