/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui;

import android.graphics.RectF;
import com.androidplot.ui.TableModel;
import com.androidplot.ui.TableOrder;
import java.util.Iterator;

public class FixedTableModel
extends TableModel {
    private float cellWidth;
    private float cellHeight;

    protected FixedTableModel(float cellWidth, float cellHeight, TableOrder order) {
        super(order);
        this.setCellWidth(cellWidth);
        this.setCellHeight(cellHeight);
    }

    @Override
    public Iterator<RectF> getIterator(RectF tableRect, int totalElements) {
        return new FixedTableModelIterator(this, tableRect, totalElements);
    }

    public float getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(float cellWidth) {
        this.cellWidth = cellWidth;
    }

    public float getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(float cellHeight) {
        this.cellHeight = cellHeight;
    }

    private class FixedTableModelIterator
    implements Iterator<RectF> {
        private FixedTableModel model;
        private RectF tableRect;
        private RectF lastRect;
        private int numElements;
        private int lastElement;

        protected FixedTableModelIterator(FixedTableModel model, RectF tableRect, int numElements) {
            this.model = model;
            this.tableRect = tableRect;
            this.numElements = numElements;
            this.lastRect = new RectF(tableRect.left, tableRect.top, tableRect.left + model.getCellWidth(), tableRect.top + model.getCellHeight());
        }

        @Override
        public boolean hasNext() {
            return this.lastElement < this.numElements && (!this.isColumnFinished() || !this.isRowFinished());
        }

        private boolean isColumnFinished() {
            return this.lastRect.bottom + this.model.getCellHeight() > this.tableRect.height();
        }

        private boolean isRowFinished() {
            return this.lastRect.right + this.model.getCellWidth() > this.tableRect.width();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RectF next() {
            try {
                if (this.lastElement == 0) {
                    RectF rectF = this.lastRect;
                    return rectF;
                }
                if (this.lastElement >= this.numElements) {
                    throw new IndexOutOfBoundsException();
                }
                switch (this.model.getOrder()) {
                    case ROW_MAJOR: {
                        if (this.isColumnFinished()) {
                            this.moveOverAndUp();
                            break;
                        }
                        this.moveDown();
                        break;
                    }
                    case COLUMN_MAJOR: {
                        if (this.isRowFinished()) {
                            this.moveDownAndBack();
                            break;
                        }
                        this.moveOver();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                RectF rectF = this.lastRect;
                return rectF;
            }
            finally {
                ++this.lastElement;
            }
        }

        private void moveDownAndBack() {
            this.lastRect.offsetTo(this.tableRect.left, this.lastRect.bottom);
        }

        private void moveOverAndUp() {
            this.lastRect.offsetTo(this.lastRect.right, this.tableRect.top);
        }

        private void moveOver() {
            this.lastRect.offsetTo(this.lastRect.right, this.lastRect.top);
        }

        private void moveDown() {
            this.lastRect.offsetTo(this.lastRect.left, this.lastRect.bottom);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

