/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.PointF;
import android.graphics.RectF;
import com.androidplot.LineRegion;
import com.androidplot.util.ValPixConverter;
import java.util.ArrayList;
import java.util.List;

public class RectRegion {
    LineRegion xLineRegion;
    LineRegion yLineRegion;
    private String label;

    public RectRegion(Number minX, Number maxX, Number minY, Number maxY, String label) {
        this.xLineRegion = new LineRegion(minX, maxX);
        this.yLineRegion = new LineRegion(minY, maxY);
        this.setLabel(label);
    }

    public RectRegion(Number minX, Number maxX, Number minY, Number maxY) {
        this(minX, maxX, minY, maxY, null);
    }

    public boolean containsPoint(PointF point) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public boolean containsValue(Number x, Number y) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public boolean containsDomainValue(Number value) {
        return this.xLineRegion.contains(value);
    }

    public boolean containsRangeValue(Number value) {
        return this.yLineRegion.contains(value);
    }

    public boolean intersects(RectRegion region) {
        return this.intersects(region.getMinX(), region.getMaxX(), region.getMinY(), region.getMaxY());
    }

    public boolean intersects(Number minX, Number maxX, Number minY, Number maxY) {
        return this.xLineRegion.intersects(minX, maxX) && this.yLineRegion.intersects(minY, maxY);
    }

    public boolean intersects(RectF region, Number visMinX, Number visMaxX, Number visMinY, Number visMaxY) {
        RectF thisRegion = this.getRectF(region, visMinX.doubleValue(), visMaxX.doubleValue(), visMinY.doubleValue(), visMaxY.doubleValue());
        return RectF.intersects((RectF)thisRegion, (RectF)region);
    }

    public RectF getRectF(RectF plotRect, Number visMinX, Number visMaxX, Number visMinY, Number visMaxY) {
        PointF topLeftPoint = ValPixConverter.valToPix(this.xLineRegion.getMinVal().doubleValue() != Double.NEGATIVE_INFINITY ? (Number)this.xLineRegion.getMinVal() : (Number)visMinX, this.yLineRegion.getMaxVal().doubleValue() != Double.POSITIVE_INFINITY ? (Number)this.yLineRegion.getMaxVal() : (Number)visMaxY, plotRect, visMinX, visMaxX, visMinY, visMaxY);
        PointF bottomRightPoint = ValPixConverter.valToPix(this.xLineRegion.getMaxVal().doubleValue() != Double.POSITIVE_INFINITY ? (Number)this.xLineRegion.getMaxVal() : (Number)visMaxX, this.yLineRegion.getMinVal().doubleValue() != Double.NEGATIVE_INFINITY ? (Number)this.yLineRegion.getMinVal() : (Number)visMinY, plotRect, visMinX, visMaxX, visMinY, visMaxY);
        return new RectF(topLeftPoint.x, topLeftPoint.y, bottomRightPoint.x, bottomRightPoint.y);
    }

    public static List<RectRegion> regionsWithin(List<RectRegion> regions, Number minX, Number maxX, Number minY, Number maxY) {
        ArrayList<RectRegion> intersectingRegions = new ArrayList<RectRegion>();
        for (RectRegion r : regions) {
            if (!r.intersects(minX, maxX, minY, maxY)) continue;
            intersectingRegions.add(r);
        }
        return intersectingRegions;
    }

    public Number getMinX() {
        return this.xLineRegion.getMinVal();
    }

    public void setMinX(double minX) {
        this.xLineRegion.setMinVal(minX);
    }

    public Number getMaxX() {
        return this.xLineRegion.getMaxVal();
    }

    public void setMaxX(Number maxX) {
        this.xLineRegion.setMaxVal(maxX);
    }

    public Number getMinY() {
        return this.yLineRegion.getMinVal();
    }

    public void setMinY(Number minY) {
        this.yLineRegion.setMinVal(minY);
    }

    public Number getMaxY() {
        return this.yLineRegion.getMaxVal();
    }

    public void setMaxY(Number maxY) {
        this.yLineRegion.setMaxVal(maxY);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

