/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.ui.LayoutManager;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.XPositionMetric;
import com.androidplot.ui.YPositionMetric;
import com.androidplot.ui.widget.Widget;
import com.androidplot.util.FontUtils;
import com.androidplot.util.Mapping;
import com.androidplot.util.ValPixConverter;
import com.androidplot.util.ZHash;
import com.androidplot.util.ZIndexable;
import com.androidplot.xy.AxisValueLabelFormatter;
import com.androidplot.xy.RectRegion;
import com.androidplot.xy.ValueMarker;
import com.androidplot.xy.XValueMarker;
import com.androidplot.xy.XYAxisType;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYSeriesRenderer;
import com.androidplot.xy.XYStep;
import com.androidplot.xy.XYStepCalculator;
import com.androidplot.xy.YValueMarker;
import java.text.DecimalFormat;
import java.text.Format;

public class XYGraphWidget
extends Widget {
    private static final int MARKER_LABEL_SPACING = 2;
    private static final int CURSOR_LABEL_SPACING = 2;
    private static final String TAG = "AndroidPlot";
    private float domainLabelWidth = 15.0f;
    private float rangeLabelWidth = 41.0f;
    private float domainLabelVerticalOffset = -5.0f;
    private float domainLabelHorizontalOffset = 0.0f;
    private float rangeLabelHorizontalOffset = 1.0f;
    private float rangeLabelVerticalOffset = 0.0f;
    private int ticksPerRangeLabel = 1;
    private int ticksPerDomainLabel = 1;
    private float gridPaddingTop = 0.0f;
    private float gridPaddingBottom = 0.0f;
    private float gridPaddingLeft = 0.0f;
    private float gridPaddingRight = 0.0f;
    private int domainLabelTickExtension = 5;
    private int rangeLabelTickExtension = 5;
    private Paint gridBackgroundPaint = new Paint();
    private Paint rangeGridLinePaint;
    private Paint rangeSubGridLinePaint;
    private Paint domainGridLinePaint;
    private Paint domainSubGridLinePaint;
    private Paint domainLabelPaint;
    private Paint rangeLabelPaint;
    private Paint domainCursorPaint;
    private Paint rangeCursorPaint;
    private Paint cursorLabelPaint;
    private Paint cursorLabelBackgroundPaint;
    private XYPlot plot;
    private Format rangeValueFormat;
    private Format domainValueFormat;
    private Paint domainOriginLinePaint;
    private Paint rangeOriginLinePaint;
    private Paint domainOriginLabelPaint;
    private Paint rangeOriginLabelPaint;
    private RectF gridRect;
    private RectF paddedGridRect;
    private float domainCursorPosition;
    private float rangeCursorPosition;
    private boolean drawCursorLabelEnabled = true;
    private boolean drawMarkersEnabled = true;
    private boolean rangeAxisLeft = true;
    private boolean domainAxisBottom = true;
    private float rangeLabelOrientation;
    private float domainLabelOrientation;
    private Mapping<Paint, Number> domainLabelPaintMap;
    private Mapping<Paint, Number> rangeLabelPaintMap;
    private ZHash<RectRegion, AxisValueLabelFormatter> axisValueLabelRegions;

    public float getRangeLabelOrientation() {
        return this.rangeLabelOrientation;
    }

    public void setRangeLabelOrientation(float rangeLabelOrientation) {
        this.rangeLabelOrientation = rangeLabelOrientation;
    }

    public float getDomainLabelOrientation() {
        return this.domainLabelOrientation;
    }

    public void setDomainLabelOrientation(float domainLabelOrientation) {
        this.domainLabelOrientation = domainLabelOrientation;
    }

    public Mapping<Paint, Number> getDomainLabelPaintMap() {
        return this.domainLabelPaintMap;
    }

    public void setDomainLabelPaintMap(Mapping<Paint, Number> domainLabelPaintMap) {
        this.domainLabelPaintMap = domainLabelPaintMap;
    }

    public Mapping<Paint, Number> getRangeLabelPaintMap() {
        return this.rangeLabelPaintMap;
    }

    public void setRangeLabelPaintMap(Mapping<Paint, Number> rangeLabelPaintMap) {
        this.rangeLabelPaintMap = rangeLabelPaintMap;
    }

    public XYGraphWidget(LayoutManager layoutManager, XYPlot plot, SizeMetrics sizeMetrics) {
        super(layoutManager, sizeMetrics);
        this.gridBackgroundPaint.setColor(Color.rgb((int)140, (int)140, (int)140));
        this.gridBackgroundPaint.setStyle(Paint.Style.FILL);
        this.rangeGridLinePaint = new Paint();
        this.rangeGridLinePaint.setColor(Color.rgb((int)180, (int)180, (int)180));
        this.rangeGridLinePaint.setAntiAlias(true);
        this.rangeGridLinePaint.setStyle(Paint.Style.STROKE);
        this.domainGridLinePaint = new Paint(this.rangeGridLinePaint);
        this.domainSubGridLinePaint = new Paint(this.domainGridLinePaint);
        this.rangeSubGridLinePaint = new Paint(this.rangeGridLinePaint);
        this.domainOriginLinePaint = new Paint();
        this.domainOriginLinePaint.setColor(-1);
        this.domainOriginLinePaint.setAntiAlias(true);
        this.rangeOriginLinePaint = new Paint();
        this.rangeOriginLinePaint.setColor(-1);
        this.rangeOriginLinePaint.setAntiAlias(true);
        this.domainOriginLabelPaint = new Paint();
        this.domainOriginLabelPaint.setColor(-1);
        this.domainOriginLabelPaint.setAntiAlias(true);
        this.domainOriginLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.rangeOriginLabelPaint = new Paint();
        this.rangeOriginLabelPaint.setColor(-1);
        this.rangeOriginLabelPaint.setAntiAlias(true);
        this.rangeOriginLabelPaint.setTextAlign(Paint.Align.RIGHT);
        this.domainLabelPaint = new Paint();
        this.domainLabelPaint.setColor(-3355444);
        this.domainLabelPaint.setAntiAlias(true);
        this.domainLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.rangeLabelPaint = new Paint();
        this.rangeLabelPaint.setColor(-3355444);
        this.rangeLabelPaint.setAntiAlias(true);
        this.rangeLabelPaint.setTextAlign(Paint.Align.RIGHT);
        this.domainCursorPaint = new Paint();
        this.domainCursorPaint.setColor(-256);
        this.rangeCursorPaint = new Paint();
        this.rangeCursorPaint.setColor(-256);
        this.cursorLabelPaint = new Paint();
        this.cursorLabelPaint.setColor(-256);
        this.cursorLabelBackgroundPaint = new Paint();
        this.cursorLabelBackgroundPaint.setColor(Color.argb((int)100, (int)50, (int)50, (int)50));
        this.setMarginTop(7.0f);
        this.setMarginRight(4.0f);
        this.setMarginBottom(4.0f);
        this.rangeValueFormat = new DecimalFormat("0.0");
        this.domainValueFormat = new DecimalFormat("0.0");
        this.axisValueLabelRegions = new ZHash();
        this.plot = plot;
    }

    public ZIndexable<RectRegion> getAxisValueLabelRegions() {
        return this.axisValueLabelRegions;
    }

    public void addAxisValueLabelRegion(RectRegion region, AxisValueLabelFormatter formatter) {
        this.axisValueLabelRegions.addToTop(region, formatter);
    }

    public void addDomainAxisValueLabelRegion(double min, double max, AxisValueLabelFormatter formatter) {
        this.addAxisValueLabelRegion(new RectRegion(min, max, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, null), formatter);
    }

    public void addRangeAxisValueLabelRegion(double min, double max, AxisValueLabelFormatter formatter) {
        this.addAxisValueLabelRegion(new RectRegion(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, min, max, null), formatter);
    }

    public AxisValueLabelFormatter getAxisValueLabelFormatterForVal(double x, double y) {
        for (RectRegion r : this.axisValueLabelRegions.elements()) {
            if (!r.containsValue(x, y)) continue;
            return this.axisValueLabelRegions.get(r);
        }
        return null;
    }

    public AxisValueLabelFormatter getAxisValueLabelFormatterForDomainVal(double val) {
        for (RectRegion r : this.axisValueLabelRegions.elements()) {
            if (!r.containsDomainValue(val)) continue;
            return this.axisValueLabelRegions.get(r);
        }
        return null;
    }

    public AxisValueLabelFormatter getAxisValueLabelFormatterForRangeVal(double val) {
        for (RectRegion r : this.axisValueLabelRegions.elements()) {
            if (!r.containsRangeValue(val)) continue;
            return this.axisValueLabelRegions.get(r);
        }
        return null;
    }

    public RectF getGridRect() {
        return this.paddedGridRect;
    }

    private String getFormattedRangeValue(Number value) {
        return this.rangeValueFormat.format(value);
    }

    private String getFormattedDomainValue(Number value) {
        return this.domainValueFormat.format(value);
    }

    public Double getYVal(PointF point) {
        return this.getYVal(point.y);
    }

    public Double getYVal(float yPix) {
        if (this.plot.getCalculatedMinY() == null || this.plot.getCalculatedMaxY() == null) {
            return null;
        }
        return ValPixConverter.pixToVal(yPix - this.paddedGridRect.top, this.plot.getCalculatedMinY().doubleValue(), this.plot.getCalculatedMaxY().doubleValue(), this.paddedGridRect.height(), true);
    }

    public Double getXVal(PointF point) {
        return this.getXVal(point.x);
    }

    public Double getXVal(float xPix) {
        if (this.plot.getCalculatedMinX() == null || this.plot.getCalculatedMaxX() == null) {
            return null;
        }
        return ValPixConverter.pixToVal(xPix - this.paddedGridRect.left, this.plot.getCalculatedMinX().doubleValue(), this.plot.getCalculatedMaxX().doubleValue(), this.paddedGridRect.width(), false);
    }

    @Override
    protected void doOnDraw(Canvas canvas, RectF widgetRect) throws PlotRenderException {
        this.gridRect = this.getGridRect(widgetRect);
        this.paddedGridRect = this.getPaddedGridRect(this.gridRect);
        if (this.paddedGridRect.height() > 0.0f && this.paddedGridRect.width() > 0.0f && this.plot.getCalculatedMinX() != null && this.plot.getCalculatedMaxX() != null && this.plot.getCalculatedMinY() != null && this.plot.getCalculatedMaxY() != null) {
            this.drawGrid(canvas);
            this.drawData(canvas);
            this.drawCursors(canvas);
            if (this.isDrawMarkersEnabled()) {
                this.drawMarkers(canvas);
            }
        }
    }

    private RectF getGridRect(RectF widgetRect) {
        return new RectF(widgetRect.left + (this.rangeAxisLeft ? this.rangeLabelWidth : 1.0f), widgetRect.top + (this.domainAxisBottom ? 1.0f : this.domainLabelWidth), widgetRect.right - (this.rangeAxisLeft ? 1.0f : this.rangeLabelWidth), widgetRect.bottom - (this.domainAxisBottom ? this.domainLabelWidth : 1.0f));
    }

    private RectF getPaddedGridRect(RectF gridRect) {
        return new RectF(gridRect.left + this.gridPaddingLeft, gridRect.top + this.gridPaddingTop, gridRect.right - this.gridPaddingRight, gridRect.bottom - this.gridPaddingBottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTickText(Canvas canvas, XYAxisType axis, Number value, float xPix, float yPix, Paint labelPaint) {
        AxisValueLabelFormatter rf = null;
        String txt = null;
        double v = value.doubleValue();
        int canvasState = canvas.save();
        try {
            Paint p;
            switch (axis) {
                case DOMAIN: {
                    rf = this.getAxisValueLabelFormatterForDomainVal(v);
                    txt = this.getFormattedDomainValue(value);
                    canvas.rotate(this.getDomainLabelOrientation(), xPix, yPix);
                    break;
                }
                case RANGE: {
                    rf = this.getAxisValueLabelFormatterForRangeVal(v);
                    txt = this.getFormattedRangeValue(value);
                    canvas.rotate(this.getRangeLabelOrientation(), xPix, yPix);
                }
            }
            if (rf != null) {
                p = new Paint(labelPaint);
                p.setColor(rf.getColor());
            } else {
                p = labelPaint;
            }
            canvas.drawText(txt, xPix, yPix, p);
        }
        finally {
            canvas.restoreToCount(canvasState);
        }
    }

    private void drawDomainTick(Canvas canvas, float xPix, Number xVal, Paint labelPaint, Paint linePaint, boolean drawLineOnly) {
        if (!drawLineOnly) {
            if (linePaint != null) {
                if (this.domainAxisBottom) {
                    canvas.drawLine(xPix, this.gridRect.top, xPix, this.gridRect.bottom + (float)this.domainLabelTickExtension, linePaint);
                } else {
                    canvas.drawLine(xPix, this.gridRect.top - (float)this.domainLabelTickExtension, xPix, this.gridRect.bottom, linePaint);
                }
            }
            if (labelPaint != null) {
                float fontHeight = FontUtils.getFontHeight(labelPaint);
                float yPix = this.domainAxisBottom ? this.gridRect.bottom + (float)this.domainLabelTickExtension + this.domainLabelVerticalOffset + fontHeight : this.gridRect.top - (float)this.domainLabelTickExtension - this.domainLabelVerticalOffset;
                this.drawTickText(canvas, XYAxisType.DOMAIN, xVal, xPix + this.domainLabelHorizontalOffset, yPix, labelPaint);
            }
        } else if (linePaint != null) {
            canvas.drawLine(xPix, this.gridRect.top, xPix, this.gridRect.bottom, linePaint);
        }
    }

    public void drawRangeTick(Canvas canvas, float yPix, Number yVal, Paint labelPaint, Paint linePaint, boolean drawLineOnly) {
        if (!drawLineOnly) {
            if (linePaint != null) {
                if (this.rangeAxisLeft) {
                    canvas.drawLine(this.gridRect.left - (float)this.rangeLabelTickExtension, yPix, this.gridRect.right, yPix, linePaint);
                } else {
                    canvas.drawLine(this.gridRect.left, yPix, this.gridRect.right + (float)this.rangeLabelTickExtension, yPix, linePaint);
                }
            }
            if (labelPaint != null) {
                float xPix = this.rangeAxisLeft ? this.gridRect.left - ((float)this.rangeLabelTickExtension + this.rangeLabelHorizontalOffset) : this.gridRect.right + ((float)this.rangeLabelTickExtension + this.rangeLabelHorizontalOffset);
                this.drawTickText(canvas, XYAxisType.RANGE, yVal, xPix, yPix - this.rangeLabelVerticalOffset, labelPaint);
            }
        } else if (linePaint != null) {
            canvas.drawLine(this.gridRect.left, yPix, this.gridRect.right, yPix, linePaint);
        }
    }

    protected void drawGrid(Canvas canvas) {
        Paint rlp;
        float rangeOriginF;
        Paint dlp;
        double xVal;
        float domainOriginF;
        if (this.gridBackgroundPaint != null) {
            canvas.drawRect(this.gridRect, this.gridBackgroundPaint);
        }
        if (this.plot.getDomainOrigin() != null) {
            double domainOriginVal = this.plot.getDomainOrigin().doubleValue();
            domainOriginF = ValPixConverter.valToPix(domainOriginVal, this.plot.getCalculatedMinX().doubleValue(), this.plot.getCalculatedMaxX().doubleValue(), this.paddedGridRect.width(), false);
            domainOriginF += this.paddedGridRect.left;
        } else {
            domainOriginF = this.paddedGridRect.left;
        }
        XYStep domainStep = XYStepCalculator.getStep(this.plot, XYAxisType.DOMAIN, this.paddedGridRect, (Number)this.plot.getCalculatedMinX().doubleValue(), (Number)this.plot.getCalculatedMaxX().doubleValue());
        if (domainOriginF >= this.paddedGridRect.left && domainOriginF <= this.paddedGridRect.right) {
            Paint olp;
            if (this.domainOriginLinePaint != null) {
                this.domainOriginLinePaint.setTextAlign(Paint.Align.CENTER);
            }
            Paint paint = olp = this.domainLabelPaintMap != null ? this.domainLabelPaintMap.get(this.plot.getDomainOrigin()) : this.domainLabelPaint;
            if (olp == null) {
                olp = this.domainLabelPaint;
            }
            this.drawDomainTick(canvas, domainOriginF, this.plot.getDomainOrigin().doubleValue(), olp, this.domainOriginLinePaint, false);
        }
        int i = 1;
        float xPix = domainOriginF - domainStep.getStepPix();
        while (xPix >= this.paddedGridRect.left) {
            xVal = this.plot.getDomainOrigin().doubleValue() - (double)i * domainStep.getStepVal();
            Paint paint = dlp = this.domainLabelPaintMap != null ? this.domainLabelPaintMap.get(xVal) : this.domainLabelPaint;
            if (dlp == null) {
                dlp = this.domainLabelPaint;
            }
            if (xPix >= this.paddedGridRect.left && xPix <= this.paddedGridRect.right) {
                if (i % this.getTicksPerDomainLabel() == 0) {
                    this.drawDomainTick(canvas, xPix, xVal, dlp, this.domainGridLinePaint, false);
                } else {
                    this.drawDomainTick(canvas, xPix, xVal, dlp, this.domainSubGridLinePaint, true);
                }
            }
            xPix = domainOriginF - (float)(++i) * domainStep.getStepPix();
        }
        i = 1;
        xPix = domainOriginF + domainStep.getStepPix();
        while (xPix <= this.paddedGridRect.right) {
            xVal = this.plot.getDomainOrigin().doubleValue() + (double)i * domainStep.getStepVal();
            Paint paint = dlp = this.domainLabelPaintMap != null ? this.domainLabelPaintMap.get(xVal) : this.domainLabelPaint;
            if (dlp == null) {
                dlp = this.domainLabelPaint;
            }
            if (xPix >= this.paddedGridRect.left && xPix <= this.paddedGridRect.right) {
                if (i % this.getTicksPerDomainLabel() == 0) {
                    this.drawDomainTick(canvas, xPix, xVal, dlp, this.domainGridLinePaint, false);
                } else {
                    this.drawDomainTick(canvas, xPix, xVal, dlp, this.domainSubGridLinePaint, true);
                }
            }
            xPix = domainOriginF + (float)(++i) * domainStep.getStepPix();
        }
        if (this.plot.getRangeOrigin() != null) {
            double rangeOriginD = this.plot.getRangeOrigin().doubleValue();
            rangeOriginF = ValPixConverter.valToPix(rangeOriginD, this.plot.getCalculatedMinY().doubleValue(), this.plot.getCalculatedMaxY().doubleValue(), this.paddedGridRect.height(), true);
            rangeOriginF += this.paddedGridRect.top;
        } else {
            rangeOriginF = this.paddedGridRect.bottom;
        }
        XYStep rangeStep = XYStepCalculator.getStep(this.plot, XYAxisType.RANGE, this.paddedGridRect, (Number)this.plot.getCalculatedMinY().doubleValue(), (Number)this.plot.getCalculatedMaxY().doubleValue());
        if (rangeOriginF >= this.paddedGridRect.top && rangeOriginF <= this.paddedGridRect.bottom) {
            Paint olp;
            if (this.rangeOriginLinePaint != null) {
                this.rangeOriginLinePaint.setTextAlign(Paint.Align.RIGHT);
            }
            Paint paint = olp = this.rangeLabelPaintMap != null ? this.rangeLabelPaintMap.get(this.plot.getRangeOrigin()) : this.rangeLabelPaint;
            if (olp == null) {
                olp = this.rangeLabelPaint;
            }
            this.drawRangeTick(canvas, rangeOriginF, this.plot.getRangeOrigin().doubleValue(), olp, this.rangeOriginLinePaint, false);
        }
        int i2 = 1;
        float yPix = rangeOriginF - rangeStep.getStepPix();
        while (yPix >= this.paddedGridRect.top) {
            double yVal = this.plot.getRangeOrigin().doubleValue() + (double)i2 * rangeStep.getStepVal();
            Paint paint = rlp = this.rangeLabelPaintMap != null ? this.rangeLabelPaintMap.get(yVal) : this.rangeLabelPaint;
            if (rlp == null) {
                rlp = this.rangeLabelPaint;
            }
            if (yPix >= this.paddedGridRect.top && yPix <= this.paddedGridRect.bottom) {
                if (i2 % this.getTicksPerRangeLabel() == 0) {
                    this.drawRangeTick(canvas, yPix, yVal, rlp, this.rangeGridLinePaint, false);
                } else {
                    this.drawRangeTick(canvas, yPix, yVal, rlp, this.rangeSubGridLinePaint, true);
                }
            }
            yPix = rangeOriginF - (float)(++i2) * rangeStep.getStepPix();
        }
        i2 = 1;
        yPix = rangeOriginF + rangeStep.getStepPix();
        while (yPix <= this.paddedGridRect.bottom) {
            double yVal = this.plot.getRangeOrigin().doubleValue() - (double)i2 * rangeStep.getStepVal();
            Paint paint = rlp = this.rangeLabelPaintMap != null ? this.rangeLabelPaintMap.get(yVal) : this.rangeLabelPaint;
            if (rlp == null) {
                rlp = this.rangeLabelPaint;
            }
            if (yPix >= this.paddedGridRect.top && yPix <= this.paddedGridRect.bottom) {
                if (i2 % this.getTicksPerRangeLabel() == 0) {
                    this.drawRangeTick(canvas, yPix, yVal, rlp, this.rangeGridLinePaint, false);
                } else {
                    this.drawRangeTick(canvas, yPix, yVal, rlp, this.rangeSubGridLinePaint, true);
                }
            }
            yPix = rangeOriginF + (float)(++i2) * rangeStep.getStepPix();
        }
    }

    private void drawMarkerText(Canvas canvas, String text, ValueMarker marker, float x, float y) {
        RectF textRect = new RectF(FontUtils.getStringDimensions(text, marker.getTextPaint()));
        textRect.offsetTo(x += 2.0f, (y -= 2.0f) - textRect.height());
        if (textRect.right > this.paddedGridRect.right) {
            textRect.offset(-(textRect.right - this.paddedGridRect.right), 0.0f);
        }
        if (textRect.top < this.paddedGridRect.top) {
            textRect.offset(0.0f, this.paddedGridRect.top - textRect.top);
        }
        canvas.drawText(text, textRect.left, textRect.bottom, marker.getTextPaint());
    }

    protected void drawMarkers(Canvas canvas) {
        for (YValueMarker yValueMarker : this.plot.getYValueMarkers()) {
            if (yValueMarker.getValue() == null) continue;
            double yVal = yValueMarker.getValue().doubleValue();
            float yPix = ValPixConverter.valToPix(yVal, this.plot.getCalculatedMinY().doubleValue(), this.plot.getCalculatedMaxY().doubleValue(), this.paddedGridRect.height(), true);
            canvas.drawLine(this.paddedGridRect.left, yPix += this.paddedGridRect.top, this.paddedGridRect.right, yPix, yValueMarker.getLinePaint());
            float xPix = ((XPositionMetric)yValueMarker.getTextPosition()).getPixelValue(this.paddedGridRect.width());
            xPix += this.paddedGridRect.left;
            if (yValueMarker.getText() != null) {
                this.drawMarkerText(canvas, yValueMarker.getText(), yValueMarker, xPix, yPix);
                continue;
            }
            this.drawMarkerText(canvas, this.getFormattedRangeValue(yValueMarker.getValue()), yValueMarker, xPix, yPix);
        }
        for (XValueMarker xValueMarker : this.plot.getXValueMarkers()) {
            if (xValueMarker.getValue() == null) continue;
            double xVal = xValueMarker.getValue().doubleValue();
            float xPix = ValPixConverter.valToPix(xVal, this.plot.getCalculatedMinX().doubleValue(), this.plot.getCalculatedMaxX().doubleValue(), this.paddedGridRect.width(), false);
            canvas.drawLine(xPix += this.paddedGridRect.left, this.paddedGridRect.top, xPix, this.paddedGridRect.bottom, xValueMarker.getLinePaint());
            float yPix = ((YPositionMetric)xValueMarker.getTextPosition()).getPixelValue(this.paddedGridRect.height());
            yPix += this.paddedGridRect.top;
            if (xValueMarker.getText() != null) {
                this.drawMarkerText(canvas, xValueMarker.getText(), xValueMarker, xPix, yPix);
                continue;
            }
            this.drawMarkerText(canvas, this.getFormattedDomainValue(xValueMarker.getValue()), xValueMarker, xPix, yPix);
        }
    }

    protected void drawCursors(Canvas canvas) {
        boolean hasDomainCursor = false;
        if (this.domainCursorPaint != null && this.domainCursorPosition <= this.paddedGridRect.right && this.domainCursorPosition >= this.paddedGridRect.left) {
            hasDomainCursor = true;
            canvas.drawLine(this.domainCursorPosition, this.paddedGridRect.top, this.domainCursorPosition, this.paddedGridRect.bottom, this.domainCursorPaint);
        }
        boolean hasRangeCursor = false;
        if (this.rangeCursorPaint != null && this.rangeCursorPosition >= this.paddedGridRect.top && this.rangeCursorPosition <= this.paddedGridRect.bottom) {
            hasRangeCursor = true;
            canvas.drawLine(this.paddedGridRect.left, this.rangeCursorPosition, this.paddedGridRect.right, this.rangeCursorPosition, this.rangeCursorPaint);
        }
        if (this.drawCursorLabelEnabled && this.cursorLabelPaint != null && hasRangeCursor && hasDomainCursor) {
            String label = "X=" + this.getDomainValueFormat().format(this.getDomainCursorVal());
            label = label + " Y=" + this.getRangeValueFormat().format(this.getRangeCursorVal());
            RectF cursorRect = new RectF(FontUtils.getPackedStringDimensions(label, this.cursorLabelPaint));
            cursorRect.offsetTo(this.domainCursorPosition, this.rangeCursorPosition - cursorRect.height());
            if (cursorRect.right >= this.paddedGridRect.right) {
                cursorRect.offsetTo(this.domainCursorPosition - cursorRect.width(), cursorRect.top);
            }
            if (cursorRect.top <= this.paddedGridRect.top) {
                cursorRect.offsetTo(cursorRect.left, this.rangeCursorPosition);
            }
            if (this.cursorLabelBackgroundPaint != null) {
                canvas.drawRect(cursorRect, this.cursorLabelBackgroundPaint);
            }
            canvas.drawText(label, cursorRect.left, cursorRect.bottom, this.cursorLabelPaint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawData(Canvas canvas) throws PlotRenderException {
        try {
            canvas.save(31);
            canvas.clipRect(this.gridRect, Region.Op.INTERSECT);
            for (XYSeriesRenderer renderer : this.plot.getRendererList()) {
                renderer.render(canvas, this.paddedGridRect);
            }
        }
        finally {
            canvas.restore();
        }
    }

    protected void drawPoint(Canvas canvas, PointF point, Paint paint) {
        canvas.drawPoint(point.x, point.y, paint);
    }

    public float getDomainLabelWidth() {
        return this.domainLabelWidth;
    }

    public void setDomainLabelWidth(float domainLabelWidth) {
        this.domainLabelWidth = domainLabelWidth;
    }

    public float getRangeLabelWidth() {
        return this.rangeLabelWidth;
    }

    public void setRangeLabelWidth(float rangeLabelWidth) {
        this.rangeLabelWidth = rangeLabelWidth;
    }

    public float getDomainLabelVerticalOffset() {
        return this.domainLabelVerticalOffset;
    }

    public void setDomainLabelVerticalOffset(float domainLabelVerticalOffset) {
        this.domainLabelVerticalOffset = domainLabelVerticalOffset;
    }

    public float getDomainLabelHorizontalOffset() {
        return this.domainLabelHorizontalOffset;
    }

    public void setDomainLabelHorizontalOffset(float domainLabelHorizontalOffset) {
        this.domainLabelHorizontalOffset = domainLabelHorizontalOffset;
    }

    public float getRangeLabelHorizontalOffset() {
        return this.rangeLabelHorizontalOffset;
    }

    public void setRangeLabelHorizontalOffset(float rangeLabelHorizontalOffset) {
        this.rangeLabelHorizontalOffset = rangeLabelHorizontalOffset;
    }

    public float getRangeLabelVerticalOffset() {
        return this.rangeLabelVerticalOffset;
    }

    public void setRangeLabelVerticalOffset(float rangeLabelVerticalOffset) {
        this.rangeLabelVerticalOffset = rangeLabelVerticalOffset;
    }

    public Paint getGridBackgroundPaint() {
        return this.gridBackgroundPaint;
    }

    public void setGridBackgroundPaint(Paint gridBackgroundPaint) {
        this.gridBackgroundPaint = gridBackgroundPaint;
    }

    public Paint getDomainLabelPaint() {
        return this.domainLabelPaint;
    }

    public void setDomainLabelPaint(Paint domainLabelPaint) {
        this.domainLabelPaint = domainLabelPaint;
    }

    public Paint getRangeLabelPaint() {
        return this.rangeLabelPaint;
    }

    public void setRangeLabelPaint(Paint rangeLabelPaint) {
        this.rangeLabelPaint = rangeLabelPaint;
    }

    public Paint getDomainGridLinePaint() {
        return this.domainGridLinePaint;
    }

    public void setDomainGridLinePaint(Paint gridLinePaint) {
        this.domainGridLinePaint = gridLinePaint;
    }

    public Paint getRangeGridLinePaint() {
        return this.rangeGridLinePaint;
    }

    public Paint getDomainSubGridLinePaint() {
        return this.domainSubGridLinePaint;
    }

    public void setDomainSubGridLinePaint(Paint gridLinePaint) {
        this.domainSubGridLinePaint = gridLinePaint;
    }

    public void setRangeGridLinePaint(Paint gridLinePaint) {
        this.rangeGridLinePaint = gridLinePaint;
    }

    public Paint getRangeSubGridLinePaint() {
        return this.rangeSubGridLinePaint;
    }

    public void setRangeSubGridLinePaint(Paint gridLinePaint) {
        this.rangeSubGridLinePaint = gridLinePaint;
    }

    public Format getRangeValueFormat() {
        return this.rangeValueFormat;
    }

    public void setRangeValueFormat(Format rangeValueFormat) {
        this.rangeValueFormat = rangeValueFormat;
    }

    public Format getDomainValueFormat() {
        return this.domainValueFormat;
    }

    public void setDomainValueFormat(Format domainValueFormat) {
        this.domainValueFormat = domainValueFormat;
    }

    public int getDomainLabelTickExtension() {
        return this.domainLabelTickExtension;
    }

    public void setDomainLabelTickExtension(int domainLabelTickExtension) {
        this.domainLabelTickExtension = domainLabelTickExtension;
    }

    public int getRangeLabelTickExtension() {
        return this.rangeLabelTickExtension;
    }

    public void setRangeLabelTickExtension(int rangeLabelTickExtension) {
        this.rangeLabelTickExtension = rangeLabelTickExtension;
    }

    public int getTicksPerRangeLabel() {
        return this.ticksPerRangeLabel;
    }

    public void setTicksPerRangeLabel(int ticksPerRangeLabel) {
        this.ticksPerRangeLabel = ticksPerRangeLabel;
    }

    public int getTicksPerDomainLabel() {
        return this.ticksPerDomainLabel;
    }

    public void setTicksPerDomainLabel(int ticksPerDomainLabel) {
        this.ticksPerDomainLabel = ticksPerDomainLabel;
    }

    public void setGridPaddingTop(float gridPaddingTop) {
        this.gridPaddingTop = gridPaddingTop;
    }

    public float getGridPaddingBottom() {
        return this.gridPaddingBottom;
    }

    public void setGridPaddingBottom(float gridPaddingBottom) {
        this.gridPaddingBottom = gridPaddingBottom;
    }

    public float getGridPaddingLeft() {
        return this.gridPaddingLeft;
    }

    public void setGridPaddingLeft(float gridPaddingLeft) {
        this.gridPaddingLeft = gridPaddingLeft;
    }

    public float getGridPaddingRight() {
        return this.gridPaddingRight;
    }

    public void setGridPaddingRight(float gridPaddingRight) {
        this.gridPaddingRight = gridPaddingRight;
    }

    public float getGridPaddingTop() {
        return this.gridPaddingTop;
    }

    public void setGridPadding(float left, float top, float right, float bottom) {
        this.setGridPaddingLeft(left);
        this.setGridPaddingTop(top);
        this.setGridPaddingRight(right);
        this.setGridPaddingBottom(bottom);
    }

    public Paint getDomainOriginLinePaint() {
        return this.domainOriginLinePaint;
    }

    public void setDomainOriginLinePaint(Paint domainOriginLinePaint) {
        this.domainOriginLinePaint = domainOriginLinePaint;
    }

    public Paint getRangeOriginLinePaint() {
        return this.rangeOriginLinePaint;
    }

    public void setRangeOriginLinePaint(Paint rangeOriginLinePaint) {
        this.rangeOriginLinePaint = rangeOriginLinePaint;
    }

    public Paint getDomainOriginLabelPaint() {
        return this.domainOriginLabelPaint;
    }

    public void setDomainOriginLabelPaint(Paint domainOriginLabelPaint) {
        this.domainOriginLabelPaint = domainOriginLabelPaint;
    }

    public Paint getRangeOriginLabelPaint() {
        return this.rangeOriginLabelPaint;
    }

    public void setRangeOriginLabelPaint(Paint rangeOriginLabelPaint) {
        this.rangeOriginLabelPaint = rangeOriginLabelPaint;
    }

    public void setCursorPosition(float x, float y) {
        this.setDomainCursorPosition(x);
        this.setRangeCursorPosition(y);
    }

    public void setCursorPosition(PointF point) {
        this.setCursorPosition(point.x, point.y);
    }

    public float getDomainCursorPosition() {
        return this.domainCursorPosition;
    }

    public Double getDomainCursorVal() {
        return this.getXVal(this.getDomainCursorPosition());
    }

    public void setDomainCursorPosition(float domainCursorPosition) {
        this.domainCursorPosition = domainCursorPosition;
    }

    public float getRangeCursorPosition() {
        return this.rangeCursorPosition;
    }

    public Double getRangeCursorVal() {
        return this.getYVal(this.getRangeCursorPosition());
    }

    public void setRangeCursorPosition(float rangeCursorPosition) {
        this.rangeCursorPosition = rangeCursorPosition;
    }

    public Paint getCursorLabelPaint() {
        return this.cursorLabelPaint;
    }

    public void setCursorLabelPaint(Paint cursorLabelPaint) {
        this.cursorLabelPaint = cursorLabelPaint;
    }

    public Paint getCursorLabelBackgroundPaint() {
        return this.cursorLabelBackgroundPaint;
    }

    public void setCursorLabelBackgroundPaint(Paint cursorLabelBackgroundPaint) {
        this.cursorLabelBackgroundPaint = cursorLabelBackgroundPaint;
    }

    public boolean isDrawMarkersEnabled() {
        return this.drawMarkersEnabled;
    }

    public void setDrawMarkersEnabled(boolean drawMarkersEnabled) {
        this.drawMarkersEnabled = drawMarkersEnabled;
    }

    public boolean isRangeAxisLeft() {
        return this.rangeAxisLeft;
    }

    public void setRangeAxisLeft(boolean rangeAxisLeft) {
        this.rangeAxisLeft = rangeAxisLeft;
    }

    public boolean isDomainAxisBottom() {
        return this.domainAxisBottom;
    }

    public void setDomainAxisBottom(boolean domainAxisBottom) {
        this.domainAxisBottom = domainAxisBottom;
    }

    public void setRangeAxisPosition(boolean rangeAxisLeft, boolean rangeAxisOverlay, int tickSize, String maxLableString) {
        this.setRangeAxisLeft(rangeAxisLeft);
        if (rangeAxisOverlay) {
            Paint po;
            this.setRangeLabelWidth(1.0f);
            this.setRangeLabelHorizontalOffset(-2.0f);
            this.setRangeLabelVerticalOffset(2.0f);
            Paint p = this.getRangeLabelPaint();
            if (p != null) {
                p.setTextAlign(rangeAxisLeft ? Paint.Align.LEFT : Paint.Align.RIGHT);
            }
            if ((po = this.getRangeOriginLabelPaint()) != null) {
                po.setTextAlign(rangeAxisLeft ? Paint.Align.LEFT : Paint.Align.RIGHT);
            }
            this.setRangeLabelTickExtension(0);
        } else {
            Paint po;
            this.setRangeLabelWidth(1.0f);
            this.setRangeLabelHorizontalOffset(1.0f);
            this.setRangeLabelTickExtension(tickSize);
            Paint p = this.getRangeLabelPaint();
            if (p != null) {
                p.setTextAlign(!rangeAxisLeft ? Paint.Align.LEFT : Paint.Align.RIGHT);
                Rect r = FontUtils.getPackedStringDimensions(maxLableString, p);
                this.setRangeLabelVerticalOffset(r.top / 2);
                this.setRangeLabelWidth(r.right + this.getRangeLabelTickExtension());
            }
            if ((po = this.getRangeOriginLabelPaint()) != null) {
                po.setTextAlign(!rangeAxisLeft ? Paint.Align.LEFT : Paint.Align.RIGHT);
            }
        }
    }

    public void setDomainAxisPosition(boolean domainAxisBottom, boolean domainAxisOverlay, int tickSize, String maxLabelString) {
        this.setDomainAxisBottom(domainAxisBottom);
        if (domainAxisOverlay) {
            this.setDomainLabelWidth(1.0f);
            this.setDomainLabelVerticalOffset(2.0f);
            this.setDomainLabelTickExtension(0);
            Paint p = this.getDomainLabelPaint();
            if (p != null) {
                Rect r = FontUtils.getPackedStringDimensions(maxLabelString, p);
                if (domainAxisBottom) {
                    this.setDomainLabelVerticalOffset(2 * r.top);
                } else {
                    this.setDomainLabelVerticalOffset((float)r.top - 1.0f);
                }
            }
        } else {
            this.setDomainLabelWidth(1.0f);
            this.setDomainLabelTickExtension(tickSize);
            Paint p = this.getDomainLabelPaint();
            if (p != null) {
                float fontHeight = FontUtils.getFontHeight(p);
                if (domainAxisBottom) {
                    this.setDomainLabelVerticalOffset(-4.0f);
                } else {
                    this.setDomainLabelVerticalOffset(1.0f);
                }
                this.setDomainLabelWidth(fontHeight + (float)this.getDomainLabelTickExtension());
            }
        }
    }

    public static enum XYPlotOrientation {
        HORIZONTAL,
        VERTICAL;

    }
}

