/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesBase;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MouseAction;
import com.applitools.eyes.ProxySettings;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.utils.ArgumentGuard;
import java.awt.image.BufferedImage;
import java.net.URI;

public class Eyes
extends EyesBase {
    public static void setLogHandler(LogHandler logHandler) {
        Logger.setLogHandler((LogHandler)logHandler);
    }

    public static void setApiKey(String apiKey) {
        EyesBase.setApiKey((String)apiKey);
    }

    public static String getApiKey() {
        return EyesBase.getApiKey();
    }

    public static void setProxy(ProxySettings proxySettings) {
        EyesBase.setProxy((ProxySettings)proxySettings);
    }

    public static ProxySettings getProxy() {
        return EyesBase.getProxy();
    }

    public Eyes(URI serverUrl, boolean isDisabled) {
        super(serverUrl, isDisabled);
    }

    public Eyes(URI serverUrl) {
        this(serverUrl, false);
    }

    public Eyes() {
        this(Eyes.getDefaultServerUrl());
    }

    public void open(String appName, String testName, RectangleSize viewportSize, MatchLevel matchLevel, FailureReports failureReports) {
        super.open(appName, testName, viewportSize, matchLevel, failureReports);
    }

    public void open(String appName, String testName, RectangleSize viewportSize, MatchLevel matchLevel) {
        this.open(appName, testName, viewportSize, matchLevel, FailureReports.ON_CLOSE);
    }

    public void open(String appName, String testName, RectangleSize viewportSize, FailureReports failureReports) {
        this.open(appName, testName, viewportSize, DEFAULT_MATCH_LEVEL, failureReports);
    }

    public void open(String appName, String testName, RectangleSize viewportSize) {
        this.open(appName, testName, viewportSize, DEFAULT_MATCH_LEVEL, FailureReports.ON_CLOSE);
    }

    public void open(String appName, String testName) {
        this.open(appName, testName, null, DEFAULT_MATCH_LEVEL, FailureReports.ON_CLOSE);
    }

    public void checkRegion(BufferedImage image, Region region, String tag, boolean ignoreMismatch) {
        if (this.getIsDisabled()) {
            Logger.verbose((String)"CheckRegion(Image, Region, String, boolean): Ignored");
            return;
        }
        ArgumentGuard.notNull((Object)image, (String)"image cannot be null!");
        ArgumentGuard.notNull((Object)region, (String)"region cannot be null!");
        if (this.runningSession == null && this.getViewportSize() == null) {
            this.setViewportSize(new RectangleSize(image.getWidth(), image.getHeight()));
        }
        super.checkRegion(image, region, tag, ignoreMismatch);
    }

    public void checkRegion(BufferedImage image, Region region, String tag) {
        this.checkRegion(image, region, tag, false);
    }

    public void checkRegion(BufferedImage image, Region region) {
        this.checkRegion(image, region, null, false);
    }

    public void checkWindow(BufferedImage image, String tag, boolean ignoreMismatch) {
        this.checkRegion(image, Region.EMPTY, tag, ignoreMismatch);
    }

    public void checkWindow(BufferedImage image, String tag) {
        this.checkWindow(image, tag, false);
    }

    public void checkWindow(BufferedImage image) {
        this.checkWindow(image, null, false);
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        super.addMouseTrigger(action, control, cursor);
    }

    public void addTextTrigger(Region control, String text) {
        super.addTextTrigger(control, text);
    }

    public String getAgentId() {
        return "Eyes.Java/2.13";
    }

    protected String getInferredEnvironment() {
        return null;
    }

    protected String getTitle() {
        return null;
    }
}

