/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesImagesScreenshot;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MouseAction;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RegionProvider;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.net.URI;

public class Eyes
extends EyesBase {
    private String title;
    private EyesImagesScreenshot screenshot;
    private String inferred;

    public Eyes(URI serverUrl) {
        super(serverUrl);
    }

    public Eyes() {
        this(Eyes.getDefaultServerUrl());
    }

    public String getBaseAgentId() {
        return "eyes.images.java/2.44";
    }

    public void open(String appName, String testName, RectangleSize dimensions) {
        this.openBase(appName, testName, dimensions, null);
    }

    public void open(String appName, String testName) {
        this.open(appName, testName, null);
    }

    @Deprecated
    public boolean checkWindow(BufferedImage image) {
        return this.checkImage(image);
    }

    @Deprecated
    public boolean checkWindow(BufferedImage image, String tag) {
        return this.checkImage(image, tag);
    }

    @Deprecated
    public boolean checkWindow(BufferedImage image, String tag, boolean ignoreMismatch) {
        return this.checkImage(image, tag, ignoreMismatch);
    }

    public boolean checkImage(BufferedImage image) {
        return this.checkImage(image, null);
    }

    public boolean checkImage(BufferedImage image, String tag) {
        return this.checkImage(image, tag, false);
    }

    public boolean checkImage(BufferedImage image, String tag, boolean ignoreMismatch) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("CheckImage(Image, '%s', %b): Ignored", tag, ignoreMismatch));
            return false;
        }
        ArgumentGuard.notNull((Object)image, (String)"image cannot be null!");
        this.logger.verbose(String.format("CheckImage(Image, '%s', %b)", tag, ignoreMismatch));
        if (this.viewportSize == null) {
            this.setViewportSize(new RectangleSize(image.getWidth(), image.getHeight()));
        }
        return this.checkImage_(new RegionProvider(){

            public Region getRegion() {
                return Region.EMPTY;
            }

            public CoordinatesType getCoordinatesType() {
                return null;
            }
        }, image, tag, ignoreMismatch);
    }

    public boolean checkImage(String path) {
        return this.checkImage(path, null);
    }

    public boolean checkImage(String path, String tag) {
        return this.checkImage(path, tag, false);
    }

    public boolean checkImage(String path, String tag, boolean ignoreMismatch) {
        return this.checkImage(ImageUtils.imageFromFile((String)path), tag, ignoreMismatch);
    }

    public boolean checkImage(byte[] image) {
        return this.checkImage(image, null);
    }

    public boolean checkImage(byte[] image, String tag) {
        return this.checkImage(image, tag, false);
    }

    public boolean checkImage(byte[] image, String tag, boolean ignoreMismatch) {
        return this.checkImage(ImageUtils.imageFromBytes((byte[])image), tag, ignoreMismatch);
    }

    public boolean checkRegion(BufferedImage image, final Region region, String tag, boolean ignoreMismatch) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("CheckRegion(Image, [%s], '%s', %b): Ignored", region, tag, ignoreMismatch));
            return false;
        }
        ArgumentGuard.notNull((Object)image, (String)"image cannot be null!");
        ArgumentGuard.notNull((Object)region, (String)"region cannot be null!");
        this.logger.verbose(String.format("CheckRegion(Image, [%s], '%s', %b)", region, tag, ignoreMismatch));
        if (this.viewportSize == null) {
            this.setViewportSize(new RectangleSize(image.getWidth(), image.getHeight()));
        }
        return this.checkImage_(new RegionProvider(){

            public Region getRegion() {
                return region;
            }

            public CoordinatesType getCoordinatesType() {
                return CoordinatesType.SCREENSHOT_AS_IS;
            }
        }, image, tag, ignoreMismatch);
    }

    public void checkRegion(BufferedImage image, Region region, String tag) {
        this.checkRegion(image, region, tag, false);
    }

    public void checkRegion(BufferedImage image, Region region) {
        this.checkRegion(image, region, null, false);
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        this.addMouseTriggerBase(action, control, cursor);
    }

    public void addTextTrigger(Region control, String text) {
        this.addTextTriggerBase(control, text);
    }

    public RectangleSize getViewportSize() {
        return this.viewportSize;
    }

    public void setViewportSize(RectangleSize size) {
        ArgumentGuard.notNull((Object)size, (String)"size");
        this.viewportSize = new RectangleSize(size.getWidth(), size.getHeight());
    }

    protected String getInferredEnvironment() {
        return this.inferred != null ? this.inferred : "";
    }

    public void setInferredEnvironment(String inferred) {
        this.inferred = inferred;
    }

    public EyesScreenshot getScreenshot() {
        return this.screenshot;
    }

    protected String getTitle() {
        return this.title;
    }

    private boolean checkImage_(RegionProvider regionProvider, BufferedImage image, String tag, boolean ignoreMismatch) {
        this.screenshot = new EyesImagesScreenshot(image);
        return this.checkImage_(regionProvider, tag, ignoreMismatch);
    }

    private boolean checkImage_(RegionProvider regionProvider, String tag, boolean ignoreMismatch) {
        this.title = tag != null ? tag : "";
        MatchResult mr = this.checkWindowBase(regionProvider, tag, ignoreMismatch);
        return mr.getAsExpected();
    }
}

