/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AgentConnector;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.RunningSession;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import org.openqa.selenium.OutputType;

class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    private AgentConnector agentConnector;
    private RunningSession runningSession;
    private EyesWebDriver driver;
    private int maxWindowLoadTimeMilliSeconds;
    private MatchResult matchResult;
    private boolean dontGetTitle;

    public MatchWindowTask(AgentConnector agentConnector, RunningSession runningSession, EyesWebDriver driver, int maxWindowLoadTime) {
        ArgumentGuard.notNull(agentConnector, "agentConnector");
        ArgumentGuard.notNull(runningSession, "runningSession");
        ArgumentGuard.notNull(driver, "driver");
        ArgumentGuard.greaterThanOrEqualToZero(maxWindowLoadTime, "maxWindowLoadTime");
        this.agentConnector = agentConnector;
        this.runningSession = runningSession;
        this.driver = driver;
        this.maxWindowLoadTimeMilliSeconds = maxWindowLoadTime * 1000;
        this.matchResult = null;
    }

    public MatchResult matchWindow(String tag, boolean shouldRunOnceOnTimeout) {
        if (0 == this.maxWindowLoadTimeMilliSeconds) {
            String title = this.getTitle();
            String screenshot = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            AppOutput appOutput = new AppOutput(title, screenshot);
            MatchWindowData data = new MatchWindowData(this.driver.getUserInputs(), appOutput);
            this.matchResult = this.agentConnector.matchWindow(this.runningSession, data, tag);
        } else if (shouldRunOnceOnTimeout) {
            GeneralUtils.sleep(this.maxWindowLoadTimeMilliSeconds);
            String title = this.getTitle();
            String screenshot = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            AppOutput appOutput = new AppOutput(title, screenshot);
            MatchWindowData data = new MatchWindowData(this.driver.getUserInputs(), appOutput);
            this.matchResult = this.agentConnector.matchWindow(this.runningSession, data, tag);
        } else {
            MatchWindowData data;
            AppOutput appOutput;
            String screenshot;
            String title;
            int timesToRun = this.maxWindowLoadTimeMilliSeconds / 500 - 1;
            for (int i = 0; i < timesToRun; ++i) {
                GeneralUtils.sleep(500L);
                title = this.getTitle();
                screenshot = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                appOutput = new AppOutput(title, screenshot);
                data = new MatchWindowData(this.driver.getUserInputs(), appOutput);
                this.matchResult = this.agentConnector.matchWindow(this.runningSession, data, tag, true);
                if (this.matchResult.getAsExpected()) break;
            }
            if (!this.matchResult.getAsExpected()) {
                title = this.getTitle();
                screenshot = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                appOutput = new AppOutput(title, screenshot);
                data = new MatchWindowData(this.driver.getUserInputs(), appOutput);
                this.matchResult = this.agentConnector.matchWindow(this.runningSession, data, tag);
            }
        }
        this.driver.clearUserInputs();
        return this.matchResult;
    }

    private String getTitle() {
        if (!this.dontGetTitle) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                Logger.verbose("getTitle(): failed (" + ex.getMessage() + ")");
                this.dontGetTitle = true;
            }
        }
        return "";
    }
}

