/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AppiumJsCommandExtractor;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.Eyes;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesKeyboard;
import com.applitools.eyes.EyesMouse;
import com.applitools.eyes.EyesRemoteWebElement;
import com.applitools.eyes.EyesTargetLocator;
import com.applitools.eyes.EyesTouchScreen;
import com.applitools.eyes.EyesWebDriverScreenshot;
import com.applitools.eyes.Frame;
import com.applitools.eyes.FrameChain;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MouseTrigger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RegionProvider;
import com.applitools.eyes.ScreenshotTaker;
import com.applitools.eyes.Trigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.NetworkUtils;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteTouchScreen;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EyesWebDriver
implements HasCapabilities,
HasInputDevices,
FindsByClassName,
FindsByCssSelector,
FindsById,
FindsByLinkText,
FindsByName,
FindsByTagName,
FindsByXPath,
JavascriptExecutor,
SearchContext,
TakesScreenshot,
WebDriver,
HasTouchScreen {
    private static final int MAX_SCROLL_BAR_SIZE = 50;
    private static final int MIN_SCREENSHOT_PART_HEIGHT = 10;
    private static final String JS_GET_VIEWPORT_WIDTH = "var width = undefined; if (window.innerWidth) {width = window.innerWidth;} else if (document.documentElement && document.documentElement.clientWidth) {width = document.documentElement.clientWidth;} else { var b = document.getElementsByTagName('body')[0]; if (b.clientWidth) {width = b.clientWidth;}};return width;";
    private static final String JS_GET_VIEWPORT_HEIGHT = "var height = undefined;  if (window.innerHeight) {height = window.innerHeight;}  else if (document.documentElement && document.documentElement.clientHeight) {height = document.documentElement.clientHeight;}  else { var b = document.getElementsByTagName('body')[0]; if (b.clientHeight) {height = b.clientHeight;}};return height;";
    private final Eyes eyes;
    private final RemoteWebDriver driver;
    private final TouchScreen touch;
    private final ScreenshotTaker screenshotTaker;
    private final Map<String, WebElement> elementsIds;
    private final FrameChain frameChain;

    public EyesWebDriver(Eyes eyes, RemoteWebDriver driver) throws EyesException {
        ArgumentGuard.notNull((Object)((Object)eyes), (String)"eyes");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        this.eyes = eyes;
        this.driver = driver;
        this.elementsIds = new HashMap<String, WebElement>();
        this.frameChain = new FrameChain();
        RemoteExecuteMethod executeMethod = null;
        try {
            executeMethod = new RemoteExecuteMethod(driver);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.touch = null != executeMethod ? new EyesTouchScreen(this, (TouchScreen)new RemoteTouchScreen((ExecuteMethod)executeMethod)) : null;
        URL remoteWebDriverServerUrl = this.getRemoteWebDriverServerUrl();
        String remoteWebDriverSessionId = this.getSessionId();
        Logger.verbose((String)("EyesWebDriver(): Driver session is " + remoteWebDriverSessionId + " @ " + remoteWebDriverServerUrl));
        if (driver instanceof TakesScreenshot) {
            Logger.verbose((String)"EyesWebDriver(): Driver can take screenshots");
            this.screenshotTaker = null;
            return;
        }
        Logger.verbose((String)"EyesWebDriver(): Driver can't take screenshots");
        try {
            this.screenshotTaker = new ScreenshotTaker(remoteWebDriverServerUrl.toURI(), remoteWebDriverSessionId);
        }
        catch (URISyntaxException ex) {
            String errMsg = "Can't take screenshots!";
            Logger.log((String)errMsg);
            throw new EyesException(errMsg, (Throwable)ex);
        }
    }

    public Eyes getEyes() {
        return this.eyes;
    }

    public RemoteWebDriver getRemoteWebDriver() {
        return this.driver;
    }

    public TouchScreen getTouch() {
        return this.touch;
    }

    public void get(String s) {
        this.frameChain.clear();
        this.driver.get(s);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        List foundWebElementsList = this.driver.findElements(by);
        ArrayList<WebElement> resultElementsList = new ArrayList<WebElement>(foundWebElementsList.size());
        for (WebElement currentElement : foundWebElementsList) {
            if (currentElement instanceof RemoteWebElement) {
                resultElementsList.add((WebElement)new EyesRemoteWebElement(this, (RemoteWebElement)currentElement));
                this.elementsIds.put(((RemoteWebElement)currentElement).getId(), currentElement);
                continue;
            }
            throw new EyesException(String.format("findElements: element is not a RemoteWebElement: %s", by));
        }
        return resultElementsList;
    }

    public WebElement findElement(By by) {
        Object webElement = this.driver.findElement(by);
        if (!(webElement instanceof RemoteWebElement)) {
            throw new EyesException(String.format("findElement: Element is not a RemoteWebElement: %s", by));
        }
        webElement = new EyesRemoteWebElement(this, (RemoteWebElement)webElement);
        this.elementsIds.put(((RemoteWebElement)webElement).getId(), (WebElement)webElement);
        return webElement;
    }

    public Map<String, WebElement> getElementIds() {
        return this.elementsIds;
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.driver.close();
    }

    public void quit() {
        this.driver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return new EyesTargetLocator(this, this.driver.switchTo(), new EyesTargetLocator.OnWillSwitch(){

            public void willSwitchToFrame(EyesTargetLocator.TargetType targetType, WebElement targetFrame) {
                switch (targetType) {
                    case DEFAULT_CONTENT: {
                        EyesWebDriver.this.frameChain.clear();
                        break;
                    }
                    case PARENT_FRAME: {
                        EyesWebDriver.this.frameChain.pop();
                        break;
                    }
                    default: {
                        String frameId = ((EyesRemoteWebElement)targetFrame).getId();
                        Point pl = targetFrame.getLocation();
                        Dimension ds = targetFrame.getSize();
                        EyesWebDriver.this.frameChain.push(new Frame(targetFrame, frameId, new Location(pl.getX(), pl.getY()), new RectangleSize(ds.getWidth(), ds.getHeight()), EyesWebDriver.this.getCurrentScrollPosition()));
                    }
                }
            }

            public void willSwitchToWindow(String nameOrHandle) {
                EyesWebDriver.this.frameChain.clear();
            }
        });
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public Mouse getMouse() {
        return new EyesMouse(this, this.driver.getMouse());
    }

    public Keyboard getKeyboard() {
        return new EyesKeyboard(this, this.driver.getKeyboard());
    }

    public WebElement findElementByClassName(String className) {
        return this.findElement(By.className((String)className));
    }

    public List<WebElement> findElementsByClassName(String className) {
        return this.findElements(By.className((String)className));
    }

    public WebElement findElementByCssSelector(String cssSelector) {
        return this.findElement(By.cssSelector((String)cssSelector));
    }

    public List<WebElement> findElementsByCssSelector(String cssSelector) {
        return this.findElements(By.cssSelector((String)cssSelector));
    }

    public WebElement findElementById(String id) {
        return this.findElement(By.id((String)id));
    }

    public List<WebElement> findElementsById(String id) {
        return this.findElements(By.id((String)id));
    }

    public WebElement findElementByLinkText(String linkText) {
        return this.findElement(By.linkText((String)linkText));
    }

    public List<WebElement> findElementsByLinkText(String linkText) {
        return this.findElements(By.linkText((String)linkText));
    }

    public WebElement findElementByPartialLinkText(String partialLinkText) {
        return this.findElement(By.partialLinkText((String)partialLinkText));
    }

    public List<WebElement> findElementsByPartialLinkText(String partialLinkText) {
        return this.findElements(By.partialLinkText((String)partialLinkText));
    }

    public WebElement findElementByName(String name) {
        return this.findElement(By.name((String)name));
    }

    public List<WebElement> findElementsByName(String name) {
        return this.findElements(By.name((String)name));
    }

    public WebElement findElementByTagName(String tagName) {
        return this.findElement(By.tagName((String)tagName));
    }

    public List<WebElement> findElementsByTagName(String tagName) {
        return this.findElements(By.tagName((String)tagName));
    }

    public WebElement findElementByXPath(String path) {
        return this.findElement(By.xpath((String)path));
    }

    public List<WebElement> findElementsByXPath(String path) {
        return this.findElements(By.xpath((String)path));
    }

    public Capabilities getCapabilities() {
        return this.driver.getCapabilities();
    }

    public Object executeScript(String script, Object ... args) {
        Trigger trigger;
        if (AppiumJsCommandExtractor.isAppiumJsCommand(script) && (trigger = AppiumJsCommandExtractor.extractTrigger(this.elementsIds, this.driver.manage().window().getSize(), script, args)) != null && trigger instanceof MouseTrigger) {
            MouseTrigger mt = (MouseTrigger)trigger;
            this.eyes.addMouseTrigger(mt.getMouseAction(), mt.getControl(), mt.getLocation());
        }
        return this.driver.executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        Trigger trigger;
        if (AppiumJsCommandExtractor.isAppiumJsCommand(script) && (trigger = AppiumJsCommandExtractor.extractTrigger(this.elementsIds, this.driver.manage().window().getSize(), script, args)) != null && trigger instanceof MouseTrigger) {
            MouseTrigger mt = (MouseTrigger)trigger;
            this.eyes.addMouseTrigger(mt.getMouseAction(), mt.getControl(), mt.getLocation());
        }
        return this.driver.executeAsyncScript(script, args);
    }

    protected int extractViewportWidth() {
        return Integer.parseInt(this.executeScript(JS_GET_VIEWPORT_WIDTH, new Object[0]).toString());
    }

    protected int extractViewportHeight() {
        return Integer.parseInt(this.executeScript(JS_GET_VIEWPORT_HEIGHT, new Object[0]).toString());
    }

    public Location getCurrentScrollPosition() {
        Logger.verbose((String)"getCurrentScrollPosition()");
        Object xo = this.executeScript("return window.scrollX", new Object[0]);
        if (xo == null && (xo = this.executeScript("var doc = document.documentElement; var left = (window.pageXOffset || doc.scrollLeft) - (doc.clientLeft || 0); return left", new Object[0])) == null) {
            throw new EyesException("Could not get left scroll position!");
        }
        Object yo = this.executeScript("return window.scrollY", new Object[0]);
        if (yo == null && (yo = this.executeScript("var doc = document.documentElement; var top = (window.pageYOffset || doc.scrollTop)  - (doc.clientTop || 0); return top", new Object[0])) == null) {
            throw new EyesException("Could not get top scroll position");
        }
        int x = Integer.parseInt(xo.toString());
        int y = Integer.parseInt(yo.toString());
        Location result = new Location(x, y);
        Logger.verbose((String)String.format("Current position: %s", result));
        return result;
    }

    public RectangleSize getEntirePageSize() {
        Logger.verbose((String)"getEntirePageSize()");
        int scrollWidth = Integer.parseInt(this.executeScript("return document.documentElement.scrollWidth", new Object[0]).toString());
        int bodyScrollWidth = Integer.parseInt(this.executeScript("return document.body.scrollWidth", new Object[0]).toString());
        int totalWidth = Math.max(scrollWidth, bodyScrollWidth);
        int clientHeight = Integer.parseInt(this.executeScript("return document.documentElement.clientHeight", new Object[0]).toString());
        int bodyClientHeight = Integer.parseInt(this.executeScript("return document.body.clientHeight", new Object[0]).toString());
        int scrollHeight = Integer.parseInt(this.executeScript("return document.documentElement.scrollHeight", new Object[0]).toString());
        int bodyScrollHeight = Integer.parseInt(this.executeScript("return document.body.scrollHeight", new Object[0]).toString());
        int maxDocumentElementHeight = Math.max(clientHeight, scrollHeight);
        int maxBodyHeight = Math.max(bodyClientHeight, bodyScrollHeight);
        int totalHeight = Math.max(maxDocumentElementHeight, maxBodyHeight);
        RectangleSize result = new RectangleSize(totalWidth, totalHeight);
        Logger.verbose((String)String.format("Entire size: %s", result));
        return result;
    }

    public RectangleSize getDefaultContentViewportSize() {
        RectangleSize viewportSize;
        FrameChain currentFrames = new FrameChain(this.frameChain);
        this.switchTo().defaultContent();
        try {
            viewportSize = new RectangleSize(this.extractViewportWidth(), this.extractViewportHeight());
        }
        catch (Exception e) {
            Dimension windowSize = this.manage().window().getSize();
            viewportSize = new RectangleSize(windowSize.getWidth(), windowSize.getHeight());
        }
        ((EyesTargetLocator)this.switchTo()).frames(currentFrames);
        return viewportSize;
    }

    public void scrollTo(Location scrollPosition) {
        Logger.verbose((String)String.format("Scrolling to %s", scrollPosition));
        this.executeScript(String.format("window.scrollTo(%d,%d)", scrollPosition.getX(), scrollPosition.getY()), new Object[0]);
        Logger.verbose((String)"Done scrolling!");
    }

    public FrameChain getFrameChain() {
        return new FrameChain(this.frameChain);
    }

    public BufferedImage getStitchedRegion(RegionProvider regionProvider) {
        Logger.verbose((String)"getStitchedRegion()");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        Location originalScrollPosition = this.getCurrentScrollPosition();
        this.scrollTo(new Location(0, 0));
        Location currentScrollPosition = this.getCurrentScrollPosition();
        if (currentScrollPosition.getX() != 0 || currentScrollPosition.getY() != 0) {
            this.scrollTo(originalScrollPosition);
            throw new EyesException("Couldn't scroll to the top/left of the frame!");
        }
        RectangleSize entirePageSize = this.getEntirePageSize();
        Logger.verbose((String)"Getting top/left screenshot as base64...");
        String screenshot64 = (String)this.getScreenshotAs(OutputType.BASE64);
        Logger.verbose((String)"Done getting base64! Getting BufferredImage..");
        BufferedImage image = ImageUtils.imageFromBase64((String)screenshot64);
        Logger.verbose((String)"Done! Creating screenshot object...");
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this, image);
        Logger.verbose((String)"Done! Getting region in screenshot...");
        Region regionInScreenshot = screenshot.convertRegionLocation(regionProvider.getRegion(), regionProvider.getCoordinatesType(), CoordinatesType.SCREENSHOT_AS_IS);
        Logger.verbose((String)"Done!");
        if (!regionInScreenshot.isEmpty()) {
            image = ImageUtils.getImagePart((BufferedImage)image, (Region)regionInScreenshot);
        }
        if (image.getWidth() >= entirePageSize.getWidth() && image.getHeight() >= entirePageSize.getHeight()) {
            this.scrollTo(originalScrollPosition);
            return image;
        }
        RectangleSize partImageSize = new RectangleSize(image.getWidth(), Math.max(image.getHeight() - 50, 10));
        Logger.verbose((String)String.format("Total size: %s, image part size: %s", entirePageSize, partImageSize));
        Region entirePage = new Region(Location.ZERO, entirePageSize);
        Iterable imageParts = entirePage.getSubRegions(partImageSize);
        Logger.verbose((String)"Creating stitchedImage container...");
        BufferedImage stitchedImage = new BufferedImage(entirePageSize.getWidth(), entirePageSize.getHeight(), image.getType());
        Logger.verbose((String)"Done! Adding inital screenshot..");
        stitchedImage.getRaster().setRect(0, 0, image.getData());
        Logger.verbose((String)"Done!");
        Logger.verbose((String)"Getting the rest of the image parts...");
        for (Region partRegion : imageParts) {
            if (partRegion.getLeft() == 0 && partRegion.getTop() == 0) continue;
            Logger.verbose((String)String.format("Taking screenshot for %s", partRegion));
            this.scrollTo(partRegion.getLocation());
            GeneralUtils.sleep((long)100L);
            currentScrollPosition = this.getCurrentScrollPosition();
            Logger.verbose((String)String.format("Scrolled to %s", currentScrollPosition));
            Logger.verbose((String)"Get screenshot as base64...");
            String part64 = (String)this.getScreenshotAs(OutputType.BASE64);
            Logger.verbose((String)"Done! Creating the image object...");
            BufferedImage partImage = ImageUtils.imageFromBase64((String)part64);
            Logger.verbose((String)"Done!");
            if (!regionInScreenshot.isEmpty()) {
                partImage = ImageUtils.getImagePart((BufferedImage)partImage, (Region)regionInScreenshot);
            }
            Logger.verbose((String)"Stitching part into the image container...");
            stitchedImage.getRaster().setRect(currentScrollPosition.getX(), currentScrollPosition.getY(), partImage.getData());
            Logger.verbose((String)"Done!");
        }
        Logger.verbose((String)"Stitching done!");
        this.scrollTo(originalScrollPosition);
        return stitchedImage;
    }

    public BufferedImage getFullPageScreenshot() {
        Logger.verbose((String)"Getting full page screenshot..");
        FrameChain originalFrame = this.getFrameChain();
        this.switchTo().defaultContent();
        BufferedImage fullPageImage = this.getStitchedRegion(new RegionProvider(){

            public Region getRegion() {
                return Region.EMPTY;
            }

            public CoordinatesType getCoordinatesType() {
                return null;
            }
        });
        ((EyesTargetLocator)this.switchTo()).frames(originalFrame);
        return fullPageImage;
    }

    public <X> X getScreenshotAs(OutputType<X> xOutputType) throws WebDriverException {
        if (this.screenshotTaker == null) {
            return (X)this.driver.getScreenshotAs(xOutputType);
        }
        if (xOutputType != OutputType.BASE64) {
            throw new EyesException("Screenshot OutputType not supported");
        }
        String screenshot = this.screenshotTaker.getScreenshot();
        return (X)xOutputType.convertFromBase64Png(screenshot);
    }

    private static URL getFirefoxServerUrl(RemoteWebDriver driver) throws EyesException {
        URL remoteWebDriverServerUrl;
        FirefoxDriver firefoxDriver = (FirefoxDriver)driver;
        CommandExecutor firefoxCommandExecutor = firefoxDriver.getCommandExecutor();
        try {
            Field connectionField = firefoxCommandExecutor.getClass().getDeclaredField("connection");
            connectionField.setAccessible(true);
            Object connectionValue = connectionField.get(firefoxCommandExecutor);
            Field delegateField = connectionValue.getClass().getDeclaredField("delegate");
            delegateField.setAccessible(true);
            HttpCommandExecutor httpCommandExecutor = (HttpCommandExecutor)delegateField.get(connectionValue);
            remoteWebDriverServerUrl = httpCommandExecutor.getAddressOfRemoteServer();
        }
        catch (NoSuchFieldException e) {
            throw new EyesException("Failed to Remote Server Address for Firefox", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new EyesException("Failed to Remote Server Address for Firefox", (Throwable)e);
        }
        return remoteWebDriverServerUrl;
    }

    private URL getRemoteWebDriverServerUrl() {
        CommandExecutor commandExecutor = this.driver.getCommandExecutor();
        URL remoteWebDriverServerUrl = this.driver instanceof FirefoxDriver ? EyesWebDriver.getFirefoxServerUrl(this.driver) : ((HttpCommandExecutor)commandExecutor).getAddressOfRemoteServer();
        if (remoteWebDriverServerUrl == null) {
            throw new EyesException("Failed to get remote web driver URL!");
        }
        String webDriverHost = remoteWebDriverServerUrl.getHost();
        boolean convertToGlobalIP = webDriverHost.equals("127.0.0.1") || webDriverHost.equals("localhost");
        boolean isIE = this.driver instanceof InternetExplorerDriver;
        boolean isFireFox = this.driver instanceof FirefoxDriver;
        if (convertToGlobalIP && !isIE && !isFireFox) {
            String localIP;
            try {
                localIP = NetworkUtils.getLocalIp();
            }
            catch (Exception e) {
                throw new EyesException("Failed to get local IP!", (Throwable)e);
            }
            if (localIP == null) {
                localIP = "localhost";
            }
            try {
                remoteWebDriverServerUrl = new URL(remoteWebDriverServerUrl.getProtocol(), localIP, remoteWebDriverServerUrl.getPort(), remoteWebDriverServerUrl.getPath());
            }
            catch (MalformedURLException e) {
                throw new EyesException("Could not compose URL for the remote web driver!", (Throwable)e);
            }
            catch (NullPointerException e) {
                throw new EyesException("Could not compose URL for the remote web driver!", (Throwable)e);
            }
        }
        return remoteWebDriverServerUrl;
    }

    public String getUserAgent() {
        String userAgent;
        try {
            userAgent = (String)this.driver.executeScript("return navigator.userAgent", new Object[0]);
            Logger.verbose((String)("getUserAgent(): '" + userAgent + "'"));
        }
        catch (Exception e) {
            Logger.verbose((String)"getUserAgent(): Failed to obtain user-agent string");
            userAgent = null;
        }
        return userAgent;
    }

    private String getSessionId() {
        return this.driver.getSessionId().toString();
    }
}

