/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.Location;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class Frame {
    private static final int INVALID_FRAME_INDEX = -1;
    protected WebElement reference;
    protected String id;
    protected Location location;
    protected RectangleSize size;
    protected Location parentScrollPosition;

    public Frame(WebElement reference, String frameId, Location location, RectangleSize size, Location parentScrollPosition) {
        int topBorderWidth;
        int leftBorderWidth;
        ArgumentGuard.notNull((Object)reference, (String)"reference");
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)size, (String)"size");
        ArgumentGuard.notNull((Object)frameId, (String)"frameId");
        ArgumentGuard.notNull((Object)parentScrollPosition, (String)"parentScrollPosition");
        this.reference = reference;
        this.id = frameId;
        this.parentScrollPosition = new Location(parentScrollPosition.getX(), parentScrollPosition.getY());
        this.location = location;
        this.size = size;
        try {
            leftBorderWidth = Math.round(Float.valueOf(reference.getCssValue("border-left-width").trim().replace("px", "")).floatValue());
        }
        catch (WebDriverException e) {
            leftBorderWidth = 0;
        }
        try {
            topBorderWidth = Math.round(Float.valueOf(reference.getCssValue("border-top-width").trim().replace("px", "")).floatValue());
        }
        catch (WebDriverException e) {
            topBorderWidth = 0;
        }
        this.location.offset(leftBorderWidth, topBorderWidth);
    }

    public WebElement getReference() {
        return this.reference;
    }

    public String getId() {
        return this.id;
    }

    public Location getLocation() {
        return this.location;
    }

    public RectangleSize getSize() {
        return this.size;
    }

    public Location getParentScrollPosition() {
        return this.parentScrollPosition;
    }
}

