/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRemoteWebElement;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Frame;
import com.applitools.eyes.FrameChain;
import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import java.util.List;
import org.openqa.selenium.Alert;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

class EyesTargetLocator
implements WebDriver.TargetLocator {
    private final EyesWebDriver driver;
    private OnWillSwitch onWillSwitch;
    private WebDriver.TargetLocator targetLocator;

    public EyesTargetLocator(EyesWebDriver driver, WebDriver.TargetLocator targetLocator, OnWillSwitch onWillSwitch) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)targetLocator, (String)"targetLocator");
        ArgumentGuard.notNull((Object)onWillSwitch, (String)"onWillSwitch");
        this.driver = driver;
        this.targetLocator = targetLocator;
        this.onWillSwitch = onWillSwitch;
    }

    public WebDriver frame(int index) {
        Logger.verbose((String)String.format("EyesTargetLocator.frame(%d)", index));
        Logger.verbose((String)"Getting frames list...");
        List<WebElement> frames = this.driver.findElementsByCssSelector("frame, iframe");
        if (index > frames.size()) {
            throw new NoSuchFrameException(String.format("Frame index [%d] is invalid!", index));
        }
        Logger.verbose((String)"Done! getting the specific frame...");
        WebElement targetFrame = frames.get(index);
        Logger.verbose((String)"Done! Making preparations...");
        this.onWillSwitch.willSwitchToFrame(TargetType.FRAME, targetFrame);
        Logger.verbose((String)"Done! Switching to frame...");
        this.targetLocator.frame(index);
        Logger.verbose((String)"Done!");
        return this.driver;
    }

    public WebDriver frame(String nameOrId) {
        Logger.verbose((String)String.format("EyesTargetLocator.frame('%s')", nameOrId));
        Logger.verbose((String)"Getting frames by name...");
        List<WebElement> frames = this.driver.findElementsByName(nameOrId);
        if (frames.size() == 0) {
            Logger.verbose((String)"No frames Found! Trying by id...");
            frames = this.driver.findElementsById(nameOrId);
            if (frames.size() == 0) {
                throw new NoSuchFrameException(String.format("No frame with name or id '%s' exists!", nameOrId));
            }
        }
        Logger.verbose((String)"Done! Making preparations..");
        this.onWillSwitch.willSwitchToFrame(TargetType.FRAME, frames.get(0));
        Logger.verbose((String)"Done! Switching to frame...");
        this.targetLocator.frame(nameOrId);
        Logger.verbose((String)"Done!");
        return this.driver;
    }

    public WebDriver frame(WebElement frameElement) {
        Logger.verbose((String)"EyesTargetLocator.frame(element)");
        Logger.verbose((String)"Making preparations..");
        this.onWillSwitch.willSwitchToFrame(TargetType.FRAME, frameElement);
        Logger.verbose((String)"Done! Switching to frame...");
        this.targetLocator.frame(frameElement);
        Logger.verbose((String)"Done!");
        return this.driver;
    }

    public WebDriver parentFrame() {
        Logger.verbose((String)"EyesTargetLocator.parentFrame()");
        if (this.driver.getFrameChain().size() != 0) {
            Logger.verbose((String)"Making preparations..");
            this.onWillSwitch.willSwitchToFrame(TargetType.PARENT_FRAME, null);
            Logger.verbose((String)"Done! Switching to parent frame..");
            this.targetLocator.parentFrame();
        }
        Logger.verbose((String)"Done!");
        return this.driver;
    }

    public WebDriver frames(FrameChain frameChain) {
        Logger.verbose((String)"EyesTargetLocator.frames()");
        for (Frame frame : frameChain) {
            Logger.verbose((String)"Scrolling by parent scroll position..");
            this.driver.scrollTo(frame.getParentScrollPosition());
            Logger.verbose((String)"Done! Switching to frame...");
            this.driver.switchTo().frame(frame.getReference());
            Logger.verbose((String)"Done!");
        }
        return this.driver;
    }

    public WebDriver window(String nameOrHandle) {
        Logger.verbose((String)"EyesTargetLocator.frames()");
        Logger.verbose((String)"Making preparations..");
        this.onWillSwitch.willSwitchToWindow(nameOrHandle);
        Logger.verbose((String)"Done! Switching to window..");
        this.targetLocator.window(nameOrHandle);
        Logger.verbose((String)"Done!");
        return this.driver;
    }

    public WebDriver defaultContent() {
        Logger.verbose((String)"EyesTargetLocator.defaultContent()");
        if (this.driver.getFrameChain().size() != 0) {
            Logger.verbose((String)"Making preparations..");
            this.onWillSwitch.willSwitchToFrame(TargetType.DEFAULT_CONTENT, null);
            Logger.verbose((String)"Done! Switching to default content..");
            this.targetLocator.defaultContent();
            Logger.verbose((String)"Done!");
        }
        return this.driver;
    }

    public WebElement activeElement() {
        Logger.verbose((String)"EyesTargetLocator.activeElement()");
        Logger.verbose((String)"Switching to element..");
        WebElement element = this.targetLocator.activeElement();
        if (!(element instanceof RemoteWebElement)) {
            throw new EyesException("Not a remote web element!");
        }
        EyesRemoteWebElement result = new EyesRemoteWebElement(this.driver, (RemoteWebElement)element);
        Logger.verbose((String)"Done!");
        return result;
    }

    public Alert alert() {
        Logger.verbose((String)"EyesTargetLocator.alert()");
        Logger.verbose((String)"Switching to alert..");
        Alert result = this.targetLocator.alert();
        Logger.verbose((String)"Done!");
        return result;
    }

    protected static interface OnWillSwitch {
        public void willSwitchToFrame(TargetType var1, WebElement var2);

        public void willSwitchToWindow(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TargetType {
        FRAME,
        PARENT_FRAME,
        DEFAULT_CONTENT;

    }
}

