/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class Frame {
    private static final int INVALID_FRAME_INDEX = -1;
    protected final Logger logger;
    protected final WebElement reference;
    protected final String id;
    protected final Location location;
    protected final RectangleSize size;
    protected final Location parentScrollPosition;

    public Frame(Logger logger, WebElement reference, String frameId, Location location, RectangleSize size, Location parentScrollPosition) {
        int topBorderWidth;
        int leftBorderWidth;
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)reference, (String)"reference");
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)size, (String)"size");
        ArgumentGuard.notNull((Object)frameId, (String)"frameId");
        ArgumentGuard.notNull((Object)parentScrollPosition, (String)"parentScrollPosition");
        logger.verbose("Frame constructor...");
        this.logger = logger;
        this.reference = reference;
        this.id = frameId;
        this.parentScrollPosition = new Location(parentScrollPosition.getX(), parentScrollPosition.getY());
        this.size = size;
        try {
            leftBorderWidth = Math.round(Float.valueOf(reference.getCssValue("border-left-width").trim().replace("px", "")).floatValue());
        }
        catch (WebDriverException e) {
            leftBorderWidth = 0;
        }
        try {
            topBorderWidth = Math.round(Float.valueOf(reference.getCssValue("border-top-width").trim().replace("px", "")).floatValue());
        }
        catch (WebDriverException e) {
            topBorderWidth = 0;
        }
        Location frameLocation = new Location(location);
        frameLocation.offset(leftBorderWidth, topBorderWidth);
        this.location = frameLocation;
        logger.verbose("Done!");
    }

    public WebElement getReference() {
        return this.reference;
    }

    public String getId() {
        return this.id;
    }

    public Location getLocation() {
        return this.location;
    }

    public RectangleSize getSize() {
        return this.size;
    }

    public Location getParentScrollPosition() {
        return this.parentScrollPosition;
    }
}

