/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.Location;
import com.applitools.eyes.MouseAction;
import com.applitools.eyes.MouseTrigger;
import com.applitools.eyes.Region;
import com.applitools.eyes.Trigger;
import java.util.Map;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class AppiumJsCommandExtractor {
    private static final String COMMAND_PREFIX = "mobile: ";
    private static final String TAP_COMMAND = "mobile: tap";
    private static final double APPIUM_COORDINATES_DEFAULT = 0.5;
    private static final int APPIUM_TAP_COUNT_DEFAULT = 1;

    public static boolean isAppiumJsCommand(String script) {
        return script.startsWith(COMMAND_PREFIX);
    }

    public static Trigger extractTrigger(Map<String, WebElement> elementsIds, Dimension viewportSize, String script, Object ... args) {
        if (script.equals(TAP_COMMAND)) {
            Region control;
            String tapCountObj;
            String yObj;
            String xObj;
            Map tapObject;
            if (args.length != 1) {
                return null;
            }
            try {
                tapObject = (Map)args[0];
                xObj = (String)tapObject.get("x");
                yObj = (String)tapObject.get("y");
                tapCountObj = (String)tapObject.get("tapCount");
            }
            catch (ClassCastException e) {
                return null;
            }
            double x = xObj != null ? Double.valueOf(xObj) : 0.5;
            double y = yObj != null ? Double.valueOf(yObj) : 0.5;
            String elementId = (String)tapObject.get("element");
            if (elementId != null) {
                WebElement referencedElement = elementsIds.get(elementId);
                if (referencedElement == null) {
                    return null;
                }
                Point elementPosition = referencedElement.getLocation();
                Dimension elementSize = referencedElement.getSize();
                control = new Region(elementPosition.getX(), elementPosition.getY(), elementSize.getWidth(), elementSize.getHeight());
                if (x < 1.0) {
                    x = (double)control.getWidth() * x;
                }
                if (y < 1.0) {
                    y = (double)control.getHeight() * y;
                }
            } else {
                if (x < 1.0) {
                    x = (double)viewportSize.getWidth() * x;
                }
                if (y < 1.0) {
                    y = (double)viewportSize.getHeight() * y;
                }
                control = new Region(0, 0, (int)Math.round(x), (int)Math.round(y));
            }
            Location location = new Location((int)Math.round(x), (int)Math.round(y));
            int tapCount = tapCountObj != null ? Integer.valueOf(tapCountObj) : 1;
            MouseAction action = tapCount == 1 ? MouseAction.Click : MouseAction.DoubleClick;
            return new MouseTrigger(action, control, location);
        }
        return null;
    }
}

