/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CoordinatesTypeConversionException;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.selenium.EyesDriverOperationException;
import com.applitools.eyes.selenium.EyesWebDriver;
import com.applitools.eyes.selenium.Frame;
import com.applitools.eyes.selenium.FrameChain;
import com.applitools.eyes.selenium.ScrollPositionProvider;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class EyesWebDriverScreenshot
extends EyesScreenshot {
    private final Logger logger;
    private final EyesWebDriver driver;
    private final FrameChain frameChain;
    private final Location scrollPosition;
    private final ScreenshotType screenshotType;
    private final Location frameLocationInScreenshot;
    private final Region frameWindow;

    private static Location calcFrameLocationInScreenshot(Logger logger, FrameChain frameChain, ScreenshotType screenshotType) {
        logger.verbose("Getting first frame..");
        Iterator<Frame> frameIterator = frameChain.iterator();
        Frame firstFrame = frameIterator.next();
        logger.verbose("Done!");
        Location locationInScreenshot = new Location(firstFrame.getLocation());
        if (screenshotType == ScreenshotType.VIEWPORT) {
            Location defaultContentScroll = firstFrame.getParentScrollPosition();
            locationInScreenshot.offset(-defaultContentScroll.getX(), -defaultContentScroll.getY());
        }
        logger.verbose("Iterating over frames..");
        while (frameIterator.hasNext()) {
            logger.verbose("Getting next frame...");
            Frame frame = frameIterator.next();
            logger.verbose("Done!");
            Location frameLocation = frame.getLocation();
            Location frameParentScrollPosition = frame.getParentScrollPosition();
            locationInScreenshot.offset(frameLocation.getX() - frameParentScrollPosition.getX(), frameLocation.getY() - frameParentScrollPosition.getY());
        }
        logger.verbose("Done!");
        return locationInScreenshot;
    }

    public EyesWebDriverScreenshot(Logger logger, EyesWebDriver driver, BufferedImage image, ScreenshotType screenshotType, Location frameLocationInScreenshot) {
        super(image);
        Location sp;
        RectangleSize frameSize;
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        this.logger = logger;
        this.driver = driver;
        ScrollPositionProvider positionProvider = new ScrollPositionProvider(logger, driver);
        RectangleSize viewportSize = driver.getDefaultContentViewportSize();
        this.frameChain = driver.getFrameChain();
        if (this.frameChain.size() != 0) {
            frameSize = this.frameChain.getCurrentFrameSize();
        } else {
            RectangleSize fs;
            try {
                fs = positionProvider.getEntireSize();
            }
            catch (EyesDriverOperationException e) {
                fs = viewportSize;
            }
            frameSize = fs;
        }
        try {
            sp = positionProvider.getCurrentPosition();
        }
        catch (EyesDriverOperationException e) {
            sp = new Location(0, 0);
        }
        this.scrollPosition = sp;
        if (screenshotType == null) {
            screenshotType = image.getWidth() <= viewportSize.getWidth() && image.getHeight() <= viewportSize.getHeight() ? ScreenshotType.VIEWPORT : ScreenshotType.ENTIRE_FRAME;
        }
        this.screenshotType = screenshotType;
        if (frameLocationInScreenshot == null) {
            if (this.frameChain.size() > 0) {
                frameLocationInScreenshot = EyesWebDriverScreenshot.calcFrameLocationInScreenshot(logger, this.frameChain, this.screenshotType);
            } else {
                frameLocationInScreenshot = new Location(0, 0);
                if (this.screenshotType == ScreenshotType.VIEWPORT) {
                    frameLocationInScreenshot.offset(-this.scrollPosition.getX(), -this.scrollPosition.getY());
                }
            }
        }
        this.frameLocationInScreenshot = frameLocationInScreenshot;
        logger.verbose("Calculating frame window..");
        this.frameWindow = new Region(frameLocationInScreenshot, frameSize);
        this.frameWindow.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
        if (this.frameWindow.getWidth() <= 0 || this.frameWindow.getHeight() <= 0) {
            throw new EyesException("Got empty frame window for screenshot!");
        }
        logger.verbose("Done!");
    }

    public EyesWebDriverScreenshot(Logger logger, EyesWebDriver driver, BufferedImage image) {
        this(logger, driver, image, null, null);
    }

    public EyesWebDriverScreenshot(Logger logger, EyesWebDriver driver, BufferedImage image, RectangleSize entireFrameSize) {
        super(image);
        ArgumentGuard.notNull((Object)driver, (String)"logger");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)entireFrameSize, (String)"entireFrameSize");
        this.logger = logger;
        this.driver = driver;
        this.frameChain = driver.getFrameChain();
        this.screenshotType = ScreenshotType.ENTIRE_FRAME;
        this.scrollPosition = new Location(0, 0);
        this.frameLocationInScreenshot = new Location(0, 0);
        this.frameWindow = new Region(new Location(0, 0), entireFrameSize);
    }

    public Region getFrameWindow() {
        return this.frameWindow;
    }

    public FrameChain getFrameChain() {
        return new FrameChain(this.logger, this.frameChain);
    }

    public EyesWebDriverScreenshot getSubScreenshot(Region region, CoordinatesType coordinatesType, boolean throwIfClipped) {
        this.logger.verbose(String.format("getSubScreenshot([%s], %s, %b)", region, coordinatesType, throwIfClipped));
        ArgumentGuard.notNull((Object)region, (String)"region");
        ArgumentGuard.notNull((Object)coordinatesType, (String)"coordinatesType");
        Region asIsSubScreenshotRegion = this.getIntersectedRegion(region, coordinatesType, CoordinatesType.SCREENSHOT_AS_IS);
        if (asIsSubScreenshotRegion.isEmpty() || throwIfClipped && !asIsSubScreenshotRegion.getSize().equals((Object)region.getSize())) {
            throw new OutOfBoundsException(String.format("Region [%s, (%s)] is out of screenshot bounds [%s]", region, coordinatesType, this.frameWindow));
        }
        BufferedImage subScreenshotImage = ImageUtils.getImagePart((BufferedImage)this.image, (Region)asIsSubScreenshotRegion);
        Location contextAsIsRegionLocation = this.convertLocation(asIsSubScreenshotRegion.getLocation(), CoordinatesType.SCREENSHOT_AS_IS, CoordinatesType.CONTEXT_AS_IS);
        Location frameLocationInSubScreenshot = new Location(-contextAsIsRegionLocation.getX(), -contextAsIsRegionLocation.getY());
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, subScreenshotImage, this.screenshotType, frameLocationInSubScreenshot);
        this.logger.verbose("Done!");
        return result;
    }

    public Location convertLocation(Location location, CoordinatesType from, CoordinatesType to) {
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)from, (String)"from");
        ArgumentGuard.notNull((Object)to, (String)"to");
        Location result = new Location(location);
        if (from == to) {
            return result;
        }
        if (this.frameChain.size() == 0 && this.screenshotType == ScreenshotType.ENTIRE_FRAME) {
            if ((from == CoordinatesType.CONTEXT_RELATIVE || from == CoordinatesType.CONTEXT_AS_IS) && to == CoordinatesType.SCREENSHOT_AS_IS) {
                result.offset(this.frameLocationInScreenshot.getX(), this.frameLocationInScreenshot.getY());
            } else if (from == CoordinatesType.SCREENSHOT_AS_IS && (to == CoordinatesType.CONTEXT_RELATIVE || to == CoordinatesType.CONTEXT_AS_IS)) {
                result.offset(-this.frameLocationInScreenshot.getX(), -this.frameLocationInScreenshot.getY());
            }
            return result;
        }
        block0 : switch (from) {
            case CONTEXT_AS_IS: {
                switch (to) {
                    case CONTEXT_RELATIVE: {
                        result.offset(this.scrollPosition.getX(), this.scrollPosition.getY());
                        break block0;
                    }
                    case SCREENSHOT_AS_IS: {
                        result.offset(this.frameLocationInScreenshot.getX(), this.frameLocationInScreenshot.getY());
                        break block0;
                    }
                }
                throw new CoordinatesTypeConversionException(from, to);
            }
            case CONTEXT_RELATIVE: {
                switch (to) {
                    case SCREENSHOT_AS_IS: {
                        result.offset(-this.scrollPosition.getX(), -this.scrollPosition.getY());
                        result.offset(this.frameLocationInScreenshot.getX(), this.frameLocationInScreenshot.getY());
                        break block0;
                    }
                    case CONTEXT_AS_IS: {
                        result.offset(-this.scrollPosition.getX(), -this.scrollPosition.getY());
                        break block0;
                    }
                }
                throw new CoordinatesTypeConversionException(from, to);
            }
            case SCREENSHOT_AS_IS: {
                switch (to) {
                    case CONTEXT_RELATIVE: {
                        result.offset(-this.frameLocationInScreenshot.getX(), -this.frameLocationInScreenshot.getY());
                        result.offset(this.scrollPosition.getX(), this.scrollPosition.getY());
                        break block0;
                    }
                    case CONTEXT_AS_IS: {
                        result.offset(-this.frameLocationInScreenshot.getX(), -this.frameLocationInScreenshot.getY());
                        break block0;
                    }
                }
                throw new CoordinatesTypeConversionException(from, to);
            }
            default: {
                throw new CoordinatesTypeConversionException(from, to);
            }
        }
        return result;
    }

    public Location getLocationInScreenshot(Location location, CoordinatesType coordinatesType) throws OutOfBoundsException {
        if (!this.frameWindow.contains(location = this.convertLocation(location, coordinatesType, CoordinatesType.SCREENSHOT_AS_IS))) {
            throw new OutOfBoundsException(String.format("Location %s ('%s') is not visible in screenshot!", location, coordinatesType));
        }
        return location;
    }

    public Region getIntersectedRegion(Region region, CoordinatesType originalCoordinatesType, CoordinatesType resultCoordinatesType) {
        if (region.isEmpty()) {
            return new Region(region);
        }
        Region intersectedRegion = this.convertRegionLocation(region, originalCoordinatesType, CoordinatesType.SCREENSHOT_AS_IS);
        switch (originalCoordinatesType) {
            case CONTEXT_RELATIVE: 
            case CONTEXT_AS_IS: {
                intersectedRegion.intersect(this.frameWindow);
                break;
            }
            case SCREENSHOT_AS_IS: {
                intersectedRegion.intersect(new Region(0, 0, this.image.getWidth(), this.image.getHeight()));
                break;
            }
            default: {
                throw new CoordinatesTypeConversionException(String.format("Unknown coordinates type: '%s'", originalCoordinatesType));
            }
        }
        if (intersectedRegion.isEmpty()) {
            return intersectedRegion;
        }
        intersectedRegion = this.convertRegionLocation(intersectedRegion, CoordinatesType.SCREENSHOT_AS_IS, resultCoordinatesType);
        return intersectedRegion;
    }

    public Region getIntersectedRegion(WebElement element) {
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        elementRegion = this.getIntersectedRegion(elementRegion, CoordinatesType.CONTEXT_RELATIVE);
        if (!elementRegion.isEmpty()) {
            elementRegion = this.convertRegionLocation(elementRegion, CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
        }
        return elementRegion;
    }

    private static enum ScreenshotType {
        VIEWPORT,
        ENTIRE_FRAME;

    }
}

