/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebElement;

public class Frame {
    protected final Logger logger;
    protected final WebElement reference;
    protected final String id;
    protected final Location location;
    protected final RectangleSize size;
    protected final Location parentScrollPosition;

    public Frame(Logger logger, WebElement reference, String frameId, Location location, RectangleSize size, Location parentScrollPosition) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)reference, (String)"reference");
        ArgumentGuard.notNull((Object)frameId, (String)"frameId");
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)size, (String)"size");
        ArgumentGuard.notNull((Object)parentScrollPosition, (String)"parentScrollPosition");
        logger.verbose(String.format("Frame(logger, reference, %s, %s, %s, %s)", frameId, location, size, parentScrollPosition));
        this.logger = logger;
        this.reference = reference;
        this.id = frameId;
        this.parentScrollPosition = parentScrollPosition;
        this.size = size;
        this.location = location;
    }

    public WebElement getReference() {
        return this.reference;
    }

    public String getId() {
        return this.id;
    }

    public Location getLocation() {
        return this.location;
    }

    public RectangleSize getSize() {
        return this.size;
    }

    public Location getParentScrollPosition() {
        return this.parentScrollPosition;
    }
}

