/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.processor.model.impl;

import com.atomgraph.core.util.StateBuilder;
import com.atomgraph.processor.exception.ParameterException;
import com.atomgraph.processor.model.Parameter;
import com.atomgraph.processor.model.Template;
import com.atomgraph.processor.model.TemplateCall;
import com.atomgraph.processor.util.RDFNodeFactory;
import com.atomgraph.processor.vocabulary.LDT;
import com.atomgraph.spinrdf.model.Argument;
import com.atomgraph.spinrdf.vocabulary.SPL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.glassfish.jersey.uri.UriComponent;

public class TemplateCallImpl
extends StateBuilder
implements TemplateCall {
    private final Template template;
    private final Resource original;

    public TemplateCallImpl(Resource resource, Template template) {
        super(UriBuilder.fromUri((String)resource.getURI()), resource.getModel());
        if (template == null) {
            throw new IllegalArgumentException("Template cannot be null");
        }
        this.original = resource;
        this.template = template;
    }

    protected Resource getOriginal() {
        return this.original;
    }

    @Override
    public final Template getTemplate() {
        return this.template;
    }

    public String getURI() {
        return this.getResource().getURI();
    }

    @Override
    public TemplateCall applyArguments(MultivaluedMap<String, String> queryParams) {
        if (queryParams == null) {
            throw new IllegalArgumentException("Query parameter map cannot be null");
        }
        Set<String> paramNames = this.getTemplate().getParameterMap().keySet();
        for (String paramName : paramNames) {
            Parameter param = this.getTemplate().getParameterMap().get(paramName);
            if (!queryParams.containsKey((Object)paramName)) continue;
            List argValues = (List)queryParams.get((Object)paramName);
            for (String argValue : argValues) {
                this.arg(param, RDFNodeFactory.createTyped(argValue, param.getValueType()));
            }
        }
        return this;
    }

    @Override
    public TemplateCall applyDefaults() {
        for (Parameter param : this.getTemplate().getParameters().values()) {
            RDFNode defaultValue = param.getDefaultValue();
            if (defaultValue == null || this.hasArgument(param.getPredicate())) continue;
            this.arg(param, defaultValue);
        }
        return this;
    }

    @Override
    public StmtIterator listArguments() {
        return this.getResource().listProperties((Property)LDT.arg);
    }

    @Override
    public boolean hasArgument(Property predicate) {
        return this.getArgument(predicate) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getArgument(Property predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        try (StmtIterator it = this.getResource().listProperties((Property)LDT.arg);){
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                Resource arg = stmt.getObject().asResource();
                if (!arg.getProperty(SPL.predicate).getResource().equals((Object)predicate)) continue;
                Resource resource = arg;
                return resource;
            }
        }
        return null;
    }

    @Override
    public boolean hasArgument(String varName, RDFNode object) {
        return this.getArgument(varName, object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getArgument(String varName, RDFNode object) {
        if (varName == null) {
            throw new IllegalArgumentException("Var name String cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("RDFNode cannot be null");
        }
        try (StmtIterator it = this.getResource().listProperties((Property)LDT.arg);){
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                Resource arg = stmt.getObject().asResource();
                if (!arg.getProperty(SPL.predicate).getResource().getLocalName().equals(varName) || !arg.getProperty(RDF.value).getObject().equals(object)) continue;
                Resource resource = arg;
                return resource;
            }
        }
        return null;
    }

    @Override
    public Statement getArgumentProperty(Property predicate) {
        Resource arg = this.getArgument(predicate);
        if (arg != null) {
            return arg.getRequiredProperty(RDF.value);
        }
        return null;
    }

    @Override
    public TemplateCall arg(Parameter param, RDFNode value) {
        if (param == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("RDFNode cannot be null");
        }
        Resource arg = StateBuilder.fromUri((String)this.getOriginal().getURI(), (Model)this.getResource().getModel()).property(param.getPredicate(), value).build();
        return this.arg(arg.addProperty(RDF.type, (RDFNode)param).addLiteral((Property)LDT.paramName, (Object)param.getPredicate().getLocalName()).addProperty(SPL.predicate, (RDFNode)param.getPredicate()).addProperty(RDF.value, value));
    }

    @Override
    public TemplateCall arg(Resource arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        this.getResource().addProperty((Property)LDT.arg, (RDFNode)arg);
        String paramName = arg.getPropertyResourceValue(SPL.predicate).getLocalName();
        RDFNode value = arg.getProperty(RDF.value).getObject();
        String encodedValue = value.toString();
        if (value.isURIResource()) {
            encodedValue = UriComponent.encode((String)value.asResource().getURI(), (UriComponent.Type)UriComponent.Type.UNRESERVED);
        }
        if (value.isLiteral()) {
            encodedValue = UriComponent.encode((String)value.asLiteral().getString(), (UriComponent.Type)UriComponent.Type.UNRESERVED);
        }
        this.getUriBuilder().queryParam(paramName, new Object[]{encodedValue});
        return this;
    }

    @Override
    public TemplateCall validateOptionals() {
        Set<Map.Entry<Property, Parameter>> paramEntries = this.getTemplate().getParameters().entrySet();
        for (Map.Entry<Property, Parameter> entry : paramEntries) {
            if (this.hasArgument(entry.getKey()) || entry.getValue().isOptional()) continue;
            throw new ParameterException(entry.getValue(), this.getTemplate());
        }
        return this;
    }

    @Override
    public QuerySolutionMap getQuerySolutionMap() {
        QuerySolutionMap qsm = new QuerySolutionMap();
        if (this.getTemplate().getQuery().canAs(com.atomgraph.spinrdf.model.TemplateCall.class)) {
            com.atomgraph.spinrdf.model.TemplateCall spinTemplateCall = (com.atomgraph.spinrdf.model.TemplateCall)this.getTemplate().getQuery().as(com.atomgraph.spinrdf.model.TemplateCall.class);
            qsm = spinTemplateCall.getInitialBinding();
            List spinArgs = spinTemplateCall.getTemplate().getArguments(false);
            for (Argument spinArg : spinArgs) {
                if (!this.getTemplate().getParameters().containsKey(spinArg.getPredicate()) || !this.hasArgument(spinArg.getPredicate())) continue;
                Parameter param = this.getTemplate().getParameters().get(spinArg.getPredicate());
                qsm.add(param.getVarName(), this.getArgumentProperty(param.getPredicate()).getObject());
            }
        }
        return qsm;
    }
}

