/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.processor.model.impl;

import com.atomgraph.processor.exception.OntologyException;
import com.atomgraph.processor.model.Parameter;
import com.atomgraph.processor.model.Template;
import com.atomgraph.processor.vocabulary.LDT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.CacheControl;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.impl.OntClassImpl;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.glassfish.jersey.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateImpl
extends OntClassImpl
implements Template {
    private static final Logger log = LoggerFactory.getLogger(TemplateImpl.class);
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new TemplateImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to Template: it does not have rdf:type ldt:Template or equivalent");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            if (eg == null) {
                throw new IllegalArgumentException("EnhGraph cannot be null");
            }
            return eg.asGraph().contains(node, RDF.type.asNode(), LDT.Template.asNode());
        }
    };

    public TemplateImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public UriTemplate getMatch() {
        Template lowest = this.getSelfOrSuperWithProperty((Property)LDT.match);
        if (lowest != null) {
            Statement path = lowest.getProperty((Property)LDT.match);
            if (!path.getObject().isLiteral() || path.getObject().asLiteral().getDatatype() == null || !path.getObject().asLiteral().getDatatype().equals(XSDDatatype.XSDstring)) {
                if (log.isErrorEnabled()) {
                    log.error("Class {} property {} is not an xsd:string literal", (Object)lowest.getURI(), (Object)LDT.match);
                }
                throw new OntologyException("Class '" + lowest.getURI() + "' property '" + LDT.match + "' is not an xsd:string literal");
            }
            return new UriTemplate(path.getString());
        }
        return null;
    }

    @Override
    public String getFragmentTemplate() {
        Template lowest = this.getSelfOrSuperWithProperty((Property)LDT.fragment);
        if (lowest != null) {
            return lowest.getProperty((Property)LDT.fragment).getString();
        }
        return null;
    }

    @Override
    public Resource getQuery() {
        Template lowest = this.getSelfOrSuperWithProperty((Property)LDT.query);
        if (lowest != null) {
            return lowest.getPropertyResourceValue((Property)LDT.query);
        }
        if (log.isErrorEnabled()) {
            log.error("Template '{}' is missing ldt:query value", (Object)this.getURI());
        }
        throw new OntologyException("Template '" + this.getURI() + "' is missing ldt:query value");
    }

    @Override
    public Resource getUpdate() {
        Template lowest = this.getSelfOrSuperWithProperty((Property)LDT.update);
        if (lowest != null) {
            return lowest.getPropertyResourceValue((Property)LDT.update);
        }
        return null;
    }

    @Override
    public Double getPriority() {
        Template lowest = this.getSelfOrSuperWithProperty((Property)LDT.priority);
        if (lowest != null) {
            return lowest.getProperty((Property)LDT.priority).getDouble();
        }
        return 0.0;
    }

    @Override
    public Map<Property, Parameter> getParameters() {
        ArrayList<Template> templates = new ArrayList<Template>();
        templates.add(this);
        templates.addAll(this.getSuperTemplates());
        return templates.stream().flatMap(t -> t.getLocalParameters().entrySet().stream()).collect(Collectors.toMap(e -> (Property)e.getKey(), e -> (Parameter)e.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Property, Parameter> getLocalParameters() {
        HashMap<Property, Parameter> params = new HashMap<Property, Parameter>();
        try (StmtIterator it = this.listProperties((Property)LDT.param);){
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                if (!stmt.getObject().canAs(Parameter.class)) {
                    if (log.isErrorEnabled()) {
                        log.error("Unsupported Argument '{}' for Template '{}' (rdf:type ldt:Parameter missing)", (Object)stmt.getObject(), (Object)this.getURI());
                    }
                    throw new OntologyException("Unsupported Argument '" + stmt.getObject() + "' for Template '" + this.getURI() + "' (rdf:type ldt:Parameter missing)");
                }
                Parameter param = (Parameter)stmt.getObject().as(Parameter.class);
                if (params.containsKey(param.getPredicate())) {
                    if (log.isErrorEnabled()) {
                        log.error("Multiple Arguments with the same predicate '{}' for Template '{}' ", (Object)param.getPredicate(), (Object)this.getURI());
                    }
                    throw new OntologyException("Multiple Arguments with the same predicate '" + param.getPredicate() + "' for Template '" + this.getURI() + "'");
                }
                params.put(param.getPredicate(), param);
            }
        }
        return params;
    }

    @Override
    public Map<String, Parameter> getParameterMap() {
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        for (Parameter param : this.getParameters().values()) {
            Property property = param.getPredicate();
            if (property == null) continue;
            map.put(property.getLocalName(), param);
        }
        return map;
    }

    @Override
    public List<Locale> getLanguages() {
        Template lowest = this.getSelfOrSuperWithProperty((Property)LDT.lang);
        if (lowest != null) {
            return this.getLanguages(lowest, (Property)LDT.lang);
        }
        return new ArrayList<Locale>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Locale> getLanguages(Template template, Property property) {
        if (template == null) {
            throw new IllegalArgumentException("Template cannot be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        ArrayList<Locale> languages = new ArrayList<Locale>();
        Resource langs = template.getPropertyResourceValue(property);
        if (langs != null) {
            if (!langs.canAs(RDFList.class)) {
                if (log.isErrorEnabled()) {
                    log.error("ldt:lang value is not an rdf:List on template '{}'", (Object)this.getURI());
                }
                throw new OntologyException("ldt:lang value is not an rdf:List on template  '" + this.getURI() + "'");
            }
            RDFList list = (RDFList)langs.as(RDFList.class);
            try (ExtendedIterator it = list.iterator();){
                while (it.hasNext()) {
                    RDFNode langTag = (RDFNode)it.next();
                    if (!langTag.isLiteral()) {
                        if (log.isErrorEnabled()) {
                            log.error("Non-literal language tag (ldt:lang member) on template '{}'", (Object)this.getURI());
                        }
                        throw new OntologyException("Non-literal language tag (ldt:lang member) on template '" + this.getURI() + "'");
                    }
                    languages.add(Locale.forLanguageTag(langTag.asLiteral().getString()));
                }
            }
        }
        return languages;
    }

    @Override
    public Resource getLoadClass() {
        Template lowest = this.getSelfOrSuperWithProperty((Property)LDT.loadClass);
        if (lowest != null) {
            return lowest.getPropertyResourceValue((Property)LDT.loadClass);
        }
        return null;
    }

    @Override
    public CacheControl getCacheControl() {
        Template lowest = this.getSelfOrSuperWithProperty((Property)LDT.cacheControl);
        if (lowest != null) {
            return CacheControl.valueOf((String)lowest.getPropertyValue((Property)LDT.cacheControl).asLiteral().getString());
        }
        return null;
    }

    @Override
    public List<Template> getSuperTemplates() {
        return this.getSuperTemplates(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Template> getSuperTemplates(Template template) {
        ArrayList<Template> superTemplates = new ArrayList<Template>();
        try (StmtIterator it = template.listProperties((Property)LDT.extends_);){
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                if (!stmt.getObject().isResource() || !stmt.getObject().asResource().canAs(Template.class)) {
                    if (log.isErrorEnabled()) {
                        log.error("Template's '{}' ldt:extends value '{}' is not an LDT Template", (Object)this.getURI(), (Object)stmt.getObject());
                    }
                    throw new OntologyException("Template's '" + this.getURI() + "' ldt:extends value '" + stmt.getObject() + "' is not an LDT Template");
                }
                Template superTemplate = (Template)stmt.getObject().as(Template.class);
                superTemplates.add(superTemplate);
                superTemplates.addAll(this.getSuperTemplates(superTemplate));
            }
        }
        return superTemplates;
    }

    public Template getSelfOrSuperWithProperty(Property property) {
        ArrayList<Template> templates = new ArrayList<Template>();
        templates.add(this);
        templates.addAll(this.getSuperTemplates());
        return templates.stream().filter(t -> t.hasProperty(property)).findFirst().orElse(null);
    }

    public String toString() {
        return "[<" + this.getURI() + ">: \"" + this.getMatch() + "\", " + Double.toString(this.getPriority()) + "]";
    }
}

