/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.processor.util;

import com.atomgraph.processor.exception.OntologyException;
import com.atomgraph.processor.vocabulary.LDT;
import com.atomgraph.processor.vocabulary.SIOC;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontology.AllValuesFromRestriction;
import org.apache.jena.ontology.HasValueRestriction;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.glassfish.jersey.uri.internal.UriTemplateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Skolemizer {
    private static final Logger log = LoggerFactory.getLogger(Skolemizer.class);
    private final Ontology ontology;
    private final UriBuilder baseUriBuilder;
    private final UriBuilder absolutePathBuilder;

    public Skolemizer(Ontology ontology, UriBuilder baseUriBuilder, UriBuilder absolutePathBuilder) {
        if (ontology == null) {
            throw new IllegalArgumentException("Ontology cannot be null");
        }
        if (baseUriBuilder == null) {
            throw new IllegalArgumentException("UriBuilder cannot be null");
        }
        if (absolutePathBuilder == null) {
            throw new IllegalArgumentException("UriBuilder cannot be null");
        }
        this.ontology = ontology;
        this.baseUriBuilder = baseUriBuilder;
        this.absolutePathBuilder = absolutePathBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model build(Model model) {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        HashMap<Resource, String> resourceURIMap = new HashMap<Resource, String>();
        try (ResIterator resIt = model.listSubjects();){
            while (resIt.hasNext()) {
                URI uri;
                Resource resource = (Resource)resIt.next();
                if (!resource.isAnon() || (uri = this.build(resource)) == null) continue;
                resourceURIMap.put(resource, uri.toString());
            }
        }
        for (Map.Entry entry : resourceURIMap.entrySet()) {
            ResourceUtils.renameResource((Resource)((Resource)entry.getKey()), (String)((String)entry.getValue()));
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI build(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        try (StmtIterator it = resource.listProperties(RDF.type);){
            while (it.hasNext()) {
                OntClass typeClass;
                OntClass pathClass;
                Resource type = ((Statement)it.next()).getResource();
                if (!this.getOntology().getOntModel().getOntResource(type).canAs(OntClass.class) || (pathClass = this.getPathClass(typeClass = this.getOntology().getOntModel().getOntResource(type).asClass())) == null) continue;
                String path = this.getStringValue(pathClass, (Property)LDT.path);
                OntClass fragmentClass = this.getFragmentClass(typeClass);
                String fragment = fragmentClass != null ? this.getStringValue(fragmentClass, (Property)LDT.fragment) : null;
                URI uRI = this.build(resource, this.getUriBuilder(path, typeClass), path, fragment);
                return uRI;
            }
        }
        return null;
    }

    public UriBuilder getUriBuilder(String path, OntClass typeClass) {
        Resource parent;
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if (typeClass == null) {
            throw new IllegalArgumentException("OntClass cannot be null");
        }
        UriBuilder builder = path.startsWith("/") ? this.getBaseUriBuilder().clone() : ((parent = this.getParent(typeClass)) != null ? UriBuilder.fromUri((String)parent.getURI()) : this.getAbsolutePathBuilder().clone());
        return builder;
    }

    public URI build(Resource resource, UriBuilder builder, String path, String fragment) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (builder == null) {
            throw new IllegalArgumentException("UriBuilder cannot be null");
        }
        Map<String, String> nameValueMap = Skolemizer.getNameValueMap(resource, new UriTemplateParser(path));
        return builder.path(path).fragment(fragment).buildFromMap(nameValueMap);
    }

    public static Map<String, String> getNameValueMap(Resource resource, UriTemplateParser parser) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (parser == null) {
            throw new IllegalArgumentException("UriTemplateParser cannot be null");
        }
        HashMap<String, String> nameValueMap = new HashMap<String, String>();
        List names = parser.getNames();
        for (String name : names) {
            Literal literal = Skolemizer.getLiteral(resource, name);
            if (literal == null) continue;
            nameValueMap.put(name, literal.getString());
        }
        return nameValueMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Literal getLiteral(Resource resource, String namePath) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (namePath.contains(".")) {
            String name = namePath.substring(0, namePath.indexOf("."));
            String nameSubPath = namePath.substring(namePath.indexOf(".") + 1);
            Resource subResource = Skolemizer.getResource(resource, name);
            if (subResource != null) {
                return Skolemizer.getLiteral(subResource, nameSubPath);
            }
        }
        try (StmtIterator it = resource.listProperties();){
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                if (!stmt.getObject().isLiteral() || !stmt.getPredicate().getLocalName().equals(namePath)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Found Literal {} for property name: {} ", (Object)stmt.getLiteral(), (Object)namePath);
                }
                Literal literal = stmt.getLiteral();
                return literal;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getResource(Resource resource, String name) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        try (StmtIterator it = resource.listProperties();){
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                if (!stmt.getObject().isAnon() || !stmt.getPredicate().getLocalName().equals(name)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Found Resource {} for property name: {} ", (Object)stmt.getResource(), (Object)name);
                }
                Resource resource2 = stmt.getResource();
                return resource2;
            }
        }
        return null;
    }

    public OntClass getPathClass(OntClass ontClass) {
        return this.getPathClass(ontClass, this.getStringValue(ontClass, (Property)LDT.path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OntClass getPathClass(OntClass ontClass, String path) {
        if (ontClass == null) {
            throw new IllegalArgumentException("OntClass cannot be null");
        }
        if (path != null) {
            return ontClass;
        }
        try (ExtendedIterator it = ontClass.listSuperClasses();){
            while (it.hasNext()) {
                OntClass superClass = (OntClass)it.next();
                OntClass pathClass = this.getPathClass(superClass);
                if (pathClass == null) continue;
                OntClass ontClass2 = pathClass;
                return ontClass2;
            }
        }
        return null;
    }

    public OntClass getFragmentClass(OntClass ontClass) {
        return this.getFragmentClass(ontClass, this.getStringValue(ontClass, (Property)LDT.fragment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OntClass getFragmentClass(OntClass ontClass, String fragment) {
        if (ontClass == null) {
            throw new IllegalArgumentException("OntClass cannot be null");
        }
        if (fragment != null) {
            return ontClass;
        }
        try (ExtendedIterator it = ontClass.listSuperClasses();){
            while (it.hasNext()) {
                OntClass superClass = (OntClass)it.next();
                OntClass fragmentClass = this.getFragmentClass(superClass);
                if (fragmentClass == null) continue;
                OntClass ontClass2 = fragmentClass;
                return ontClass2;
            }
        }
        return null;
    }

    protected String getStringValue(OntClass ontClass, Property property) {
        if (ontClass == null) {
            throw new IllegalArgumentException("OntClass cannot be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        if (ontClass.hasProperty(property)) {
            if (!ontClass.getPropertyValue(property).isLiteral() || ontClass.getPropertyValue(property).asLiteral().getDatatype() == null || !ontClass.getPropertyValue(property).asLiteral().getDatatype().equals(XSDDatatype.XSDstring)) {
                if (log.isErrorEnabled()) {
                    log.error("Class {} property {} is not an xsd:string literal", (Object)ontClass, (Object)property);
                }
                throw new OntologyException("Class '" + ontClass + "' property '" + property + "' is not an xsd:string literal");
            }
            return ontClass.getPropertyValue(property).asLiteral().getString();
        }
        return null;
    }

    public Resource getParent(OntClass ontClass) {
        if (ontClass == null) {
            throw new IllegalArgumentException("OntClass cannot be null");
        }
        try (ExtendedIterator hasValueIt = ontClass.listSuperClasses();){
            while (hasValueIt.hasNext()) {
                HasValueRestriction hvr;
                OntClass superClass = (OntClass)hasValueIt.next();
                if (!superClass.canAs(HasValueRestriction.class) || !(hvr = (HasValueRestriction)superClass.as(HasValueRestriction.class)).getOnProperty().equals(SIOC.HAS_PARENT) && !hvr.getOnProperty().equals(SIOC.HAS_CONTAINER)) continue;
                if (!hvr.getHasValue().isURIResource()) {
                    if (log.isErrorEnabled()) {
                        log.error("HasValue restriction on class {} for property {} is not a URI resource", (Object)ontClass, (Object)hvr.getOnProperty());
                    }
                    throw new OntologyException("HasValue restriction on class '" + ontClass + "' for property '" + hvr.getOnProperty() + "' is not a URI resource");
                }
                Resource resource = hvr.getHasValue().asResource();
                return resource;
            }
        }
        try (ExtendedIterator allValuesFromIt = ontClass.listSuperClasses();){
            while (allValuesFromIt.hasNext()) {
                OntClass superClass = (OntClass)allValuesFromIt.next();
                if (!superClass.canAs(AllValuesFromRestriction.class)) continue;
                AllValuesFromRestriction avr = (AllValuesFromRestriction)superClass.as(AllValuesFromRestriction.class);
                if (!avr.getAllValuesFrom().canAs(OntClass.class)) {
                    if (log.isErrorEnabled()) {
                        log.error("AllValuesFrom restriction on class {} for property {} is not an OntClass resource", (Object)ontClass, (Object)avr.getOnProperty());
                    }
                    throw new OntologyException("AllValuesFrom restriction on class '" + ontClass + "' for property '" + avr.getOnProperty() + "' is not an OntClass resource");
                }
                OntClass valueClass = (OntClass)avr.getAllValuesFrom().as(OntClass.class);
                Resource resource = this.getParent(valueClass);
                return resource;
            }
        }
        return null;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public UriBuilder getBaseUriBuilder() {
        return this.baseUriBuilder;
    }

    public UriBuilder getAbsolutePathBuilder() {
        return this.absolutePathBuilder;
    }
}

