/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.processor.util;

import com.atomgraph.spinrdf.constraints.ConstraintViolation;
import com.atomgraph.spinrdf.constraints.SPINConstraints;
import java.util.List;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static final Logger log = LoggerFactory.getLogger(Validator.class);
    private final OntModel ontModel;

    public Validator(OntModel ontModel) {
        if (ontModel == null) {
            throw new IllegalArgumentException("OntModel cannot be null");
        }
        this.ontModel = ontModel;
    }

    public List<ConstraintViolation> validate(Model model) {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        OntModel tempModel = ModelFactory.createOntologyModel((OntModelSpec)this.getOntModel().getSpecification());
        tempModel.add((Model)this.getOntModel()).add(model);
        return SPINConstraints.check((OntModel)tempModel);
    }

    public OntModel getOntModel() {
        return this.ontModel;
    }
}

