/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.exception.ConfigurationException;
import com.atomgraph.core.factory.DataManagerFactory;
import com.atomgraph.core.io.QueryProvider;
import com.atomgraph.core.io.ResultSetProvider;
import com.atomgraph.core.io.UpdateRequestProvider;
import com.atomgraph.core.mapper.NoReaderForLangExceptionMapper;
import com.atomgraph.core.model.Service;
import com.atomgraph.core.model.impl.remote.ServiceImpl;
import com.atomgraph.core.provider.QueryParamProvider;
import com.atomgraph.core.util.jena.DataManagerImpl;
import com.atomgraph.core.vocabulary.A;
import com.atomgraph.core.vocabulary.SD;
import com.atomgraph.processor.model.Parameter;
import com.atomgraph.processor.model.Template;
import com.atomgraph.processor.model.TemplateCall;
import com.atomgraph.processor.model.impl.ApplicationImpl;
import com.atomgraph.processor.model.impl.ParameterImpl;
import com.atomgraph.processor.model.impl.TemplateImpl;
import com.atomgraph.processor.vocabulary.AP;
import com.atomgraph.processor.vocabulary.LDT;
import com.atomgraph.server.factory.TemplateCallFactory;
import com.atomgraph.server.filter.response.HypermediaFilter;
import com.atomgraph.server.io.SkolemizingDatasetProvider;
import com.atomgraph.server.io.SkolemizingModelProvider;
import com.atomgraph.server.mapper.BadGatewayExceptionMapper;
import com.atomgraph.server.mapper.ConfigurationExceptionMapper;
import com.atomgraph.server.mapper.ConstraintViolationExceptionMapper;
import com.atomgraph.server.mapper.ModelExceptionMapper;
import com.atomgraph.server.mapper.NotAcceptableExceptionMapper;
import com.atomgraph.server.mapper.NotFoundExceptionMapper;
import com.atomgraph.server.mapper.NotSupportedExceptionMapper;
import com.atomgraph.server.mapper.OntologyExceptionMapper;
import com.atomgraph.server.mapper.ParameterExceptionMapper;
import com.atomgraph.server.mapper.jena.DatatypeFormatExceptionMapper;
import com.atomgraph.server.mapper.jena.QueryParseExceptionMapper;
import com.atomgraph.server.mapper.jena.RiotExceptionMapper;
import com.atomgraph.server.model.impl.ResourceBase;
import com.atomgraph.server.util.OntologyLoader;
import com.atomgraph.spinrdf.vocabulary.SP;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.servlet.ServletConfig;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Context;
import org.apache.jena.enhanced.BuiltinPersonalities;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.LocationMapper;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application
extends com.atomgraph.core.Application {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    private final com.atomgraph.processor.model.Application application;
    private final Service service;
    private final String ontologyURI;
    private final Ontology ontology;
    private final boolean cacheSitemap;

    public Application(@Context ServletConfig servletConfig) {
        this(servletConfig.getServletContext().getInitParameter(A.dataset.getURI()) != null ? Application.getDataset((String)servletConfig.getServletContext().getInitParameter(A.dataset.getURI()), null) : null, servletConfig.getServletContext().getInitParameter(SD.endpoint.getURI()) != null ? servletConfig.getServletContext().getInitParameter(SD.endpoint.getURI()) : null, servletConfig.getServletContext().getInitParameter(A.graphStore.getURI()) != null ? servletConfig.getServletContext().getInitParameter(A.graphStore.getURI()) : null, servletConfig.getServletContext().getInitParameter(A.quadStore.getURI()) != null ? servletConfig.getServletContext().getInitParameter(A.quadStore.getURI()) : null, servletConfig.getServletContext().getInitParameter(A.authUser.getURI()) != null ? servletConfig.getServletContext().getInitParameter(A.authUser.getURI()) : null, servletConfig.getServletContext().getInitParameter(A.authPwd.getURI()) != null ? servletConfig.getServletContext().getInitParameter(A.authPwd.getURI()) : null, new MediaTypes(), Application.getClient((ClientConfig)new ClientConfig()), servletConfig.getServletContext().getInitParameter(A.maxGetRequestSize.getURI()) != null ? Integer.valueOf(Integer.parseInt(servletConfig.getServletContext().getInitParameter(A.maxGetRequestSize.getURI()))) : null, servletConfig.getServletContext().getInitParameter(A.cacheModelLoads.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(A.cacheModelLoads.getURI())) : false, servletConfig.getServletContext().getInitParameter(A.preemptiveAuth.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(A.preemptiveAuth.getURI())) : false, new LocationMapper(servletConfig.getServletContext().getInitParameter(AP.locationMapping.getURI()) != null ? servletConfig.getServletContext().getInitParameter(AP.locationMapping.getURI()) : null), servletConfig.getServletContext().getInitParameter(LDT.ontology.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDT.ontology.getURI()) : null, servletConfig.getServletContext().getInitParameter(AP.cacheSitemap.getURI()) != null ? Boolean.valueOf(servletConfig.getServletContext().getInitParameter(AP.cacheSitemap.getURI())) : true);
    }

    public Application(Dataset dataset, String endpointURI, String graphStoreURI, String quadStoreURI, String authUser, String authPwd, MediaTypes mediaTypes, Client client, Integer maxGetRequestSize, boolean cacheModelLoads, boolean preemptiveAuth, LocationMapper locationMapper, String ontologyURI, boolean cacheSitemap) {
        super(dataset, endpointURI, graphStoreURI, quadStoreURI, authUser, authPwd, mediaTypes, client, maxGetRequestSize, cacheModelLoads, preemptiveAuth);
        if (locationMapper == null) {
            throw new IllegalArgumentException("LocationMapper be null");
        }
        if (ontologyURI == null) {
            if (log.isErrorEnabled()) {
                log.error("Sitemap ontology URI (" + LDT.ontology.getURI() + ") not configured");
            }
            throw new ConfigurationException((Property)LDT.ontology);
        }
        this.ontologyURI = ontologyURI;
        this.cacheSitemap = cacheSitemap;
        if (dataset != null) {
            this.service = new com.atomgraph.core.model.impl.dataset.ServiceImpl(dataset, mediaTypes);
        } else {
            if (endpointURI == null) {
                if (log.isErrorEnabled()) {
                    log.error("SPARQL endpoint not configured ('{}' not set in web.xml)", (Object)SD.endpoint.getURI());
                }
                throw new ConfigurationException((Property)SD.endpoint);
            }
            if (graphStoreURI == null) {
                if (log.isErrorEnabled()) {
                    log.error("Graph Store not configured ('{}' not set in web.xml)", (Object)A.graphStore.getURI());
                }
                throw new ConfigurationException((Property)A.graphStore);
            }
            this.service = new ServiceImpl(client, mediaTypes, ResourceFactory.createResource((String)endpointURI), ResourceFactory.createResource((String)graphStoreURI), quadStoreURI != null ? ResourceFactory.createResource((String)quadStoreURI) : null, authUser, authPwd, maxGetRequestSize);
        }
        this.application = new ApplicationImpl(this.service, ResourceFactory.createResource((String)ontologyURI));
        SP.init((Personality)BuiltinPersonalities.model);
        BuiltinPersonalities.model.add(Parameter.class, ParameterImpl.factory);
        BuiltinPersonalities.model.add(Template.class, TemplateImpl.factory);
        DataManagerImpl dataManager = new DataManagerImpl(locationMapper, new HashMap(), client, mediaTypes, true, preemptiveAuth);
        OntDocumentManager.getInstance().setFileManager((FileManager)dataManager);
        if (log.isDebugEnabled()) {
            log.debug("OntDocumentManager.getInstance().getFileManager(): {}", (Object)OntDocumentManager.getInstance().getFileManager());
        }
        OntDocumentManager.getInstance().setCacheModels(cacheSitemap);
        this.ontology = new OntologyLoader(OntDocumentManager.getInstance(), ontologyURI, OntModelSpec.OWL_MEM_RDFS_INF, true).getOntology();
    }

    @PostConstruct
    public void init() {
        this.register(ResourceBase.class);
        this.register(HypermediaFilter.class);
        this.register(new AbstractBinder(){

            protected void configure() {
                this.bind(Application.this.application).to(com.atomgraph.processor.model.Application.class);
            }
        });
        this.register(new AbstractBinder(){

            protected void configure() {
                this.bind(Application.this.ontology).to(Ontology.class);
            }
        });
        this.register(new AbstractBinder(){

            protected void configure() {
                this.bind(Application.this.service).to(Service.class);
            }
        });
        this.register(new AbstractBinder(){

            protected void configure() {
                this.bindFactory(TemplateCallFactory.class).to((TypeLiteral)new TypeLiteral<Optional<TemplateCall>>(){}).in(RequestScoped.class);
            }
        });
        this.register(new AbstractBinder(){

            protected void configure() {
                this.bind(new MediaTypes()).to(MediaTypes.class);
            }
        });
        this.register((Object)new SkolemizingDatasetProvider());
        this.register((Object)new SkolemizingModelProvider());
        this.register(new ResultSetProvider());
        this.register(new QueryParamProvider());
        this.register(new QueryProvider());
        this.register(new UpdateRequestProvider());
        this.register(new DataManagerFactory(this.getDataManager()));
        this.register(RiotExceptionMapper.class);
        this.register(ModelExceptionMapper.class);
        this.register(ConstraintViolationExceptionMapper.class);
        this.register(DatatypeFormatExceptionMapper.class);
        this.register(NotFoundExceptionMapper.class);
        this.register(NoReaderForLangExceptionMapper.class);
        this.register(NotSupportedExceptionMapper.class);
        this.register(NotAcceptableExceptionMapper.class);
        this.register(BadGatewayExceptionMapper.class);
        this.register(ConfigurationExceptionMapper.class);
        this.register(OntologyExceptionMapper.class);
        this.register(ParameterExceptionMapper.class);
        this.register(QueryParseExceptionMapper.class);
    }

    public String getOntologyURI() {
        return this.ontologyURI;
    }

    public final boolean isCacheSitemap() {
        return this.cacheSitemap;
    }
}

