/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.factory;

import com.atomgraph.processor.model.Template;
import com.atomgraph.processor.model.TemplateCall;
import com.atomgraph.processor.model.impl.TemplateCallImpl;
import com.atomgraph.processor.util.TemplateMatcher;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.ModelFactory;
import org.glassfish.hk2.api.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class TemplateCallFactory
implements Factory<Optional<TemplateCall>> {
    private static final Logger log = LoggerFactory.getLogger(TemplateCallFactory.class);
    @Context
    UriInfo uriInfo;
    @Inject
    Ontology ontology;

    public Optional<TemplateCall> provide() {
        return this.getTemplateCall();
    }

    public void dispose(Optional<TemplateCall> tc) {
    }

    public Optional<TemplateCall> getTemplateCall() {
        Template template = this.getTemplate();
        if (template != null) {
            return this.getTemplateCall(template, this.getUriInfo().getAbsolutePath(), (MultivaluedMap<String, String>)this.getUriInfo().getQueryParameters());
        }
        return Optional.empty();
    }

    public Optional<TemplateCall> getTemplateCall(Template template, URI absolutePath, MultivaluedMap<String, String> queryParams) {
        if (template == null) {
            throw new IllegalArgumentException("Template cannot be null");
        }
        if (absolutePath == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        if (queryParams == null) {
            throw new IllegalArgumentException("MultivaluedMap cannot be null");
        }
        TemplateCall templateCall = new TemplateCallImpl(ModelFactory.createDefaultModel().createResource(absolutePath.toString()), template).applyArguments(queryParams).applyDefaults().validateOptionals();
        templateCall.build();
        return Optional.of(templateCall);
    }

    public Template getTemplate() {
        if (this.getOntology() != null) {
            return this.getTemplate(this.getOntology(), this.getUriInfo());
        }
        return null;
    }

    public Template getTemplate(Ontology ontology, UriInfo uriInfo) {
        return new TemplateMatcher(ontology).match(uriInfo.getAbsolutePath(), uriInfo.getBaseUri());
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

