/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.filter.response;

import com.atomgraph.processor.model.TemplateCall;
import com.atomgraph.processor.vocabulary.C;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class HypermediaFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(HypermediaFilter.class);
    @Context
    Providers providers;
    @Context
    UriInfo uriInfo;

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        Resource requestUri;
        Resource absolutePath;
        if (request == null) {
            throw new IllegalArgumentException("ContainerRequest cannot be null");
        }
        if (response == null) {
            throw new IllegalArgumentException("ContainerResponse cannot be null");
        }
        if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.REDIRECTION) || response.getStatusInfo().equals(Response.Status.CREATED) || response.getStatusInfo().equals(Response.Status.NOT_FOUND) || response.getStatusInfo().equals(Response.Status.INTERNAL_SERVER_ERROR) || response.getEntity() == null || !(response.getEntity() instanceof Dataset)) {
            return;
        }
        Optional<TemplateCall> templateCall = this.getTemplateCall();
        if (!templateCall.isPresent()) {
            return;
        }
        Resource state = templateCall.get().build();
        if (!state.equals((Object)(absolutePath = state.getModel().createResource(request.getUriInfo().getAbsolutePath().toString())))) {
            state.addProperty((Property)C.stateOf, (RDFNode)absolutePath);
        }
        if (!state.equals((Object)(requestUri = state.getModel().createResource(request.getUriInfo().getRequestUri().toString())))) {
            state.addProperty((Property)C.viewOf, (RDFNode)requestUri).addProperty(RDF.type, (RDFNode)C.View);
        }
        if (log.isDebugEnabled()) {
            log.debug("Added Number of HATEOAS statements added: {}", (Object)state.getModel().size());
        }
        Dataset newEntity = (Dataset)response.getEntity();
        newEntity.getDefaultModel().add(state.getModel());
        response.setEntity((Object)newEntity);
    }

    public Optional<TemplateCall> getTemplateCall() {
        if (!this.getUriInfo().getMatchedResources().isEmpty() && this.getUriInfo().getMatchedResources().get(0) instanceof com.atomgraph.server.model.Resource) {
            return ((com.atomgraph.server.model.Resource)this.getUriInfo().getMatchedResources().get(0)).getTemplateCall();
        }
        return null;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

