/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.mapper;

import com.atomgraph.core.MediaType;
import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.model.impl.Response;
import com.atomgraph.core.util.Link;
import com.atomgraph.core.util.ModelUtils;
import com.atomgraph.processor.model.TemplateCall;
import com.atomgraph.processor.vocabulary.LDT;
import com.atomgraph.server.vocabulary.HTTP;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.Provider;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;

@Provider
public abstract class ExceptionMapperBase {
    @Context
    private Request request;
    @Context
    private UriInfo uriInfo;
    @Inject
    Ontology ontology;
    @Inject
    Optional<TemplateCall> templateCall;
    @Inject
    MediaTypes mediaTypes;

    public Resource toResource(Exception ex, Response.StatusType status, Resource statusResource) {
        if (ex == null) {
            throw new IllegalArgumentException("Exception cannot be null");
        }
        if (status == null) {
            throw new IllegalArgumentException("Response.Status cannot be null");
        }
        Resource resource = ModelFactory.createDefaultModel().createResource().addProperty(RDF.type, (RDFNode)HTTP.Response).addLiteral((Property)HTTP.statusCodeValue, (long)status.getStatusCode()).addLiteral((Property)HTTP.reasonPhrase, (Object)status.getReasonPhrase());
        if (statusResource != null) {
            resource.addProperty((Property)HTTP.sc, (RDFNode)statusResource);
        }
        if (ex.getMessage() != null) {
            resource.addLiteral(DCTerms.title, (Object)ex.getMessage());
        }
        return resource;
    }

    public Response.ResponseBuilder getResponseBuilder(Dataset dataset) {
        Variant variant = this.getRequest().selectVariant(this.getVariants(Dataset.class));
        if (variant == null) {
            return this.getResponseBuilder(dataset.getDefaultModel());
        }
        Response.ResponseBuilder builder = new Response(this.getRequest(), (Object)dataset, null, new EntityTag(Long.toHexString(Response.hashDataset((Dataset)dataset))), variant).getResponseBuilder().header("Link", (Object)new Link(this.getUriInfo().getBaseUri(), LDT.base.getURI(), null));
        if (this.getTemplateCall().isPresent()) {
            builder.header("Link", (Object)new Link(URI.create(this.getTemplateCall().get().getTemplate().getURI()), LDT.template.getURI(), null));
        }
        if (this.getOntology() != null) {
            builder.header("Link", (Object)new Link(URI.create(this.getOntology().getURI()), LDT.ontology.getURI(), null));
        }
        return builder;
    }

    public Response.ResponseBuilder getResponseBuilder(Model model) {
        Variant variant = this.getRequest().selectVariant(this.getVariants(Model.class));
        if (variant == null) {
            variant = new Variant((javax.ws.rs.core.MediaType)MediaType.TEXT_TURTLE_TYPE, (Locale)null, null);
        }
        Response.ResponseBuilder builder = new Response(this.getRequest(), (Object)model, null, new EntityTag(Long.toHexString(ModelUtils.hashModel((Model)model))), variant).getResponseBuilder().header("Link", (Object)new Link(this.getUriInfo().getBaseUri(), LDT.base.getURI(), null));
        if (this.getTemplateCall().isPresent()) {
            builder.header("Link", (Object)new Link(URI.create(this.getTemplateCall().get().getTemplate().getURI()), LDT.template.getURI(), null));
        }
        if (this.getOntology() != null) {
            builder.header("Link", (Object)new Link(URI.create(this.getOntology().getURI()), LDT.ontology.getURI(), null));
        }
        return builder;
    }

    public List<Variant> getVariants(Class clazz) {
        return this.getVariants(this.getWritableMediaTypes(clazz));
    }

    public List<Variant> getVariants(List<javax.ws.rs.core.MediaType> mediaTypes) {
        return Response.getVariantListBuilder(mediaTypes, this.getLanguages(), this.getEncodings()).add().build();
    }

    public List<javax.ws.rs.core.MediaType> getWritableMediaTypes(Class clazz) {
        return this.getMediaTypes().getWritable(clazz);
    }

    public List<Locale> getLanguages() {
        return new ArrayList<Locale>();
    }

    public List<String> getEncodings() {
        return new ArrayList<String>();
    }

    public Request getRequest() {
        return this.request;
    }

    public Optional<TemplateCall> getTemplateCall() {
        return this.templateCall;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public MediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

