/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.model.impl;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.model.Service;
import com.atomgraph.core.model.impl.QueriedResourceBase;
import com.atomgraph.core.util.Link;
import com.atomgraph.processor.exception.OntologyException;
import com.atomgraph.processor.model.Application;
import com.atomgraph.processor.model.TemplateCall;
import com.atomgraph.processor.vocabulary.LDT;
import com.atomgraph.server.model.QueriedResource;
import com.atomgraph.server.model.Resource;
import com.atomgraph.spinrdf.model.update.Update;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.util.ClsLoader;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class ResourceBase
extends QueriedResourceBase
implements Resource,
QueriedResource {
    private static final Logger log = LoggerFactory.getLogger(ResourceBase.class);
    private final Application application;
    private final Ontology ontology;
    private final Optional<TemplateCall> templateCall;
    private final OntResource ontResource;
    private final ResourceContext resourceContext;
    private final HttpHeaders httpHeaders;
    private final QuerySolutionMap querySolutionMap;
    private final Query query;
    private final org.apache.jena.rdf.model.Resource queryResource;
    private final org.apache.jena.rdf.model.Resource updateResource;
    private final UpdateRequest update;

    @Inject
    public ResourceBase(@Context UriInfo uriInfo, @Context Request request, MediaTypes mediaTypes, Service service, Application application, Ontology ontology, Optional<TemplateCall> templateCall, @Context HttpHeaders httpHeaders, @Context ResourceContext resourceContext) {
        this(uriInfo, request, mediaTypes, uriInfo.getAbsolutePath(), service, application, ontology, templateCall, httpHeaders, resourceContext);
    }

    protected ResourceBase(UriInfo uriInfo, Request request, MediaTypes mediaTypes, URI uri, Service service, Application application, Ontology ontology, Optional<TemplateCall> templateCall, HttpHeaders httpHeaders, ResourceContext resourceContext) {
        super(uriInfo, request, mediaTypes, uri, service);
        if (application == null) {
            throw new IllegalArgumentException("Application cannot be null");
        }
        if (ontology == null) {
            throw new IllegalArgumentException("Ontology cannot be null");
        }
        if (httpHeaders == null) {
            throw new IllegalArgumentException("HttpHeaders cannot be null");
        }
        if (resourceContext == null) {
            throw new IllegalArgumentException("ResourceContext cannot be null");
        }
        this.application = application;
        this.ontology = ontology;
        this.ontResource = ontology.getOntModel().createOntResource(this.getURI().toString());
        this.templateCall = templateCall;
        this.httpHeaders = httpHeaders;
        this.resourceContext = resourceContext;
        if (templateCall.isPresent()) {
            if (log.isDebugEnabled()) {
                log.debug("Constructing ResourceBase with matched Template: {}", (Object)templateCall.get().getTemplate());
            }
            this.querySolutionMap = templateCall.get().getQuerySolutionMap();
            this.querySolutionMap.add("this", (RDFNode)this.ontResource);
            this.queryResource = templateCall.get().getTemplate().getQuery();
            this.query = this.queryResource != null ? (this.queryResource.canAs(com.atomgraph.spinrdf.model.TemplateCall.class) ? new ParameterizedSparqlString(((com.atomgraph.spinrdf.model.TemplateCall)this.queryResource.as(com.atomgraph.spinrdf.model.TemplateCall.class)).getTemplate().getBody().getText(), this.querySolutionMap, uriInfo.getBaseUri().toString()).asQuery() : (this.queryResource.canAs(com.atomgraph.spinrdf.model.Query.class) ? new ParameterizedSparqlString(((com.atomgraph.spinrdf.model.Query)this.queryResource.as(com.atomgraph.spinrdf.model.Query.class)).getText(), this.querySolutionMap, uriInfo.getBaseUri().toString()).asQuery() : null)) : null;
            this.updateResource = templateCall.get().getTemplate().getUpdate();
            this.update = this.updateResource != null ? (this.updateResource.canAs(com.atomgraph.spinrdf.model.TemplateCall.class) ? new ParameterizedSparqlString(((com.atomgraph.spinrdf.model.TemplateCall)this.updateResource.as(com.atomgraph.spinrdf.model.TemplateCall.class)).getTemplate().getBody().getText(), this.querySolutionMap, uriInfo.getBaseUri().toString()).asUpdate() : (this.updateResource.canAs(Update.class) ? new ParameterizedSparqlString(((Update)this.updateResource.as(Update.class)).getText(), this.querySolutionMap, uriInfo.getBaseUri().toString()).asUpdate() : null)) : null;
        } else {
            this.querySolutionMap = null;
            this.queryResource = null;
            this.query = null;
            this.updateResource = null;
            this.update = null;
        }
    }

    @Path(value="{path: .+}")
    public Object getSubResource() {
        if (this.getTemplateCall().isPresent() && this.getTemplateCall().get().getTemplate().getLoadClass() != null) {
            org.apache.jena.rdf.model.Resource javaClass = this.getTemplateCall().get().getTemplate().getLoadClass();
            if (!javaClass.isURIResource()) {
                if (log.isErrorEnabled()) {
                    log.error("ldt:loadClass value of template '{}' is not a URI resource", (Object)this.getTemplateCall().get().getTemplate());
                }
                throw new OntologyException("ldt:loadClass value of template '" + this.getTemplateCall().get().getTemplate() + "' is not a URI resource");
            }
            Class clazz = ClsLoader.loadClass((String)javaClass.getURI());
            if (clazz == null) {
                if (log.isErrorEnabled()) {
                    log.error("Java class with URI '{}' could not be loaded", (Object)javaClass.getURI());
                }
                throw new OntologyException("Java class with URI '" + javaClass.getURI() + "' not found");
            }
            if (log.isDebugEnabled()) {
                log.debug("Loading Java class with URI: {}", (Object)javaClass.getURI());
            }
            return this.getResourceContext().getResource(clazz);
        }
        return this;
    }

    public Response get() {
        if (!this.getTemplateCall().isPresent()) {
            if (log.isDebugEnabled()) {
                log.debug("Resource {} has not matched any ldt:Template, returning 404 Not Found", (Object)this.getURI());
            }
            throw new NotFoundException("Resource has not matched any ldt:Template");
        }
        if (this.getQueryResource() == null) {
            if (log.isErrorEnabled()) {
                log.error("ldt:query value for template '{}' is missing", (Object)this.getTemplateCall().get().getTemplate());
            }
            throw new OntologyException("ldt:query value for template '" + this.getTemplateCall().get().getTemplate() + "' is missing");
        }
        if (!this.getQueryResource().canAs(com.atomgraph.spinrdf.model.Query.class) && !this.getQueryResource().canAs(com.atomgraph.spinrdf.model.TemplateCall.class)) {
            if (log.isErrorEnabled()) {
                log.error("ldt:query value for template '{}' cannot be cast to sp:Query", (Object)this.getQueryResource());
            }
            throw new OntologyException("ldt:query value of template '" + this.getQueryResource() + "' cannot be cast to sp:Query");
        }
        return super.get();
    }

    public Response post(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset cannot be null");
        }
        this.getService().getDatasetAccessor().add(dataset.getDefaultModel());
        Iterator it = dataset.listNames();
        while (it.hasNext()) {
            String graphName = (String)it.next();
            this.getService().getDatasetAccessor().add(graphName, dataset.getNamedModel(graphName));
        }
        return Response.ok().build();
    }

    public Response put(Dataset dataset) {
        try {
            this.delete();
            return this.post(dataset);
        }
        catch (NotFoundException ex) {
            this.post(dataset);
            return Response.created((URI)this.getURI()).build();
        }
    }

    public Response delete() {
        this.get();
        if (this.getUpdateResource() != null && !this.getUpdateResource().canAs(Update.class) && !this.getUpdateResource().canAs(com.atomgraph.spinrdf.model.TemplateCall.class)) {
            if (log.isErrorEnabled()) {
                log.error("ldt:update value for template '{}' cannot be cast to a sp:Update", (Object)this.getTemplateCall().get().getTemplate());
            }
            throw new OntologyException("ldt:update value for template '" + this.getTemplateCall().get().getTemplate() + "' cannot be cast to a sp:Update");
        }
        if (this.getUpdate() == null) {
            return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
        }
        if (log.isDebugEnabled()) {
            log.debug("DELETE UpdateRequest: {}", (Object)this.getUpdate());
        }
        this.getService().getEndpointAccessor().update(this.getUpdate(), Collections.emptyList(), Collections.emptyList());
        return Response.noContent().build();
    }

    public QuerySolutionMap getQuerySolutionMap() {
        return this.querySolutionMap;
    }

    public Response.ResponseBuilder getResponseBuilder(Dataset dataset) {
        return super.getResponseBuilder(dataset).cacheControl(this.getCacheControl()).header("Link", (Object)new Link(URI.create(this.getTemplateCall().get().getTemplate().getURI()), LDT.template.getURI(), null)).header("Link", (Object)new Link(URI.create(this.getApplication().getOntology().getURI()), LDT.ontology.getURI(), null)).header("Link", (Object)new Link(this.getUriInfo().getBaseUri(), LDT.base.getURI(), null));
    }

    public Response.ResponseBuilder getResponseBuilder(Model model) {
        return super.getResponseBuilder(model).cacheControl(this.getCacheControl()).header("Link", (Object)new Link(URI.create(this.getTemplateCall().get().getTemplate().getURI()), LDT.template.getURI(), null)).header("Link", (Object)new Link(URI.create(this.getApplication().getOntology().getURI()), LDT.ontology.getURI(), null)).header("Link", (Object)new Link(this.getUriInfo().getBaseUri(), LDT.base.getURI(), null));
    }

    public List<Locale> getLanguages() {
        return this.getTemplateCall().get().getTemplate().getLanguages();
    }

    public OntResource getOntResource() {
        return this.ontResource;
    }

    @Override
    public Optional<TemplateCall> getTemplateCall() {
        return this.templateCall;
    }

    public CacheControl getCacheControl() {
        return this.getTemplateCall().get().getTemplate().getCacheControl();
    }

    public Query getQuery() {
        return this.query;
    }

    public org.apache.jena.rdf.model.Resource getQueryResource() {
        return this.queryResource;
    }

    @Override
    public UpdateRequest getUpdate() {
        return this.update;
    }

    public org.apache.jena.rdf.model.Resource getUpdateResource() {
        return this.updateResource;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Ontology getOntology() {
        return this.ontology;
    }
}

