/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.resource.graph;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.model.Service;
import com.atomgraph.processor.model.Application;
import com.atomgraph.processor.model.TemplateCall;
import com.atomgraph.server.model.impl.ResourceBase;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Item
extends ResourceBase {
    private static final Logger log = LoggerFactory.getLogger(Item.class);

    @Inject
    public Item(@Context UriInfo uriInfo, @Context Request request, @Context MediaTypes mediaTypes, Service service, Application application, Ontology ontology, Optional<TemplateCall> templateCall, @Context HttpHeaders httpHeaders, @Context ResourceContext resourceContext) {
        super(uriInfo, request, mediaTypes, service, application, ontology, templateCall, httpHeaders, resourceContext);
        if (log.isDebugEnabled()) {
            log.debug("Constructing {} as direct indication of GRAPH {}", this.getClass(), (Object)uriInfo.getAbsolutePath());
        }
    }

    @Override
    public Response get() {
        if (!this.getService().getDatasetAccessor().containsModel(this.getURI().toString())) {
            if (log.isDebugEnabled()) {
                log.debug("GET Graph Store named graph with URI: {} not found", (Object)this.getURI());
            }
            throw new NotFoundException("Named graph not found");
        }
        Model model = this.getService().getDatasetAccessor().getModel(this.getURI().toString());
        if (log.isDebugEnabled()) {
            log.debug("GET Graph Store named graph with URI: {} found, returning Model of size(): {}", (Object)this.getURI(), (Object)model.size());
        }
        return this.getResponse(model);
    }

    @Override
    public Response post(Dataset dataset) {
        boolean existingGraph = this.getService().getDatasetAccessor().containsModel(this.getURI().toString());
        if (log.isDebugEnabled()) {
            log.debug("POST Model to named graph with URI: {} Did it already exist? {}", (Object)this.getURI(), (Object)existingGraph);
        }
        this.getService().getDatasetAccessor().add(this.getURI().toString(), dataset.getDefaultModel());
        if (existingGraph) {
            return Response.ok().build();
        }
        return Response.created((URI)this.getURI()).build();
    }

    @Override
    public Response put(Dataset dataset) {
        boolean existingGraph = this.getService().getDatasetAccessor().containsModel(this.getURI().toString());
        if (log.isDebugEnabled()) {
            log.debug("PUT Model to named graph with URI: {} Did it already exist? {}", (Object)this.getURI(), (Object)existingGraph);
        }
        this.getService().getDatasetAccessor().putModel(this.getURI().toString(), dataset.getDefaultModel());
        if (existingGraph) {
            return Response.ok().build();
        }
        return Response.created((URI)this.getURI()).build();
    }

    @Override
    public Response delete() {
        if (!this.getService().getDatasetAccessor().containsModel(this.getURI().toString())) {
            if (log.isDebugEnabled()) {
                log.debug("DELETE named graph with URI {}: not found", (Object)this.getURI());
            }
            throw new NotFoundException("Named graph not found");
        }
        if (log.isDebugEnabled()) {
            log.debug("DELETE named graph with URI: {}", (Object)this.getURI());
        }
        this.getService().getDatasetAccessor().deleteModel(this.getURI().toString());
        return Response.noContent().build();
    }
}

