/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.util;

import com.atomgraph.core.util.jena.DataManager;
import com.atomgraph.processor.exception.OntologyException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ClientErrorException;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ModelGetter;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyLoader {
    private static final Logger log = LoggerFactory.getLogger(OntologyLoader.class);
    private final OntDocumentManager ontDocumentManager;
    private final String ontologyURI;

    public OntologyLoader(OntDocumentManager ontDocumentManager, String ontologyURI, OntModelSpec materializationSpec, boolean materialize) {
        if (ontDocumentManager == null) {
            throw new IllegalArgumentException("OntDocumentManager cannot be null");
        }
        if (ontologyURI == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        if (materializationSpec == null) {
            throw new IllegalArgumentException("OntModelSpec cannot be null");
        }
        this.ontDocumentManager = ontDocumentManager;
        this.ontologyURI = ontologyURI;
        if (materialize) {
            OntModel ontModel = OntologyLoader.getOntModel(ontDocumentManager, ontologyURI, materializationSpec);
            Ontology ontology = ontModel.getOntology(ontologyURI);
            ImportCycleChecker checker = new ImportCycleChecker();
            checker.check(ontology);
            if (checker.getCycleOntology() != null) {
                if (log.isErrorEnabled()) {
                    log.error("Sitemap contains an ontology which forms an import cycle: {}", (Object)checker.getCycleOntology());
                }
                throw new OntologyException("Sitemap contains an ontology which forms an import cycle: " + checker.getCycleOntology().getURI());
            }
            OntModel materializedModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            materializedModel.add((Model)ontModel);
            ontDocumentManager.addModel(ontologyURI, (Model)materializedModel, true);
        }
    }

    public Ontology getOntology() {
        OntModelSpec loadSpec = OntModelSpec.OWL_MEM;
        if (this.getOntDocumentManager().getFileManager() instanceof DataManager) {
            loadSpec.setImportModelGetter((ModelGetter)((DataManager)this.getOntDocumentManager().getFileManager()));
        }
        return this.getOntology(loadSpec);
    }

    public Ontology getOntology(OntModelSpec loadSpec) {
        return OntologyLoader.getOntModel(this.getOntDocumentManager(), this.getOntologyURI(), loadSpec).getOntology(this.getOntologyURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OntModel getOntModel(OntDocumentManager manager, String ontologyURI, OntModelSpec ontModelSpec) {
        OntModel ontModel;
        if (manager == null) {
            throw new IllegalArgumentException("OntDocumentManager cannot be null");
        }
        if (ontologyURI == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        if (ontModelSpec == null) {
            throw new IllegalArgumentException("OntModelSpec cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading sitemap ontology from URI: {}", (Object)ontologyURI);
        }
        OntModel ontModel2 = manager.getOntology(ontologyURI, ontModelSpec);
        ontModel2.enterCriticalSection(true);
        try {
            ontModel = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec, (Model)ModelFactory.createUnion((Model)ModelFactory.createDefaultModel(), (Model)ontModel2.getBaseModel()));
        }
        catch (Throwable throwable) {
            try {
                ontModel2.leaveCriticalSection();
                throw throwable;
            }
            catch (ClientErrorException ex) {
                manager.getFileManager().removeCacheModel(ontologyURI);
                if (log.isErrorEnabled()) {
                    log.error("Could not load ontology '{}' or its imports", (Object)ontologyURI);
                }
                throw new OntologyException("Could not load ontology '" + ontologyURI + "' or its imports", ex);
            }
        }
        ontModel2.leaveCriticalSection();
        return ontModel;
    }

    public OntDocumentManager getOntDocumentManager() {
        return this.ontDocumentManager;
    }

    public String getOntologyURI() {
        return this.ontologyURI;
    }

    public class ImportCycleChecker {
        private final Map<Ontology, Boolean> marked = new HashMap<Ontology, Boolean>();
        private final Map<Ontology, Boolean> onStack = new HashMap<Ontology, Boolean>();
        private Ontology cycleOntology = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void check(Ontology ontology) {
            if (ontology == null) {
                throw new IllegalArgumentException("Ontology cannot be null");
            }
            this.marked.put(ontology, Boolean.TRUE);
            this.onStack.put(ontology, Boolean.TRUE);
            try (ExtendedIterator it = ontology.listImports();){
                while (it.hasNext()) {
                    OntResource importRes = (OntResource)it.next();
                    if (!importRes.canAs(Ontology.class)) continue;
                    Ontology imported = importRes.asOntology();
                    if (this.marked.get(imported) == null) {
                        this.check(imported);
                        continue;
                    }
                    if (!this.onStack.get(imported).booleanValue()) continue;
                    this.cycleOntology = imported;
                    return;
                }
                this.onStack.put(ontology, Boolean.FALSE);
                return;
            }
        }

        public Ontology getCycleOntology() {
            return this.cycleOntology;
        }
    }
}

