/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.BackendlessInjector;
import com.backendless.IHeadersManager;
import com.backendless.PlainHeadersManager;
import com.backendless.commons.DeviceType;
import com.backendless.exceptions.BackendlessException;
import java.util.Map;

class BLHeadersManager
implements IHeadersManager {
    private static final BLHeadersManager instance = new BLHeadersManager();
    private final ThreadLocal<PlainHeadersManager> threadLocal = new InheritableThreadLocal<PlainHeadersManager>(){

        @Override
        protected PlainHeadersManager initialValue() {
            return new BLHeadersManagerHolder();
        }
    };

    static BLHeadersManager getInstance() {
        return instance;
    }

    private BLHeadersManager() {
    }

    public void cleanHeaders() {
        this.threadLocal.remove();
    }

    public void addHeader(IHeadersManager.HeadersEnum headersEnum, String value) {
        this.threadLocal.get().addHeader(headersEnum, value);
    }

    public void addHeader(String name, String value) {
        this.threadLocal.get().addHeader(name, value);
    }

    public void addHeaders(Map<String, String> headers) {
        this.threadLocal.get().addHeaders(headers);
    }

    public void removeHeader(IHeadersManager.HeadersEnum headersEnum) {
        this.threadLocal.get().removeHeader(headersEnum);
    }

    public void removeHeader(String name) {
        this.threadLocal.get().removeHeader(name);
    }

    public Map<String, String> getHeaders() throws BackendlessException {
        return this.threadLocal.get().getHeaders();
    }

    public void setHeaders(Map<String, String> headers) {
        this.threadLocal.get().setHeaders(headers);
    }

    public String getHeader(IHeadersManager.HeadersEnum headersEnum) throws BackendlessException {
        return this.threadLocal.get().getHeader(headersEnum);
    }

    public String getHeader(String name) {
        return this.threadLocal.get().getHeader(name);
    }

    private static class BLHeadersManagerHolder
    extends PlainHeadersManager {
        private BLHeadersManagerHolder() {
        }

        public void cleanHeaders() {
            super.cleanHeaders();
            this.addHeader(IHeadersManager.HeadersEnum.APP_TYPE_NAME, DeviceType.BL.name());
            this.addHeader(IHeadersManager.HeadersEnum.API_VERSION, "1.0");
            this.addHeaders(BackendlessInjector.getInstance().getPrefs().getHeaders());
        }
    }
}

