/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.Invoker;
import com.backendless.Persistence;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.core.responder.AdaptingResponder;
import com.backendless.core.responder.policy.PoJoAdaptingPolicy;
import com.backendless.persistence.BackendlessSerializer;
import com.backendless.persistence.PersistenceOperations;
import com.backendless.utils.PermissionTypes;
import java.util.Map;

public abstract class AbstractDataPermission {
    private static final String PERMISSION_SERVICE = "com.backendless.services.persistence.permissions.ClientPermissionService";

    protected abstract PersistenceOperations getOperation();

    public <T> void grantForUser(String userId, T dataObject) {
        this.grantForUser(userId, dataObject, null);
    }

    public <T> void grantForUser(String userId, T dataObject, AsyncCallback<T> responder) {
        String method = "updateUserPermission";
        Object[] args = this.buildArgs(dataObject, userId, PermissionTypes.GRANT);
        this.serverCall(responder, method, args, dataObject.getClass());
    }

    public <T> void denyForUser(String userId, T dataObject) {
        this.denyForUser(userId, dataObject, null);
    }

    public <T> void denyForUser(String userId, T dataObject, AsyncCallback<T> responder) {
        String method = "updateUserPermission";
        Object[] args = this.buildArgs(dataObject, userId, PermissionTypes.DENY);
        this.serverCall(responder, method, args, null);
    }

    public <T> void grantForRole(String roleName, T dataObject) {
        this.grantForRole(roleName, dataObject, null);
    }

    public <T> void grantForRole(String roleName, T dataObject, AsyncCallback<T> responder) {
        String method = "updateRolePermission";
        Object[] args = this.buildArgs(dataObject, roleName, PermissionTypes.GRANT);
        this.serverCall(responder, method, args, dataObject.getClass());
    }

    public <T> void denyForRole(String roleName, T dataObject) {
        this.denyForRole(roleName, dataObject, null);
    }

    public <T> void denyForRole(String roleName, T dataObject, AsyncCallback<T> responder) {
        String method = "updateRolePermission";
        Object[] args = this.buildArgs(dataObject, roleName, PermissionTypes.DENY);
        this.serverCall(responder, method, args, null);
    }

    public <T> void grantForAllUsers(T dataObject) {
        this.grantForAllUsers(dataObject, null);
    }

    public <T> void grantForAllUsers(T dataObject, AsyncCallback<T> responder) {
        String method = "updateAllUserPermission";
        Object[] args = this.buildArgs(dataObject, null, PermissionTypes.GRANT);
        this.serverCall(responder, method, args, dataObject.getClass());
    }

    public <T> void denyForAllUsers(T dataObject) {
        this.denyForAllUsers(dataObject, null);
    }

    public <T> void denyForAllUsers(T dataObject, AsyncCallback<T> responder) {
        String method = "updateAllUserPermission";
        Object[] args = this.buildArgs(dataObject, null, PermissionTypes.DENY);
        this.serverCall(responder, method, args, null);
    }

    public <T> void grantForAllRoles(T dataObject) {
        this.grantForAllRoles(dataObject, null);
    }

    public <T> void grantForAllRoles(T dataObject, AsyncCallback<T> responder) {
        String method = "updateAllRolePermission";
        Object[] args = this.buildArgs(dataObject, null, PermissionTypes.GRANT);
        this.serverCall(responder, method, args, dataObject.getClass());
    }

    public <T> void denyForAllRoles(T dataObject) {
        this.denyForAllRoles(dataObject, null);
    }

    public <T> void denyForAllRoles(T dataObject, AsyncCallback<T> responder) {
        String method = "updateAllRolePermission";
        Object[] args = this.buildArgs(dataObject, null, PermissionTypes.DENY);
        this.serverCall(responder, method, args, null);
    }

    private <T> Object[] buildArgs(T dataObject, String principal, PermissionTypes permissionType) {
        String objectId = Persistence.getEntityId(dataObject);
        PersistenceOperations operation = this.getOperation();
        String tableName = dataObject instanceof Map ? (String)((Map)dataObject).get("___class") : BackendlessSerializer.getSimpleName(dataObject.getClass());
        if (principal != null) {
            return new Object[]{tableName, principal, objectId, operation, permissionType};
        }
        return new Object[]{tableName, objectId, operation, permissionType};
    }

    private <T> void serverCall(AsyncCallback<T> responder, String method, Object[] args, Class type) {
        if (responder == null) {
            Invoker.invokeSync(PERMISSION_SERVICE, method, args, new AdaptingResponder(type, new PoJoAdaptingPolicy()));
        } else {
            Invoker.invokeAsync(PERMISSION_SERVICE, method, args, responder, new AdaptingResponder(type, new PoJoAdaptingPolicy()));
        }
    }
}

