/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.BackendlessInjector;
import com.backendless.BackendlessPrefs;
import com.backendless.BackendlessUser;
import com.backendless.Cache;
import com.backendless.Commerce;
import com.backendless.Counters;
import com.backendless.CustomService;
import com.backendless.Events;
import com.backendless.Files;
import com.backendless.FootprintsManager;
import com.backendless.IHeadersManager;
import com.backendless.Invoker;
import com.backendless.Logging;
import com.backendless.Persistence;
import com.backendless.ThreadPoolService;
import com.backendless.UserService;
import com.backendless.files.BackendlessFile;
import com.backendless.files.BackendlessFileFactory;
import com.backendless.hive.Hive;
import com.backendless.hive.HiveManagement;
import com.backendless.hive.ScanResult;
import com.backendless.hive.ScanResultFactory;
import com.backendless.io.BackendlessUserFactory;
import com.backendless.io.BackendlessUserWriter;
import com.backendless.io.DoubleWriter;
import com.backendless.persistence.BackendlessGeometryFactory;
import com.backendless.persistence.BackendlessGeometryWriter;
import com.backendless.persistence.BackendlessSerializer;
import com.backendless.persistence.Geometry;
import com.backendless.persistence.GeometryDTO;
import com.backendless.persistence.JsonDTO;
import com.backendless.persistence.JsonDTOAdaptingType;
import com.backendless.persistence.LineString;
import com.backendless.persistence.Point;
import com.backendless.persistence.Polygon;
import com.backendless.persistence.QueryOptions;
import com.backendless.persistence.RealmSerializer;
import com.backendless.rt.RTClientFactory;
import com.backendless.rt.RTServiceImpl;
import com.backendless.rt.data.EventHandlerFactory;
import com.backendless.rt.messaging.ChannelFactory;
import com.backendless.rt.rso.SharedObjectFactory;
import com.backendless.util.JSONConverter;
import com.backendless.util.JSONUtil;
import com.backendless.utils.JSONConverterWeborbImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import weborb.ORBConstants;
import weborb.config.ORBConfig;
import weborb.types.Types;
import weborb.util.IArgumentObjectFactory;
import weborb.util.ObjectFactories;
import weborb.util.log.Log;
import weborb.writer.IProtocolFormatter;
import weborb.writer.ITypeWriter;
import weborb.writer.MessageWriter;
import weborb.writer.amf.AmfV3Formatter;

final class BackendlessInternal {
    private static String url = "https://api.backendless.com";
    private static BackendlessPrefs prefs;
    private static boolean initialized;

    static void init() {
        block4: {
            BackendlessInjector injector = BackendlessInjector.getInstance();
            prefs = injector.getPrefs();
            if (prefs.getUrl() == null) {
                prefs.setUrl(url);
            }
            ORBConfig.getORBConfig();
            Invoker.reinitialize();
            Log.removeLogger((String)"default");
            JSONUtil.setJsonConverter((JSONConverter)new JSONConverterWeborbImpl());
            AmfV3Formatter.AddTypeWriter(QueryOptions.class, (ITypeWriter)new ITypeWriter(){

                public void write(Object o, IProtocolFormatter iProtocolFormatter) throws IOException {
                    QueryOptions queryOptions = (QueryOptions)o;
                    HashMap<String, Object> queryOptionsMap = new HashMap<String, Object>();
                    queryOptionsMap.put(ORBConstants.WEBORB_TYPE_NAME.toString(), QueryOptions.class.getSimpleName());
                    queryOptionsMap.put("sortBy", queryOptions.getSortBy());
                    queryOptionsMap.put("related", queryOptions.getRelated());
                    queryOptionsMap.put("fileReferencePrefix", queryOptions.getFileReferencePrefix());
                    if (queryOptions.getRelationsDepth() != null) {
                        queryOptionsMap.put("relationsDepth", queryOptions.getRelationsDepth());
                    }
                    if (queryOptions.getRelationsPageSize() != null) {
                        queryOptionsMap.put("relationsPageSize", queryOptions.getRelationsPageSize());
                    }
                    MessageWriter.writeObject(queryOptionsMap, (IProtocolFormatter)iProtocolFormatter);
                }

                public boolean isReferenceableType() {
                    return false;
                }
            });
            injector.setEventHandlerFactory(EventHandlerFactory.getInstance());
            injector.setChannelFactory(ChannelFactory.getInstance());
            injector.setSharedObjectFactory(SharedObjectFactory.getInstance());
            injector.setThreadPoolService(ThreadPoolService.getInstance());
            injector.setRtClient(RTClientFactory.getInstance().get());
            injector.setFootprintsManager(FootprintsManager.getInstance());
            injector.setUserService(UserService.getInstance());
            injector.setPersistence(Persistence.getInstance());
            injector.setFiles(Files.getInstance());
            injector.setCommerce(Commerce.getInstance());
            injector.setEvents(Events.getInstance());
            injector.setCache(Cache.getInstance());
            injector.setCounters(Counters.getInstance());
            injector.setCustomService(CustomService.getInstance());
            injector.setLogging(Logging.getInstance());
            injector.setRtService(RTServiceImpl.getInstance());
            try {
                if (!initialized && prefs.getApplicationId() != null && prefs.getApiKey() != null) {
                    BackendlessInternal.initApplicationFromProperties();
                }
            }
            catch (IllegalStateException e) {
                if ("Backendless application was not initialized. Call Backendless.initApp method before use any backendless functionality".equals(e.getMessage())) break block4;
                throw e;
            }
        }
    }

    private BackendlessInternal() {
    }

    static void initApp(String applicationId, String apiKey) {
        BackendlessInternal.initApp(BackendlessInjector.getInstance().getContextHandler().getAppContext(), applicationId, apiKey);
    }

    static void initApp(String customDomain) {
        BackendlessInternal.initApp(BackendlessInjector.getInstance().getContextHandler().getAppContext(), customDomain);
    }

    static boolean isInitialized() {
        return initialized;
    }

    static void initApp(Object context, String customDomain) {
        URI uri;
        if (customDomain == null || customDomain.trim().isEmpty()) {
            throw new IllegalArgumentException("Custom domain cant be null or empty");
        }
        if (customDomain.startsWith("http")) {
            BackendlessInternal.setUrl(customDomain);
        } else {
            BackendlessInternal.setUrl("http://" + customDomain);
        }
        try {
            uri = new URI(BackendlessInternal.getUrl());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        prefs.setCustomDomain(uri.getHost());
        BackendlessInjector.getInstance().getContextHandler().setContext(context);
        BackendlessInternal.initApp();
    }

    static void initApp(Object context, String applicationId, String apiKey) {
        if (applicationId == null || applicationId.equals("")) {
            throw new IllegalArgumentException("Application id cannot be null");
        }
        if (apiKey == null || apiKey.equals("")) {
            throw new IllegalArgumentException("Secret key cannot be null");
        }
        prefs.initPreferences(applicationId, apiKey);
        BackendlessInjector.getInstance().getContextHandler().setContext(context);
        BackendlessInternal.initApp();
    }

    private static void initApp() {
        if (BackendlessInjector.getInstance().isAndroid() && BackendlessInjector.getInstance().getContextHandler().getAppContext() == null) {
            throw new IllegalArgumentException("Context cannot be null. Use Backendless.initApp( Context context, String applicationId, String secretKey ) for proper initialization.");
        }
        MessageWriter.addTypeWriter(BackendlessUser.class, (ITypeWriter)new BackendlessUserWriter());
        MessageWriter.addTypeWriter(Double.class, (ITypeWriter)new DoubleWriter());
        MessageWriter.addTypeWriter(Geometry.class, (ITypeWriter)new BackendlessGeometryWriter());
        MessageWriter.addTypeWriter(Point.class, (ITypeWriter)new BackendlessGeometryWriter());
        MessageWriter.addTypeWriter(LineString.class, (ITypeWriter)new BackendlessGeometryWriter());
        MessageWriter.addTypeWriter(Polygon.class, (ITypeWriter)new BackendlessGeometryWriter());
        ObjectFactories.addArgumentObjectFactory((String)BackendlessUser.class.getName(), (IArgumentObjectFactory)new BackendlessUserFactory());
        ObjectFactories.addArgumentObjectFactory((String)BackendlessFile.class.getName(), (IArgumentObjectFactory)new BackendlessFileFactory());
        ObjectFactories.addArgumentObjectFactory((String)GeometryDTO.class.getName(), (IArgumentObjectFactory)new BackendlessGeometryFactory());
        ObjectFactories.addArgumentObjectFactory((String)Geometry.class.getName(), (IArgumentObjectFactory)new BackendlessGeometryFactory());
        ObjectFactories.addArgumentObjectFactory((String)Point.class.getName(), (IArgumentObjectFactory)new BackendlessGeometryFactory());
        ObjectFactories.addArgumentObjectFactory((String)LineString.class.getName(), (IArgumentObjectFactory)new BackendlessGeometryFactory());
        ObjectFactories.addArgumentObjectFactory((String)Polygon.class.getName(), (IArgumentObjectFactory)new BackendlessGeometryFactory());
        ObjectFactories.addArgumentObjectFactory((String)ScanResult.class.getName(), (IArgumentObjectFactory)new ScanResultFactory());
        Types.addClientClassMapping((String)JsonDTO.class.getName(), JsonDTOAdaptingType.class);
        BackendlessInjector.getInstance().getHeadersManager().cleanHeaders();
        Invoker.reinitialize();
        if (BackendlessInjector.getInstance().isCodeRunner()) {
            initialized = true;
            return;
        }
        String userToken = BackendlessInjector.getInstance().getUserTokenStorage().get();
        if (userToken != null && !userToken.equals("")) {
            BackendlessInjector.getInstance().getHeadersManager().addHeader(IHeadersManager.HeadersEnum.USER_TOKEN_KEY, userToken);
        }
        try {
            Class<?> realmObjectClass = Class.forName("io.realm.RealmObject");
            BackendlessSerializer.addSerializer(realmObjectClass, new RealmSerializer());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        initialized = true;
    }

    static BackendlessPrefs getPrefs() {
        return prefs;
    }

    static void setUIState(String state) {
        if (prefs == null) {
            throw new IllegalStateException("Backendless application was not initialized. Call Backendless.initApp method before use any backendless functionality");
        }
        if (state == null || state.equals("")) {
            prefs.cleanHeaders();
        } else {
            HashMap<String, String> headers = prefs.getHeaders();
            if (headers == null) {
                headers = new HashMap();
            }
            headers.put(IHeadersManager.HeadersEnum.UI_STATE.getHeader(), state);
            prefs.setHeaders(headers);
        }
    }

    static String getApplicationIdOrDomain() {
        if (prefs == null) {
            throw new IllegalStateException("Backendless application was not initialized. Call Backendless.initApp method before use any backendless functionality");
        }
        return prefs.getApplicationIdOrDomain();
    }

    static String getApiKey() {
        if (prefs == null) {
            throw new IllegalStateException("Backendless application was not initialized. Call Backendless.initApp method before use any backendless functionality");
        }
        return prefs.getApiKey();
    }

    static Map<String, String> getHeaders() {
        if (prefs == null) {
            throw new IllegalStateException("Backendless application was not initialized. Call Backendless.initApp method before use any backendless functionality");
        }
        return prefs.getHeaders();
    }

    static String getUrl() {
        return url;
    }

    static void setUrl(String url) {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        BackendlessInternal.url = url;
        prefs.setUrl(url);
        Invoker.reinitialize();
    }

    static String getApplicationUrl() {
        String applicationId = prefs.getApplicationId();
        return applicationId == null ? BackendlessInternal.getUrl() + "/api" : BackendlessInternal.getUrl() + '/' + applicationId + '/' + BackendlessInternal.getApiKey();
    }

    static void initApplicationFromProperties(Object context) {
        BackendlessInternal.initApp(context, prefs.getApplicationId(), prefs.getApiKey());
        BackendlessInternal.setUrl(prefs.getUrl());
    }

    static void initApplicationFromProperties() {
        BackendlessInternal.initApp(prefs.getApplicationId(), prefs.getApiKey());
        BackendlessInternal.setUrl(prefs.getUrl());
    }

    static HiveManagement Hive() {
        return HiveManagement.getInstance();
    }

    static Hive Hive(String name) {
        return Hive.getOrCreate(name);
    }
}

