/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.AuthKeys;
import com.backendless.BackendlessInjector;
import com.backendless.messaging.AndroidPushTemplate;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import weborb.util.io.Serializer;

public abstract class BackendlessPrefs {
    static final String PREFS_NAME = "BackendlessPrefs";
    protected AuthKeys authKeys;
    protected final HashMap<String, String> headers = new HashMap();
    protected String url;
    protected String customDomain;
    protected String deviceId;
    protected String os;
    protected String osVersion;
    protected String pushTemplatesAsJson;
    protected final HashMap<String, AndroidPushTemplate> pushNotificationTemplates = new HashMap();
    protected final AtomicReference<Integer> notificationIdGeneratorState = new AtomicReference();

    BackendlessPrefs() {
    }

    protected abstract void retrieveDeviceId();

    protected abstract void retrieveOS();

    protected abstract void retrieveOSVersion();

    public void init() {
        this.retrieveDeviceId();
        this.retrieveOS();
        this.retrieveOSVersion();
        this.restorePushTemplates();
    }

    public void initPreferences(String applicationId, String apiKey) {
        this.authKeys = new AuthKeys(applicationId, apiKey);
    }

    public synchronized void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    public synchronized void cleanHeaders() {
        this.headers.clear();
    }

    public String getApplicationId() {
        AuthKeys authKeys = this.getAuthKeys();
        return authKeys == null ? null : authKeys.getApplicationId();
    }

    public String getApiKey() {
        AuthKeys authKeys = this.getAuthKeys();
        return authKeys == null ? null : authKeys.getApiKey();
    }

    public synchronized HashMap<String, String> getHeaders() {
        return this.headers;
    }

    private synchronized AuthKeys getAuthKeys() {
        return this.authKeys;
    }

    boolean isAuthKeysExist() {
        return this.authKeys != null;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCustomDomain() {
        return this.customDomain;
    }

    public void setCustomDomain(String customDomain) {
        this.customDomain = customDomain;
    }

    public String getApplicationIdOrDomain() {
        String appId = this.getApplicationId();
        if (appId != null) {
            return appId;
        }
        String customDomain = this.getCustomDomain();
        if (customDomain != null) {
            return customDomain;
        }
        throw new IllegalStateException("Backendless application was not initialized. Call Backendless.initApp method before use any backendless functionality");
    }

    public Object getContext() {
        return BackendlessInjector.getInstance().getContextHandler().getAppContext();
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getOs() {
        return this.os;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getPushTemplateAsJson() {
        return this.pushTemplatesAsJson;
    }

    public void savePushTemplateAsJson(String pushTemplatesAsJson) {
        this.pushTemplatesAsJson = pushTemplatesAsJson;
    }

    public int getNotificationIdGeneratorInitValue() {
        return this.notificationIdGeneratorState.get();
    }

    public void saveNotificationIdGeneratorState(int value) {
        this.notificationIdGeneratorState.set(value);
    }

    public Map<String, AndroidPushTemplate> getPushNotificationTemplates() {
        return Collections.unmodifiableMap(this.pushNotificationTemplates);
    }

    public AndroidPushTemplate getPushNotificationTemplate(String templateName) {
        return this.pushNotificationTemplates.get(templateName);
    }

    protected void restorePushTemplates() {
        if (this.getPushTemplateAsJson() == null) {
            return;
        }
        try {
            Map templates = (Map)Serializer.fromBytes((byte[])this.getPushTemplateAsJson().getBytes(), (int)3, (boolean)false);
            this.pushNotificationTemplates.clear();
            this.pushNotificationTemplates.putAll(templates);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot deserialize AndroidPushTemplate to JSONObject.", e);
        }
    }

    public void setPushNotificationTemplates(Map<String, AndroidPushTemplate> pushNotificationTemplates) {
        this.pushNotificationTemplates.clear();
        this.pushNotificationTemplates.putAll(pushNotificationTemplates);
        try {
            byte[] rawTemplates = Serializer.toBytes(pushNotificationTemplates, (int)3);
            this.savePushTemplateAsJson(new String(rawTemplates));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot serialize AndroidPushTemplate to JSONObject.", e);
        }
    }

    static enum Type {
        APPLICATION_ID_KEY,
        API_KEY,
        URL_KEY,
        CUSTOM_DOMAIN_KEY,
        HEADERS,
        PUSH_TEMPLATES,
        NOTIFICATION_ID_GENERATOR;


        String name64() {
            return UUID.nameUUIDFromBytes(this.name().getBytes()).toString();
        }
    }
}

