/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BackendlessUser
implements Serializable {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    public static final String PASSWORD_KEY = "password";
    public static final String EMAIL_KEY = "email";
    public static final String ID_KEY = "objectId";
    public static final String LOCALE = "blUserLocale";
    private Object marker;

    public BackendlessUser() {
        this.properties.put(LOCALE, System.getProperty("user.language"));
    }

    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Map<String, Object> properties) {
        BackendlessUser backendlessUser = this;
        synchronized (backendlessUser) {
            this.properties.clear();
            this.putProperties(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putProperties(Map<String, Object> properties) {
        BackendlessUser backendlessUser = this;
        synchronized (backendlessUser) {
            this.properties.putAll(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key) {
        BackendlessUser backendlessUser = this;
        synchronized (backendlessUser) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, Object value) {
        BackendlessUser backendlessUser = this;
        synchronized (backendlessUser) {
            this.properties.put(key, value);
        }
    }

    public String getObjectId() {
        return this.getUserId();
    }

    public String getUserId() {
        Object result = this.getProperty(ID_KEY);
        return result == null ? null : String.valueOf(result);
    }

    public void setPassword(String password) {
        this.setProperty(PASSWORD_KEY, password);
    }

    public String getPassword() {
        Object result = this.getProperty(PASSWORD_KEY);
        return result == null ? null : String.valueOf(result);
    }

    public void setEmail(String email) {
        this.setProperty(EMAIL_KEY, email);
    }

    public String getEmail() {
        Object result = this.getProperty(EMAIL_KEY);
        return result == null ? null : String.valueOf(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProperties() {
        BackendlessUser backendlessUser = this;
        synchronized (backendlessUser) {
            this.properties.clear();
        }
    }

    public Object removeProperty(String key) {
        return this.properties.remove(key);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty() || this.properties.size() == 1 && this.properties.containsKey(LOCALE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackendlessUser that = (BackendlessUser)o;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        HashSet<Object> refCache = new HashSet<Object>();
        return this.hashCode(refCache);
    }

    private int hashCode(Set<Object> refCache) {
        if (this.marker != null) {
            return 0;
        }
        this.marker = new Object();
        if (refCache.contains(this.marker)) {
            return 0;
        }
        refCache.add(this.marker);
        int hashCode = 0;
        for (Object value : this.properties.values()) {
            if (value == null) continue;
            if (value instanceof BackendlessUser) {
                hashCode += ((BackendlessUser)value).hashCode(refCache);
                continue;
            }
            hashCode += value.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BackendlessUser{");
        for (Map.Entry<String, Object> property : this.properties.entrySet()) {
            sb.append(property.getKey()).append("=").append(property.getValue()).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append("}");
        return sb.toString();
    }
}

