/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.AtomicCounterImpl;
import com.backendless.IAtomic;
import com.backendless.Invoker;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.atomic.AtomicCallback;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.utils.ResponderHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import weborb.client.IChainedResponder;

@Deprecated
public final class Counters {
    protected static final String ATOMIC_MANAGER_SERVER_ALIAS = "com.backendless.services.redis.AtomicOperationService";
    private static final Counters instance = new Counters();

    public static Counters getInstance() {
        return instance;
    }

    private Counters() {
    }

    public static Number convertToType(Number value, Class type) {
        if (type == Short.class) {
            return value.shortValue();
        }
        if (type == Integer.class) {
            return value.intValue();
        }
        if (type == Long.class) {
            return value.longValue();
        }
        if (type == Float.class) {
            return Float.valueOf(value.floatValue());
        }
        if (type == Double.class) {
            return value.doubleValue();
        }
        if (type == Byte.class) {
            return value.byteValue();
        }
        throw new RuntimeException("unsupported data type. Cannot adapt counter value to type - " + type);
    }

    public IAtomic of(String counterName) {
        if (counterName == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        return this.of(counterName, Long.class);
    }

    public <T> IAtomic<T> of(String counterName, Class<? extends T> type) {
        return new AtomicCounterImpl<T>(this, counterName, type);
    }

    public void reset(String counterName) {
        Invoker.invokeSync(ATOMIC_MANAGER_SERVER_ALIAS, "reset", new Object[]{counterName});
    }

    public void reset(String counterName, AsyncCallback callback) {
        Invoker.invokeAsync(ATOMIC_MANAGER_SERVER_ALIAS, "reset", new Object[]{counterName}, callback);
    }

    public Long get(String counterName) {
        return this.runGetOperation("get", counterName);
    }

    public <T> void get(String counterName, AsyncCallback<T> responder) {
        block2: {
            try {
                Invoker.invokeAsync(ATOMIC_MANAGER_SERVER_ALIAS, "get", new Object[]{counterName}, new AtomicCallback<T>(responder));
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public Long getAndIncrement(String counterName) {
        return this.runGetOperation("getAndIncrement", counterName);
    }

    public <T> void getAndIncrement(String counterName, AsyncCallback<T> responder) {
        block2: {
            try {
                Invoker.invokeAsync(ATOMIC_MANAGER_SERVER_ALIAS, "getAndIncrement", new Object[]{counterName}, new AtomicCallback<T>(responder));
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public Long incrementAndGet(String counterName) {
        return this.runGetOperation("incrementAndGet", counterName);
    }

    public <T> void incrementAndGet(String counterName, AsyncCallback<T> responder) {
        block2: {
            try {
                Invoker.invokeAsync(ATOMIC_MANAGER_SERVER_ALIAS, "incrementAndGet", new Object[]{counterName}, new AtomicCallback<T>(responder));
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public Long getAndDecrement(String counterName) {
        return this.runGetOperation("getAndDecrement", counterName);
    }

    public <T> void getAndDecrement(String counterName, AsyncCallback<T> responder) {
        block2: {
            try {
                Invoker.invokeAsync(ATOMIC_MANAGER_SERVER_ALIAS, "getAndDecrement", new Object[]{counterName}, new AtomicCallback<T>(responder));
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public Long decrementAndGet(String counterName) {
        return this.runGetOperation("decrementAndGet", counterName);
    }

    public <T> void decrementAndGet(String counterName, AsyncCallback<T> responder) {
        block2: {
            try {
                Invoker.invokeAsync(ATOMIC_MANAGER_SERVER_ALIAS, "decrementAndGet", new Object[]{counterName}, new AtomicCallback<T>(responder));
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public Long addAndGet(String counterName, Number value) {
        return this.runGetOperation("addAndGet", counterName, value);
    }

    public <T> void addAndGet(String counterName, Number value, AsyncCallback<T> responder) {
        block2: {
            try {
                Invoker.invokeAsync(ATOMIC_MANAGER_SERVER_ALIAS, "addAndGet", new Object[]{counterName, value}, new AtomicCallback<T>(responder));
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public Long getAndAdd(String counterName, Number value) {
        return this.runGetOperation("getAndAdd", counterName, value);
    }

    public <T> void getAndAdd(String counterName, Number value, AsyncCallback<T> responder) {
        block2: {
            try {
                Invoker.invokeAsync(ATOMIC_MANAGER_SERVER_ALIAS, "getAndAdd", new Object[]{counterName, value}, new AtomicCallback<T>(responder));
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public boolean compareAndSet(String counterName, Number expected, Number updated) {
        return (Boolean)Invoker.invokeSync(ATOMIC_MANAGER_SERVER_ALIAS, "compareAndSet", new Object[]{counterName, expected, updated});
    }

    public void compareAndSet(String counterName, Number expected, Number updated, AsyncCallback<Boolean> responder) {
        block2: {
            try {
                Invoker.invokeAsync(ATOMIC_MANAGER_SERVER_ALIAS, "compareAndSet", new Object[]{counterName, expected, updated}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public Set<String> list(String pattern) {
        Object[] objectArray = (Object[])Invoker.invokeSync(ATOMIC_MANAGER_SERVER_ALIAS, "list", new Object[]{pattern});
        return new HashSet<String>(Arrays.asList((String[])Arrays.copyOf(objectArray, objectArray.length, String[].class)));
    }

    public void list(String pattern, AsyncCallback<Set<String>> responder) {
        block2: {
            try {
                Invoker.invokeAsync(ATOMIC_MANAGER_SERVER_ALIAS, "list", new Object[]{pattern}, responder, (IChainedResponder)ResponderHelper.getSetAdaptingResponder(String.class));
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    private Long runGetOperation(String operationName, String counterName) {
        Number responseValue = (Number)Invoker.invokeSync(ATOMIC_MANAGER_SERVER_ALIAS, operationName, new Object[]{counterName});
        responseValue = Counters.convertToType(responseValue, Long.class);
        return (Long)responseValue;
    }

    private Long runGetOperation(String operationName, String counterName, Number value) {
        Number responseValue = (Number)Invoker.invokeSync(ATOMIC_MANAGER_SERVER_ALIAS, operationName, new Object[]{counterName, value});
        responseValue = Counters.convertToType(responseValue, Long.class);
        return (Long)responseValue;
    }
}

