/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.IDataStore;
import com.backendless.Invoker;
import com.backendless.Persistence;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.commons.persistence.GroupResult;
import com.backendless.exceptions.BackendlessException;
import com.backendless.persistence.BackendlessSerializer;
import com.backendless.persistence.DataQueryBuilder;
import com.backendless.persistence.GroupDataQueryBuilder;
import com.backendless.persistence.LoadRelationsQueryBuilder;
import com.backendless.rt.data.EventHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class DataStore<T>
implements IDataStore<T> {
    private final Class<T> entityClass;
    private final Persistence persistence;
    private final EventHandler<T> eventHandler;

    DataStore(Class<T> entityClass, Persistence persistence, EventHandler<T> eventHandler) {
        this.entityClass = entityClass;
        this.persistence = persistence;
        this.eventHandler = eventHandler;
    }

    @Override
    public List<String> create(List<T> objects) throws BackendlessException {
        return this.persistence.create(objects);
    }

    @Override
    public void create(List<T> objects, AsyncCallback<List<String>> responder) throws BackendlessException {
        this.persistence.create(objects, responder);
    }

    @Override
    public T save(T entity) throws BackendlessException {
        return this.persistence.save(entity);
    }

    @Override
    public T save(T entity, boolean isUpsert) throws BackendlessException {
        return this.persistence.save(entity);
    }

    @Override
    public void save(T entity, AsyncCallback<T> responder) {
        this.persistence.save(entity, responder);
    }

    @Override
    public void save(T entity, boolean isUpsert, AsyncCallback<T> responder) {
        this.persistence.save(entity, responder);
    }

    @Override
    public T deepSave(T entity) throws BackendlessException {
        return this.persistence.deepSave(entity);
    }

    @Override
    public void deepSave(T entity, AsyncCallback<T> responder) {
        this.persistence.deepSave(entity, responder);
    }

    @Override
    public Long remove(T entity) throws BackendlessException {
        return this.persistence.remove(entity);
    }

    @Override
    public void remove(T entity, AsyncCallback<Long> responder) {
        this.persistence.remove(entity, responder);
    }

    @Override
    public int remove(String whereClause) throws BackendlessException {
        return this.persistence.remove(BackendlessSerializer.getSimpleName(this.entityClass), whereClause);
    }

    @Override
    public void remove(String whereClause, AsyncCallback<Integer> responder) throws BackendlessException {
        this.persistence.remove(BackendlessSerializer.getSimpleName(this.entityClass), whereClause, responder);
    }

    @Override
    public int update(String whereClause, Map<String, Object> changes) throws BackendlessException {
        return this.persistence.update(BackendlessSerializer.getSimpleName(this.entityClass), whereClause, changes);
    }

    @Override
    public void update(String whereClause, Map<String, Object> changes, AsyncCallback<Integer> responder) throws BackendlessException {
        this.persistence.update(BackendlessSerializer.getSimpleName(this.entityClass), whereClause, changes, responder);
    }

    @Override
    public T findFirst() throws BackendlessException {
        return this.persistence.first(this.entityClass);
    }

    @Override
    public T findFirst(Integer relationsDepth) throws BackendlessException {
        return this.findFirst(Collections.emptyList(), relationsDepth, null);
    }

    @Override
    public T findFirst(List<String> relations) throws BackendlessException {
        return this.findFirst(relations, null, null);
    }

    @Override
    public T findFirst(List<String> relations, Integer relationsDepth, Integer relationsPageSize) throws BackendlessException {
        return this.persistence.first(this.entityClass, relations, relationsDepth, relationsPageSize);
    }

    @Override
    public int getObjectCount() {
        return this.persistence.getObjectCount(this.entityClass);
    }

    @Override
    public int getObjectCount(DataQueryBuilder dataQueryBuilder) {
        return this.persistence.getObjectCount(this.entityClass, dataQueryBuilder);
    }

    @Override
    public int getObjectCountInGroup(GroupDataQueryBuilder dataQueryBuilder) {
        return this.persistence.getObjectCountInGroup(this.entityClass, dataQueryBuilder);
    }

    @Override
    public void findFirst(AsyncCallback<T> responder) {
        this.persistence.first(this.entityClass, responder);
    }

    @Override
    public void findFirst(Integer relationsDepth, AsyncCallback<T> responder) {
        this.findFirst(Collections.emptyList(), relationsDepth, (Integer)null, responder);
    }

    @Override
    public void findFirst(List<String> relations, AsyncCallback<T> responder) {
        this.findFirst(relations, (Integer)null, (Integer)null, responder);
    }

    @Override
    public void findFirst(List<String> relations, Integer relationsDepth, Integer relationsPageSize, AsyncCallback<T> responder) {
        this.persistence.first(this.entityClass, relations, relationsDepth, relationsPageSize, responder);
    }

    @Override
    public T findLast() throws BackendlessException {
        return this.persistence.last(this.entityClass);
    }

    @Override
    public T findLast(Integer relationsDepth) throws BackendlessException {
        return this.findLast(Collections.emptyList(), relationsDepth, null);
    }

    @Override
    public T findLast(List<String> relations) throws BackendlessException {
        return this.findLast(relations, null, null);
    }

    @Override
    public T findLast(List<String> relations, Integer relationsDepth, Integer relationsPageSize) throws BackendlessException {
        return this.persistence.last(this.entityClass, relations, relationsDepth, relationsPageSize);
    }

    @Override
    public void findLast(AsyncCallback<T> responder) {
        this.persistence.last(this.entityClass, responder);
    }

    @Override
    public void findLast(Integer relationsDepth, AsyncCallback<T> responder) {
        this.findLast(Collections.emptyList(), relationsDepth, (Integer)null, responder);
    }

    @Override
    public void findLast(List<String> relations, AsyncCallback<T> responder) {
        this.findLast(relations, (Integer)null, (Integer)null, responder);
    }

    @Override
    public void findLast(List<String> relations, Integer relationsDepth, Integer relationsPageSize, AsyncCallback<T> responder) {
        this.persistence.last(this.entityClass, relations, relationsDepth, relationsPageSize, responder);
    }

    @Override
    public List<T> find() throws BackendlessException {
        return this.persistence.find(this.entityClass, DataQueryBuilder.create());
    }

    @Override
    public List<T> find(DataQueryBuilder dataQueryBuilder) throws BackendlessException {
        return this.persistence.find(this.entityClass, dataQueryBuilder);
    }

    @Override
    public void find(AsyncCallback<List<T>> responder) {
        this.persistence.find(this.entityClass, DataQueryBuilder.create(), responder);
    }

    @Override
    public void find(DataQueryBuilder dataQueryBuilder, AsyncCallback<List<T>> responder) {
        this.persistence.find(this.entityClass, dataQueryBuilder, responder);
    }

    @Override
    public GroupResult<?, T> group(GroupDataQueryBuilder dataQueryBuilder) throws BackendlessException {
        return this.persistence.group(this.entityClass, dataQueryBuilder);
    }

    @Override
    public void group(GroupDataQueryBuilder dataQueryBuilder, AsyncCallback<GroupResult<?, T>> responder) {
        this.persistence.group(this.entityClass, dataQueryBuilder, responder);
    }

    @Override
    public T findById(String objectId) throws BackendlessException {
        return (T)this.findById((T)objectId, Collections.emptyList());
    }

    @Override
    public T findById(String objectId, List<String> relations) throws BackendlessException {
        return this.persistence.findById(this.entityClass, objectId, relations);
    }

    @Override
    public T findById(String objectId, Integer relationsDepth) throws BackendlessException {
        return this.persistence.findById(this.entityClass, objectId, Collections.emptyList(), relationsDepth);
    }

    @Override
    public T findById(String objectId, List<String> relations, Integer relationsDepth) throws BackendlessException {
        return this.persistence.findById(this.entityClass, objectId, relations, relationsDepth);
    }

    @Override
    public T findById(T entity) {
        return this.findById(entity, Collections.emptyList());
    }

    @Override
    public T findById(T entity, List<String> relations) {
        return this.findById(entity, relations, (Integer)null);
    }

    @Override
    public T findById(T entity, Integer relationsDepth) {
        return this.findById(entity, Collections.emptyList(), relationsDepth);
    }

    @Override
    public T findById(T entity, List<String> relations, Integer relationsDepth) {
        return this.persistence.findById(entity, relations, relationsDepth);
    }

    @Override
    public void findById(String objectId, AsyncCallback<T> responder) {
        this.findById((T)objectId, Collections.emptyList(), responder);
    }

    @Override
    public void findById(String objectId, List<String> relations, AsyncCallback<T> responder) {
        this.persistence.findById(this.entityClass, objectId, relations, responder);
    }

    @Override
    public void findById(String objectId, Integer relationsDepth, AsyncCallback<T> responder) {
        this.findById((T)objectId, Collections.emptyList(), relationsDepth, responder);
    }

    @Override
    public void findById(String objectId, List<String> relations, Integer relationsDepth, AsyncCallback<T> responder) {
        this.persistence.findById(this.entityClass, objectId, relations, relationsDepth, responder);
    }

    @Override
    public void findById(T entity, AsyncCallback<T> responder) {
        this.findById(entity, Collections.emptyList(), responder);
    }

    @Override
    public void findById(T entity, List<String> relations, AsyncCallback<T> responder) {
        this.findById(entity, relations, (Integer)null, responder);
    }

    @Override
    public void findById(T entity, Integer relationsDepth, AsyncCallback<T> responder) {
        this.findById(entity, Collections.emptyList(), relationsDepth, responder);
    }

    @Override
    public void findById(T entity, List<String> relations, Integer relationsDepth, AsyncCallback<T> responder) {
        this.persistence.findById(entity, relations, relationsDepth, responder);
    }

    @Override
    public T findById(String id, DataQueryBuilder queryBuilder) throws BackendlessException {
        return this.persistence.findById(this.entityClass, id, queryBuilder);
    }

    @Override
    public T findById(T entity, DataQueryBuilder queryBuilder) throws BackendlessException {
        return this.persistence.findById(entity, queryBuilder);
    }

    @Override
    public void findById(String id, DataQueryBuilder queryBuilder, AsyncCallback<T> responder) {
        this.persistence.findById(this.entityClass, id, queryBuilder, responder);
    }

    @Override
    public void findById(T entity, DataQueryBuilder queryBuilder, AsyncCallback<T> responder) {
        this.persistence.findById(entity, queryBuilder, responder);
    }

    @Override
    public <R> List<R> loadRelations(String objectId, LoadRelationsQueryBuilder<R> queryBuilder) {
        String typeName = BackendlessSerializer.getSimpleName(this.entityClass);
        return this.persistence.loadRelations(typeName, objectId, queryBuilder, queryBuilder.getRelationType());
    }

    @Override
    public <R> void loadRelations(String objectId, LoadRelationsQueryBuilder<R> queryBuilder, AsyncCallback<List<R>> responder) {
        String typeName = BackendlessSerializer.getSimpleName(this.entityClass);
        this.persistence.loadRelations(typeName, objectId, queryBuilder, queryBuilder.getRelationType(), responder);
    }

    @Override
    public void getObjectCount(AsyncCallback<Integer> responder) {
        this.persistence.getObjectCount(this.entityClass, responder);
    }

    @Override
    public void getObjectCount(DataQueryBuilder dataQueryBuilder, AsyncCallback<Integer> responder) {
        this.persistence.getObjectCount(this.entityClass, dataQueryBuilder, responder);
    }

    @Override
    public void getObjectCountInGroup(GroupDataQueryBuilder dataQueryBuilder, AsyncCallback<Integer> responder) {
        this.persistence.getObjectCountInGroup(this.entityClass, dataQueryBuilder, responder);
    }

    @Override
    public <R> int addRelation(T parent, String relationColumnName, Collection<R> children) {
        String parentObjectId = Persistence.getEntityId(parent);
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        return this.addRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds);
    }

    @Override
    public <R> void addRelation(T parent, String relationColumnName, Collection<R> children, AsyncCallback<Integer> callback) {
        String parentObjectId = Persistence.getEntityId(parent);
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        this.addRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds, callback);
    }

    @Override
    public int addRelation(T parent, String relationColumnName, String whereClause) {
        String parentObjectId = Persistence.getEntityId(parent);
        return this.addRelation(parentObjectId, relationColumnName, whereClause);
    }

    @Override
    public void addRelation(T parent, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        String parentObjectId = Persistence.getEntityId(parent);
        this.addRelation(parentObjectId, relationColumnName, whereClause, callback);
    }

    @Override
    public <R> int setRelation(T parent, String relationColumnName, Collection<R> children) {
        String parentObjectId = Persistence.getEntityId(parent);
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        return this.setRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds);
    }

    @Override
    public <R> void setRelation(T parent, String relationColumnName, Collection<R> children, AsyncCallback<Integer> callback) {
        String parentObjectId = Persistence.getEntityId(parent);
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        this.setRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds, callback);
    }

    @Override
    public int setRelation(T parent, String relationColumnName, String whereClause) {
        String parentObjectId = Persistence.getEntityId(parent);
        return this.setRelation(parentObjectId, relationColumnName, whereClause);
    }

    @Override
    public void setRelation(T parent, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        String parentObjectId = Persistence.getEntityId(parent);
        this.setRelation(parentObjectId, relationColumnName, whereClause, callback);
    }

    @Override
    public <R> int deleteRelation(T parent, String relationColumnName, Collection<R> children) {
        String parentObjectId = Persistence.getEntityId(parent);
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        return this.deleteRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds);
    }

    @Override
    public <R> void deleteRelation(T parent, String relationColumnName, Collection<R> children, AsyncCallback<Integer> callback) {
        String parentObjectId = Persistence.getEntityId(parent);
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        this.deleteRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds, callback);
    }

    @Override
    public int deleteRelation(T parent, String relationColumnName, String whereClause) {
        String parentObjectId = Persistence.getEntityId(parent);
        return this.deleteRelation(parentObjectId, relationColumnName, whereClause);
    }

    @Override
    public void deleteRelation(T parent, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        String parentObjectId = Persistence.getEntityId(parent);
        this.deleteRelation(parentObjectId, relationColumnName, whereClause, callback);
    }

    @Override
    public <R> int addRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, childrenObjectIds};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "addRelation", args);
    }

    @Override
    public <R> void addRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds, AsyncCallback<Integer> callback) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, childrenObjectIds};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "addRelation", args, callback);
    }

    @Override
    public int addRelation(String parentObjectId, String relationColumnName, String whereClause) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, whereClause};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "addRelation", args);
    }

    @Override
    public void addRelation(String parentObjectId, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, whereClause};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "addRelation", args, callback);
    }

    @Override
    public <R> int setRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, childrenObjectIds};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "setRelation", args);
    }

    @Override
    public <R> void setRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds, AsyncCallback<Integer> callback) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, childrenObjectIds};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "setRelation", args, callback);
    }

    @Override
    public int setRelation(String parentObjectId, String relationColumnName, String whereClause) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, whereClause};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "setRelation", args);
    }

    @Override
    public void setRelation(String parentObjectId, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, whereClause};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "setRelation", args, callback);
    }

    @Override
    public <R> int deleteRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, childrenObjectIds};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "deleteRelation", args);
    }

    @Override
    public <R> void deleteRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds, AsyncCallback<Integer> callback) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, childrenObjectIds};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "deleteRelation", args, callback);
    }

    @Override
    public int deleteRelation(String parentObjectId, String relationColumnName, String whereClause) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, whereClause};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "deleteRelation", args);
    }

    @Override
    public void deleteRelation(String parentObjectId, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        String parentTableName = BackendlessSerializer.getSimpleName(this.entityClass);
        Object[] args = new Object[]{parentTableName, relationColumnName, parentObjectId, whereClause};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "deleteRelation", args, callback);
    }

    @Override
    public EventHandler<T> rt() {
        return this.eventHandler;
    }
}

