/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.BackendlessInjector;
import com.backendless.BackendlessInternal;
import com.backendless.IHeadersManager;
import com.backendless.Invoker;
import com.backendless.UploadFileAsyncTask;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.async.callback.UploadCallback;
import com.backendless.core.responder.AdaptingResponder;
import com.backendless.core.responder.policy.CollectionAdaptingPolicy;
import com.backendless.exceptions.BackendlessException;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.files.BackendlessFile;
import com.backendless.files.FileInfo;
import com.backendless.files.router.FileOutputStreamRouter;
import com.backendless.files.router.OutputStreamRouter;
import com.backendless.files.security.FileRolePermission;
import com.backendless.files.security.FileUserPermission;
import com.backendless.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import weborb.types.Types;

public final class Files {
    private static final int DEFAULT_CHUNK_SIZE = 65536;
    private static final String OVERWRITE_PARAMETER_NAME = "overwrite";
    protected static final String FILE_MANAGER_SERVER_ALIAS = "com.backendless.services.file.FileService";
    private static final String SERVER_ERROR_REGEXP = "(\"message\":\"([^\"}]*)\")(,\"code\":([^\"}]*))?+";
    private static final Pattern SERVER_ERROR_PATTERN = Pattern.compile("(\"message\":\"([^\"}]*)\")(,\"code\":([^\"}]*))?+");
    private static final String SERVER_RESULT_REGEXP = "(\"fileURL\":\"([^\"[}]]*))";
    private static final Pattern SERVER_RESULT_PATTERN = Pattern.compile("(\"fileURL\":\"([^\"[}]]*))");
    private static final int MESSAGE_POSITION = 2;
    private static final int CODE_POSITION = 4;
    private static final Files instance = new Files();

    private Files() {
        Types.addClientClassMapping((String)"com.backendless.services.file.permissions.FileRolePermission", FileRolePermission.class);
        Types.addClientClassMapping((String)"com.backendless.services.file.permissions.FileUserPermission", FileUserPermission.class);
        Types.addClientClassMapping((String)"com.backendless.management.files.FileInfo", FileInfo.class);
    }

    static Files getInstance() {
        return instance;
    }

    public BackendlessFile upload(String urlToFile, String backendlessPath) {
        return this.upload(urlToFile, backendlessPath, false);
    }

    public BackendlessFile upload(String urlToFile, String backendlessPath, boolean overwrite) {
        if (urlToFile == null || urlToFile.isEmpty()) {
            throw new NullPointerException("URL to file cannot be null.");
        }
        if (backendlessPath == null) {
            throw new NullPointerException("File path cannot be null or empty.");
        }
        String resultURL = (String)Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "upload", new Object[]{urlToFile, backendlessPath, overwrite});
        return new BackendlessFile(resultURL);
    }

    public void upload(String urlToFile, String backendlessPath, AsyncCallback<BackendlessFile> responder) {
        this.upload(urlToFile, backendlessPath, false, responder);
    }

    public void upload(String urlToFile, String backendlessPath, boolean overwrite, final AsyncCallback<BackendlessFile> responder) {
        block4: {
            try {
                if (urlToFile == null || urlToFile.isEmpty()) {
                    throw new NullPointerException("URL to file cannot be null.");
                }
                if (backendlessPath == null) {
                    throw new NullPointerException("File path cannot be null or empty.");
                }
                Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "upload", new Object[]{urlToFile, backendlessPath, overwrite}, new AsyncCallback<String>(){

                    @Override
                    public void handleResponse(String response) {
                        responder.handleResponse(new BackendlessFile(response));
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                });
            }
            catch (Throwable e) {
                if (responder == null) break block4;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public BackendlessFile upload(File file, String path) throws Exception {
        return this.upload(file, path, false);
    }

    public BackendlessFile upload(File file, String path, boolean overwrite) throws Exception {
        return this.upload(file, path, overwrite, new EmptyUploadCallback());
    }

    public BackendlessFile upload(File file, String path, UploadCallback uploadCallback) throws Exception {
        return this.upload(file, path, false, uploadCallback);
    }

    public BackendlessFile upload(File file, String path, boolean overwrite, UploadCallback uploadCallback) throws Exception {
        this.checkFileAndPath(file, path);
        return this.uploadFromStream(new FileOutputStreamRouter(file, uploadCallback), file.getName(), path, overwrite);
    }

    private void checkFileAndPath(File file, String path) {
        if (file == null) {
            throw new NullPointerException("File cannot be null.");
        }
        if (path == null) {
            throw new NullPointerException("File path cannot be null or empty.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("cannot read the file.");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("File is not readable.");
        }
    }

    public BackendlessFile uploadFromStream(OutputStreamRouter outputStreamRouter, String name, String path) throws Exception {
        return this.uploadFromStream(outputStreamRouter, name, path, false);
    }

    public BackendlessFile uploadFromStream(OutputStreamRouter outputStreamRouter, String name, String path, boolean overwrite) throws Exception {
        HttpURLConnection connection = null;
        String CRLF = "\r\n";
        String boundary = UUID.randomUUID().toString();
        try {
            String response;
            Scanner scanner;
            String urlStr = BackendlessInternal.getApplicationUrl() + "/files/" + this.encodeURL(path) + "/" + this.encodeURL(name);
            if (overwrite) {
                urlStr = urlStr + "?" + OVERWRITE_PARAMETER_NAME + "=" + overwrite;
            }
            URL url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            connection.setChunkedStreamingMode(65536);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.addRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            IHeadersManager headersManager = BackendlessInjector.getInstance().getHeadersManager();
            for (Map.Entry<String, String> entry : headersManager.getHeaders().entrySet()) {
                connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            try (OutputStream outputStream = connection.getOutputStream();
                 PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);){
                writer.append("--").append(boundary).append(CRLF);
                writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(name).append("\"").append(CRLF);
                writer.append("Content-Type: application/octet-stream").append(CRLF);
                writer.append("Content-Transfer-Encoding: binary").append(CRLF);
                writer.append(CRLF).flush();
                outputStreamRouter.writeStream(outputStream);
                outputStream.flush();
                writer.append(CRLF).flush();
                writer.append("--").append(boundary).append("--").append(CRLF);
            }
            if (connection.getResponseCode() != 200) {
                scanner = new Scanner(connection.getErrorStream());
                scanner.useDelimiter("\\Z");
                response = scanner.next();
                scanner.close();
                Matcher matcher = SERVER_ERROR_PATTERN.matcher(response);
                String message = null;
                String code = null;
                while (matcher.find()) {
                    message = matcher.group(2);
                    code = matcher.group(4);
                }
                throw new BackendlessException(code == null ? String.valueOf(connection.getResponseCode()) : code, message);
            }
            scanner = new Scanner(connection.getInputStream());
            scanner.useDelimiter("\\Z");
            response = scanner.next();
            scanner.close();
            Matcher matcher = SERVER_RESULT_PATTERN.matcher(response);
            String fileUrl = null;
            while (matcher.find()) {
                fileUrl = matcher.group(2);
            }
            BackendlessFile backendlessFile = new BackendlessFile(fileUrl);
            return backendlessFile;
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new IllegalArgumentException("Could not upload a file", e);
        }
        catch (IOException e) {
            throw new BackendlessException("Could not upload a file", e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String encodeURL(String urlStr) throws UnsupportedEncodingException {
        String[] splitedStr = urlStr.split("/");
        String result = "";
        for (int i = 0; i < splitedStr.length; ++i) {
            if (i != 0) {
                result = result + "/";
            }
            result = result + URLEncoder.encode(splitedStr[i], "UTF-8");
        }
        return result;
    }

    public void upload(File file, String path, AsyncCallback<BackendlessFile> responder) {
        this.upload(file, path, false, responder);
    }

    public void upload(File file, String path, boolean overwrite, AsyncCallback<BackendlessFile> responder) {
        this.upload(file, path, overwrite, new EmptyUploadCallback(), responder);
    }

    public void upload(File file, String path, UploadCallback uploadCallback, AsyncCallback<BackendlessFile> responder) {
        this.upload(file, path, false, uploadCallback, responder);
    }

    public void upload(File file, String path, boolean overwrite, UploadCallback uploadCallback, AsyncCallback<BackendlessFile> responder) {
        block2: {
            try {
                this.checkFileAndPath(file, path);
                new UploadFileAsyncTask().executeThis(file, path, overwrite, uploadCallback, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public int remove(String fileUrl) throws BackendlessException {
        return this.removeDirectory(fileUrl);
    }

    public int removeDirectory(String directoryPath) throws BackendlessException {
        return this.removeDirectory(directoryPath, "*", true);
    }

    public int removeDirectory(String directoryPath, String pattern, boolean recursive) throws BackendlessException {
        if (directoryPath == null) {
            throw new IllegalArgumentException("File path cannot be null or empty.");
        }
        return (Integer)Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "deleteFileOrDirectory", new Object[]{directoryPath, pattern, recursive});
    }

    public void remove(String fileUrl, AsyncCallback<Integer> responder) {
        this.removeDirectory(fileUrl, responder);
    }

    public void removeDirectory(String directoryPath, AsyncCallback<Integer> responder) {
        this.removeDirectory(directoryPath, "*", true, responder);
    }

    public void removeDirectory(String directoryPath, String pattern, boolean recursive, AsyncCallback<Integer> responder) {
        block3: {
            try {
                if (directoryPath == null) {
                    throw new IllegalArgumentException("File path cannot be null or empty.");
                }
                Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "deleteFileOrDirectory", new Object[]{directoryPath, "*", true}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public void createDirectory(String directoryPath) {
        if (directoryPath == null) {
            throw new IllegalArgumentException("File path cannot be null or empty.");
        }
        Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "createDirectory", new Object[]{directoryPath});
    }

    public void createDirectory(String directoryPath, AsyncCallback<Void> responder) {
        if (directoryPath == null) {
            throw new IllegalArgumentException("File path cannot be null or empty.");
        }
        Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "createDirectory", new Object[]{directoryPath}, responder);
    }

    public String saveFile(String path, String fileName, byte[] fileContent) {
        return (String)Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "saveFile", new Object[]{path, fileName, fileContent});
    }

    public String saveFile(String path, String fileName, byte[] fileContent, boolean overwrite) {
        return (String)Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "saveFile", new Object[]{path, fileName, fileContent, overwrite});
    }

    public String saveFile(String filePathName, byte[] fileContent, boolean overwrite) {
        return (String)Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "saveFile", new Object[]{filePathName, fileContent, overwrite});
    }

    public void saveFile(String path, String fileName, byte[] fileContent, AsyncCallback<String> responder) {
        Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "saveFile", new Object[]{path, fileName, fileContent}, responder);
    }

    public void saveFile(String path, String fileName, byte[] fileContent, boolean overwrite, AsyncCallback<String> responder) {
        Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "saveFile", new Object[]{path, fileName, fileContent, overwrite}, responder);
    }

    public void saveFile(String filePathName, byte[] fileContent, boolean overwrite, AsyncCallback<String> responder) {
        Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "saveFile", new Object[]{filePathName, fileContent, overwrite}, responder);
    }

    public String renameFile(String oldPathName, String newName) throws BackendlessException {
        if (oldPathName == null || oldPathName.isEmpty()) {
            throw new IllegalArgumentException("File path cannot be null or empty.");
        }
        if (newName == null || newName.isEmpty()) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        return (String)Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "renameFile", new Object[]{oldPathName, newName});
    }

    public void renameFile(String oldPathName, String newName, AsyncCallback<String> responder) throws BackendlessException {
        if (oldPathName == null || oldPathName.isEmpty()) {
            throw new IllegalArgumentException("File path cannot be null or empty.");
        }
        if (newName == null || newName.isEmpty()) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "renameFile", new Object[]{oldPathName, newName}, responder);
    }

    public String copyFile(String sourcePathName, String targetPath) throws BackendlessException {
        if (sourcePathName == null || sourcePathName.isEmpty()) {
            throw new IllegalArgumentException("File path cannot be null or empty.");
        }
        if (targetPath == null || targetPath.isEmpty()) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        return (String)Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "copyFile", new Object[]{sourcePathName, targetPath});
    }

    public void copyFile(String sourcePathName, String targetPath, AsyncCallback<String> responder) throws BackendlessException {
        if (sourcePathName == null || sourcePathName.isEmpty()) {
            throw new IllegalArgumentException("File path cannot be null or empty.");
        }
        if (targetPath == null || targetPath.isEmpty()) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "copyFile", new Object[]{sourcePathName, targetPath}, responder);
    }

    public String moveFile(String sourcePathName, String targetPath) throws BackendlessException {
        if (sourcePathName == null || sourcePathName.isEmpty()) {
            throw new IllegalArgumentException("File path cannot be null or empty.");
        }
        if (targetPath == null || targetPath.isEmpty()) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        return (String)Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "moveFile", new Object[]{sourcePathName, targetPath});
    }

    public void moveFile(String sourcePathName, String targetPath, AsyncCallback<String> responder) throws BackendlessException {
        if (sourcePathName == null || sourcePathName.isEmpty()) {
            throw new IllegalArgumentException("File path cannot be null or empty.");
        }
        if (targetPath == null || targetPath.isEmpty()) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "moveFile", new Object[]{sourcePathName, targetPath}, responder);
    }

    public List<FileInfo> listing(String path) {
        return this.listing(path, "*", false);
    }

    public List<FileInfo> listing(String path, String pattern, boolean recursive) {
        return this.listing(path, pattern, recursive, 20, 0);
    }

    public List<FileInfo> listing(String path, String pattern, boolean recursive, int pagesize, int offset) {
        List fileInfoList = (List)Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "listing", new Object[]{path, pattern, recursive, pagesize, offset}, new AdaptingResponder<FileInfo>(FileInfo.class, new CollectionAdaptingPolicy()));
        return fileInfoList;
    }

    public void listing(String path, AsyncCallback<List<FileInfo>> responder) {
        this.listing(path, "*", false, responder);
    }

    public void listing(String path, String pattern, boolean recursive, AsyncCallback<List<FileInfo>> responder) {
        this.listing(path, pattern, recursive, 20, 0, responder);
    }

    public void listing(String path, String pattern, boolean recursive, int pagesize, int offset, final AsyncCallback<List<FileInfo>> responder) {
        Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "listing", new Object[]{path, pattern, recursive, pagesize, offset}, new AsyncCallback<List<FileInfo>>(){

            @Override
            public void handleResponse(List<FileInfo> response) {
                if (responder != null) {
                    responder.handleResponse(response);
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                if (responder != null) {
                    responder.handleFault(fault);
                }
            }
        }, new AdaptingResponder<FileInfo>(FileInfo.class, new CollectionAdaptingPolicy()));
    }

    public int getFileCount(String path, String pattern, boolean recursive, boolean countDirectories) {
        return (Integer)Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "count", new Object[]{path, pattern, recursive, countDirectories});
    }

    public int getFileCount(String path, String pattern, boolean recursive) {
        return this.getFileCount(path, pattern, recursive, false);
    }

    public int getFileCount(String path, String pattern) {
        return this.getFileCount(path, pattern, false);
    }

    public int getFileCount(String path) {
        return this.getFileCount(path, "*");
    }

    public void getFileCount(String path, String pattern, boolean recursive, boolean countDirectories, AsyncCallback<Integer> responder) {
        block2: {
            try {
                Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "count", new Object[]{path, pattern, recursive, countDirectories}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public void getFileCount(String path, String pattern, boolean recursive, AsyncCallback<Integer> responder) {
        this.getFileCount(path, pattern, recursive, false, responder);
    }

    public void getFileCount(String path, String pattern, AsyncCallback<Integer> responder) {
        this.getFileCount(path, pattern, false, responder);
    }

    public void getFileCount(String path, AsyncCallback<Integer> responder) {
        this.getFileCount(path, "*", responder);
    }

    public boolean exists(String path) {
        StringUtils.checkEmpty(path, "File path cannot be null or empty.");
        return (Boolean)Invoker.invokeSync(FILE_MANAGER_SERVER_ALIAS, "exists", new Object[]{path});
    }

    public void exists(String path, AsyncCallback<Boolean> responder) {
        StringUtils.checkEmpty(path, "File path cannot be null or empty.");
        Invoker.invokeAsync(FILE_MANAGER_SERVER_ALIAS, "exists", new Object[]{path}, responder);
    }

    private static class EmptyUploadCallback
    implements UploadCallback {
        private EmptyUploadCallback() {
        }

        @Override
        public void onProgressUpdate(Integer progress) {
        }
    }
}

