/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.BackendlessUser;
import com.backendless.Footprint;
import com.backendless.utils.ReflectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import weborb.reader.AnonymousObject;
import weborb.reader.ArrayType;
import weborb.reader.NamedObject;

public class FootprintsManager {
    private static final FootprintsManager instance = new FootprintsManager();
    private static final Set<Object> marked = new HashSet<Object>();
    public final Inner Inner = new Inner();
    private final Map<Object, Footprint> persistenceCache = new WeakHashMap<Object, Footprint>();

    private FootprintsManager() {
    }

    public static FootprintsManager getInstance() {
        return instance;
    }

    public Footprint getEntityFootprint(Object entity) {
        return this.persistenceCache.get(entity);
    }

    public String getObjectId(Object entity) {
        if (entity instanceof BackendlessUser) {
            return ((BackendlessUser)entity).getObjectId();
        }
        Footprint footprint = this.getEntityFootprint(entity);
        if (footprint != null) {
            return footprint.getObjectId();
        }
        return null;
    }

    public String getMeta(Object entity) {
        Footprint obj = this.persistenceCache.get(entity);
        if (obj instanceof Footprint) {
            return obj.get__meta();
        }
        if (obj instanceof BackendlessUser) {
            return (String)((BackendlessUser)((Object)obj)).getProperty("__meta");
        }
        return null;
    }

    public Date getCreated(Object entity) {
        if (this.persistenceCache.containsKey(entity)) {
            return this.getEntityFootprint(entity).getCreated();
        }
        return null;
    }

    public Date getUpdated(Object entity) {
        if (this.persistenceCache.containsKey(entity)) {
            return this.getEntityFootprint(entity).getUpdated();
        }
        return null;
    }

    public class Inner {
        public void putMissingPropsToEntityMap(Object entity, Map entityMap) {
            String meta;
            String objectId;
            if (!entityMap.containsKey("objectId") && (objectId = FootprintsManager.this.getObjectId(entity)) != null) {
                entityMap.put("objectId", objectId);
            }
            if (!entityMap.containsKey("__meta") && (meta = FootprintsManager.this.getMeta(entity)) != null) {
                entityMap.put("__meta", meta);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void duplicateFootprintForObject(Map<String, Object> serializedEntity, Object persistedEntity, Object initialEntity) {
            if (marked.contains(persistedEntity)) {
                return;
            }
            marked.add(persistedEntity);
            try {
                Set<Map.Entry<String, Object>> entries = serializedEntity.entrySet();
                for (Map.Entry<String, Object> entry : entries) {
                    if (entry.getValue() instanceof Map) {
                        Object persistedEntityFieldValue = this.getFieldValue(persistedEntity, entry.getKey());
                        Object initialEntityFieldValue = this.getFieldValue(initialEntity, entry.getKey());
                        this.duplicateFootprintForObject((Map)entry.getValue(), persistedEntityFieldValue, initialEntityFieldValue);
                        continue;
                    }
                    if (!(entry.getValue() instanceof Collection)) continue;
                    Collection collection = (Collection)entry.getValue();
                    Collection persistedEntityFieldValue = this.getFieldValueAsCollection(persistedEntity, entry.getKey());
                    if (persistedEntityFieldValue.isEmpty()) continue;
                    Collection initialEntityFieldValue = this.getFieldValueAsCollection(initialEntity, entry.getKey());
                    Collection mapCollection = (Collection)entry.getValue();
                    Iterator persistedEntityFieldValueIterator = persistedEntityFieldValue.iterator();
                    Iterator initialEntityFieldValueIterator = initialEntityFieldValue.iterator();
                    Iterator mapCollectionIterator = mapCollection.iterator();
                    while (initialEntityFieldValueIterator.hasNext()) {
                        this.duplicateFootprintForObject((Map)mapCollectionIterator.next(), persistedEntityFieldValueIterator.next(), initialEntityFieldValueIterator.next());
                    }
                }
                Footprint footprint = (Footprint)FootprintsManager.this.persistenceCache.get(persistedEntity);
                if (footprint != null) {
                    FootprintsManager.this.persistenceCache.put(initialEntity, footprint);
                }
            }
            finally {
                marked.remove(persistedEntity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateFootprintForObject(Map<String, Object> serialized, Object newEntity, Object oldEntity) {
            if (marked.contains(newEntity)) {
                return;
            }
            marked.add(newEntity);
            try {
                Set<Map.Entry<String, Object>> entries = serialized.entrySet();
                for (Map.Entry<String, Object> entry : entries) {
                    String key = entry.getKey();
                    if (entry.getValue() instanceof Map) {
                        Object newEntityField = this.getFieldValue(newEntity, key);
                        Object oldEntityField = this.getFieldValue(oldEntity, key);
                        this.updateFootprintForObject((Map)entry.getValue(), newEntityField, oldEntityField);
                        continue;
                    }
                    if (!(entry.getValue() instanceof Collection)) continue;
                    Collection valueCollection = (Collection)entry.getValue();
                    Iterator valueIterator = valueCollection.iterator();
                    Collection newObjectCollection = this.getFieldValueAsCollection(newEntity, key);
                    Collection oldObjectCollection = this.getFieldValueAsCollection(oldEntity, key);
                    Collection mapCollection = (Collection)entry.getValue();
                    Iterator mapCollectionIterator = mapCollection.iterator();
                    Iterator oldObjectCollectionIterator = oldObjectCollection.iterator();
                    Iterator newObjectCollectionIterator = newObjectCollection.iterator();
                    while (oldObjectCollectionIterator.hasNext()) {
                        this.updateFootprintForObject((Map)mapCollectionIterator.next(), newObjectCollectionIterator.next(), oldObjectCollectionIterator.next());
                    }
                }
                Footprint footprint = (Footprint)FootprintsManager.this.persistenceCache.get(newEntity);
                FootprintsManager.this.persistenceCache.put(oldEntity, footprint);
            }
            finally {
                marked.remove(newEntity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeFootprintForObject(Map<String, Object> serializedEntity, Object entity) {
            if (marked.contains(entity)) {
                return;
            }
            marked.add(entity);
            try {
                Set<Map.Entry<String, Object>> entries = serializedEntity.entrySet();
                for (Map.Entry<String, Object> entry : entries) {
                    String key = entry.getKey();
                    if (entry.getValue() instanceof Map) {
                        Object entityFieldValue = this.getFieldValue(entity, key);
                        this.removeFootprintForObject((Map)entry.getValue(), entityFieldValue);
                        continue;
                    }
                    if (!(entry.getValue() instanceof Collection)) continue;
                    Collection objectCollection = this.getFieldValueAsCollection(entity, key);
                    Collection mapCollection = (Collection)entry.getValue();
                    Iterator objectCollectionIterator = objectCollection.iterator();
                    Iterator mapCollectionIterator = mapCollection.iterator();
                    while (objectCollectionIterator.hasNext()) {
                        this.removeFootprintForObject((Map)mapCollectionIterator.next(), objectCollectionIterator.next());
                    }
                }
                FootprintsManager.this.persistenceCache.remove(entity);
            }
            finally {
                marked.remove(entity);
            }
        }

        public void putEntityFootprintToCache(Object instance, Object entity) {
            if (marked.contains(entity)) {
                return;
            }
            marked.add(entity);
            try {
                if (instance instanceof Collection) {
                    ArrayType dataArray = null;
                    if (entity instanceof ArrayType) {
                        dataArray = (ArrayType)entity;
                    } else if (entity instanceof NamedObject) {
                        AnonymousObject typedObject = (AnonymousObject)((NamedObject)entity).getTypedObject();
                        dataArray = (ArrayType)typedObject.getProperties().get("data");
                    }
                    Object[] instances = ((Collection)instance).toArray();
                    this.putEntityFootprintToCache(instances, dataArray);
                } else if (entity instanceof NamedObject) {
                    this.putEntityFootprintToCache(instance, ((NamedObject)entity).getTypedObject());
                } else if (entity instanceof AnonymousObject) {
                    this.putEntityFootprintToCache(instance, ((AnonymousObject)entity).getProperties());
                } else if (entity instanceof ArrayType) {
                    Object[] entities = (Object[])((ArrayType)entity).getArray();
                    Object[] arrayInstance = instance instanceof List ? ((List)instance).toArray() : (Object[])instance;
                    for (int i = 0; i < arrayInstance.length; ++i) {
                        this.putEntityFootprintToCache(arrayInstance[i], entities[i]);
                    }
                } else {
                    Map e = (Map)entity;
                    for (Map.Entry entityEntry : e.entrySet()) {
                        Object innerInstance;
                        Object entityEntryValue = entityEntry.getValue();
                        if (!(entityEntryValue instanceof NamedObject) && !(entityEntryValue instanceof ArrayType) || (innerInstance = this.getFieldValue(instance, (String)entityEntry.getKey())) == null) continue;
                        this.putEntityFootprintToCache(innerInstance, entityEntry.getValue());
                    }
                    Map cachedEntity = (Map)entity;
                    FootprintsManager.this.persistenceCache.put(instance, Footprint.initFromEntity(cachedEntity));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            marked.remove(entity);
        }

        private Collection getFieldValueAsCollection(Object entity, String fieldName) {
            Object rawEntity = this.getFieldValue(entity, fieldName);
            if (rawEntity == null) {
                return new ArrayList();
            }
            if (rawEntity instanceof Collection) {
                return (Collection)rawEntity;
            }
            if (rawEntity.getClass().isArray()) {
                return Arrays.asList((Object[])rawEntity);
            }
            throw new RuntimeException("unknown data type - " + rawEntity.getClass());
        }

        private Object getFieldValue(Object entity, String fieldName) {
            Object entityFieldValue;
            String firstLetter = fieldName.substring(0, 1);
            String remainder = fieldName.substring(1);
            String lowerKey = firstLetter.toLowerCase().concat(remainder);
            String upperKey = firstLetter.toUpperCase().concat(remainder);
            if (entity instanceof BackendlessUser) {
                entityFieldValue = ((BackendlessUser)entity).getProperty(lowerKey);
                if (entityFieldValue == null) {
                    entityFieldValue = ((BackendlessUser)entity).getProperty(upperKey);
                }
            } else if (entity instanceof HashMap) {
                entityFieldValue = ((HashMap)entity).get(lowerKey);
                if (entityFieldValue == null) {
                    entityFieldValue = ((HashMap)entity).get(upperKey);
                }
            } else {
                entityFieldValue = ReflectionUtil.getFieldValue(entity, lowerKey, upperKey);
            }
            return entityFieldValue;
        }
    }
}

