/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.BackendlessInjector;
import com.backendless.BackendlessPrefs;
import com.backendless.ContextHandler;
import com.backendless.DeviceRegistration;
import com.backendless.Invoker;
import com.backendless.Messaging;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.messaging.BodyParts;
import com.backendless.messaging.DeliveryOptions;
import com.backendless.messaging.EmailEnvelope;
import com.backendless.messaging.Message;
import com.backendless.messaging.MessageStatus;
import com.backendless.messaging.PublishOptions;
import com.backendless.messaging.PublishStatusEnum;
import com.backendless.push.DeviceRegistrationResult;
import com.backendless.push.DeviceRegistrationUtil;
import com.backendless.rt.messaging.Channel;
import com.backendless.rt.messaging.ChannelFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import weborb.types.Types;

class GeneralMessaging
implements Messaging {
    static final String MESSAGING_MANAGER_SERVER_ALIAS = "com.backendless.services.messaging.MessagingService";
    static final String EMAIL_MANAGER_SERVER_ALIAS = "com.backendless.services.mail.CustomersEmailService";
    static final String EMAIL_TEMPLATE_SENDER_SERVER_ALIAS = "com.backendless.services.mail.EmailTemplateSender";
    static final String DEFAULT_CHANNEL_NAME = "default";
    static final ChannelFactory chanelFactory = new ChannelFactory();
    static final ContextHandler contextHandler = BackendlessInjector.getInstance().getContextHandler();
    static final BackendlessPrefs prefs = BackendlessInjector.getInstance().getPrefs();
    static final GeneralMessaging instance = new GeneralMessaging();

    protected GeneralMessaging() {
        Types.addClientClassMapping((String)"com.backendless.management.DeviceRegistrationDto", DeviceRegistration.class);
        Types.addClientClassMapping((String)"com.backendless.services.messaging.PublishOptions", PublishOptions.class);
        Types.addClientClassMapping((String)"com.backendless.services.messaging.DeliveryOptions", DeliveryOptions.class);
        Types.addClientClassMapping((String)"com.backendless.services.messaging.Message", Message.class);
    }

    static GeneralMessaging getInstance() {
        return instance;
    }

    @Override
    public void registerDevice() {
        this.registerDevice((List<String>)null);
    }

    @Override
    public void registerDevice(AsyncCallback<DeviceRegistrationResult> callback) {
        this.registerDevice(null, callback);
    }

    @Override
    public void registerDevice(List<String> channels) {
        this.registerDevice(channels, (Date)null);
    }

    @Override
    public void registerDevice(List<String> channels, Date expiration) {
        this.registerDevice(channels, expiration, null);
    }

    @Override
    public void registerDevice(List<String> channels, AsyncCallback<DeviceRegistrationResult> callback) {
        this.registerDevice(channels, null, callback);
    }

    @Override
    public void registerDevice(List<String> channels, Date expiration, AsyncCallback<DeviceRegistrationResult> callback) {
        throw new UnsupportedOperationException("Operation may be performed only from an Android environment");
    }

    protected void checkChannelName(String channelName) {
        if (channelName == null) {
            throw new IllegalArgumentException("Channel name cannot be null or empty.");
        }
        if (channelName.equals("")) {
            throw new IllegalArgumentException("Channel name cannot be null or empty.");
        }
    }

    @Override
    public void unregisterDevice() {
        this.unregisterDevice((List<String>)null);
    }

    @Override
    public void unregisterDevice(List<String> channels) {
        this.unregisterDevice(channels, null);
    }

    @Override
    public void unregisterDevice(AsyncCallback<Integer> callback) {
        this.unregisterDevice(null, callback);
    }

    @Override
    public void unregisterDevice(List<String> channels, AsyncCallback<Integer> callback) {
        throw new UnsupportedOperationException("Operation may be performed only from an Android environment");
    }

    @Override
    public boolean refreshDeviceToken(String newDeviceToken) {
        return (Boolean)Invoker.invokeSync(DeviceRegistrationUtil.getDeviceRegistrationManagerServerAlias(), "refreshDeviceToken", new Object[]{prefs.getDeviceId(), newDeviceToken});
    }

    @Override
    public void refreshDeviceToken(String newDeviceToken, AsyncCallback<Boolean> responder) {
        Invoker.invokeAsync(DeviceRegistrationUtil.getDeviceRegistrationManagerServerAlias(), "refreshDeviceToken", new Object[]{prefs.getDeviceId(), newDeviceToken}, responder);
    }

    @Override
    public DeviceRegistration getDeviceRegistration() {
        return this.getRegistrations();
    }

    @Override
    public DeviceRegistration getRegistrations() {
        return (DeviceRegistration)Invoker.invokeSync(DeviceRegistrationUtil.getDeviceRegistrationManagerServerAlias(), "getDeviceRegistrationByDeviceId", new Object[]{prefs.getDeviceId()});
    }

    @Override
    public void getDeviceRegistration(AsyncCallback<DeviceRegistration> responder) {
        this.getRegistrations(responder);
    }

    @Override
    public void getRegistrations(AsyncCallback<DeviceRegistration> responder) {
        Invoker.invokeAsync(DeviceRegistrationUtil.getDeviceRegistrationManagerServerAlias(), "getDeviceRegistrationByDeviceId", new Object[]{prefs.getDeviceId()}, responder);
    }

    @Override
    public MessageStatus publish(Object message) {
        if (message instanceof PublishOptions || message instanceof DeliveryOptions) {
            throw new IllegalArgumentException("Message object can not be instance of PublishOptions or DeliveryOptions class");
        }
        return this.publish(null, message);
    }

    @Override
    public MessageStatus publish(String channelName, Object message) {
        return this.publish(channelName, message, new PublishOptions());
    }

    @Override
    public MessageStatus publish(String channelName, Object message, PublishOptions publishOptions) {
        return this.publish(channelName, message, publishOptions, new DeliveryOptions());
    }

    @Override
    public MessageStatus publish(String channelName, Object message, PublishOptions publishOptions, DeliveryOptions deliveryOptions) {
        channelName = this.getCheckedChannelName(channelName);
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null. Use an empty string instead.");
        }
        if (deliveryOptions.getPushBroadcast() == 0 && deliveryOptions.getPushSinglecast().isEmpty()) {
            deliveryOptions.setPushBroadcast(15);
        }
        return (MessageStatus)Invoker.invokeSync(MESSAGING_MANAGER_SERVER_ALIAS, "publish", new Object[]{channelName, message, publishOptions, deliveryOptions});
    }

    protected String getCheckedChannelName(String channelName) {
        if (channelName == null) {
            return DEFAULT_CHANNEL_NAME;
        }
        if (channelName.equals("")) {
            return DEFAULT_CHANNEL_NAME;
        }
        return channelName;
    }

    @Override
    public MessageStatus publish(Object message, PublishOptions publishOptions) {
        return this.publish(null, message, publishOptions);
    }

    @Override
    public MessageStatus publish(Object message, PublishOptions publishOptions, DeliveryOptions deliveryOptions) {
        return this.publish(null, message, publishOptions, deliveryOptions);
    }

    @Override
    public void publish(Object message, AsyncCallback<MessageStatus> responder) {
        this.publish(null, message, responder);
    }

    @Override
    public void publish(String channelName, Object message, AsyncCallback<MessageStatus> responder) {
        this.publish(channelName, message, new PublishOptions(), responder);
    }

    @Override
    public void publish(String channelName, Object message, PublishOptions publishOptions, AsyncCallback<MessageStatus> responder) {
        this.publish(channelName, message, publishOptions, new DeliveryOptions(), responder);
    }

    @Override
    public void publish(String channelName, Object message, PublishOptions publishOptions, DeliveryOptions deliveryOptions, AsyncCallback<MessageStatus> responder) {
        block3: {
            try {
                channelName = this.getCheckedChannelName(channelName);
                if (message == null) {
                    throw new IllegalArgumentException("Message cannot be null. Use an empty string instead.");
                }
                Invoker.invokeAsync(MESSAGING_MANAGER_SERVER_ALIAS, "publish", new Object[]{channelName, message, publishOptions, deliveryOptions}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public void publish(Object message, PublishOptions publishOptions, AsyncCallback<MessageStatus> responder) {
        this.publish(null, message, publishOptions, new DeliveryOptions(), responder);
    }

    @Override
    public void publish(Object message, PublishOptions publishOptions, DeliveryOptions deliveryOptions, AsyncCallback<MessageStatus> responder) {
        this.publish(null, message, publishOptions, deliveryOptions, responder);
    }

    @Override
    public MessageStatus pushWithTemplate(String templateName) {
        return this.pushWithTemplate(templateName, (Map<String, String>)null);
    }

    @Override
    public MessageStatus pushWithTemplate(String templateName, Map<String, String> templateValues) {
        if (templateName == null) {
            throw new IllegalArgumentException("Template name can not be null or empty.");
        }
        return (MessageStatus)Invoker.invokeSync(MESSAGING_MANAGER_SERVER_ALIAS, "pushWithTemplate", new Object[]{templateName, templateValues});
    }

    @Override
    public void pushWithTemplate(String templateName, AsyncCallback<MessageStatus> responder) {
        this.pushWithTemplate(templateName, null, responder);
    }

    @Override
    public void pushWithTemplate(String templateName, Map<String, String> templateValues, AsyncCallback<MessageStatus> responder) {
        if (templateName == null) {
            throw new IllegalArgumentException("Template name can not be null or empty.");
        }
        Invoker.invokeAsync(MESSAGING_MANAGER_SERVER_ALIAS, "pushWithTemplate", new Object[]{templateName, templateValues}, responder);
    }

    @Override
    public MessageStatus getMessageStatus(String messageId) {
        if (messageId == null) {
            throw new IllegalArgumentException("Message id cannot be null or empty.");
        }
        MessageStatus messageStatus = (MessageStatus)Invoker.invokeSync(MESSAGING_MANAGER_SERVER_ALIAS, "getMessageStatus", new Object[]{messageId});
        return messageStatus;
    }

    @Override
    public void getMessageStatus(String messageId, AsyncCallback<MessageStatus> responder) {
        block3: {
            try {
                if (messageId == null) {
                    throw new IllegalArgumentException("Message id cannot be null or empty.");
                }
                Invoker.invokeAsync(MESSAGING_MANAGER_SERVER_ALIAS, "getMessageStatus", new Object[]{messageId}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public boolean cancel(String messageId) {
        if (messageId == null) {
            throw new IllegalArgumentException("Message id cannot be null or empty.");
        }
        MessageStatus cancel = (MessageStatus)Invoker.invokeSync(MESSAGING_MANAGER_SERVER_ALIAS, "cancel", new Object[]{messageId});
        return cancel.getStatus() == PublishStatusEnum.CANCELLED;
    }

    @Override
    public void cancel(String messageId, AsyncCallback<MessageStatus> responder) {
        block3: {
            try {
                if (messageId == null) {
                    throw new IllegalArgumentException("Message id cannot be null or empty.");
                }
                Invoker.invokeAsync(MESSAGING_MANAGER_SERVER_ALIAS, "cancel", new Object[]{messageId}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public Channel subscribe() {
        return this.subscribe(DEFAULT_CHANNEL_NAME);
    }

    @Override
    public Channel subscribe(String channelName) {
        return chanelFactory.create(channelName);
    }

    @Override
    public List<Message> pollMessages(String channelName, String subscriptionId) {
        this.checkChannelName(channelName);
        if (subscriptionId == null) {
            throw new IllegalArgumentException("Subscription id cannot be null or empty.");
        }
        Object[] result = (Object[])Invoker.invokeSync(MESSAGING_MANAGER_SERVER_ALIAS, "pollMessages", new Object[]{channelName, subscriptionId});
        return result.length == 0 ? new ArrayList() : Arrays.asList((Message[])result);
    }

    protected void pollMessages(String channelName, String subscriptionId, final AsyncCallback<List<Message>> responder) {
        block3: {
            try {
                this.checkChannelName(channelName);
                if (subscriptionId == null) {
                    throw new IllegalArgumentException("Subscription id cannot be null or empty.");
                }
                Invoker.invokeAsync(MESSAGING_MANAGER_SERVER_ALIAS, "pollMessages", new Object[]{channelName, subscriptionId}, new AsyncCallback<Object[]>(){

                    @Override
                    public void handleResponse(Object[] response) {
                        if (responder != null) {
                            responder.handleResponse(response.length == 0 ? new ArrayList() : Arrays.asList((Message[])response));
                        }
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                });
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public MessageStatus sendTextEmail(String subject, String messageBody, List<String> recipients) {
        return this.sendEmail(subject, new BodyParts(messageBody, null), recipients, new ArrayList<String>());
    }

    @Override
    public MessageStatus sendTextEmail(String subject, String messageBody, String recipient) {
        return this.sendEmail(subject, new BodyParts(messageBody, null), Arrays.asList(recipient), new ArrayList<String>());
    }

    @Override
    public MessageStatus sendHTMLEmail(String subject, String messageBody, List<String> recipients) {
        return this.sendEmail(subject, new BodyParts(null, messageBody), recipients, new ArrayList<String>());
    }

    @Override
    public MessageStatus sendHTMLEmail(String subject, String messageBody, String recipient) {
        return this.sendEmail(subject, new BodyParts(null, messageBody), Arrays.asList(recipient), new ArrayList<String>());
    }

    @Override
    public MessageStatus sendEmail(String subject, BodyParts bodyParts, String recipient, List<String> attachments) {
        return this.sendEmail(subject, bodyParts, Arrays.asList(recipient), attachments);
    }

    @Override
    public MessageStatus sendEmail(String subject, BodyParts bodyParts, String recipient) {
        return this.sendEmail(subject, bodyParts, Arrays.asList(recipient), new ArrayList<String>());
    }

    @Override
    public MessageStatus sendEmail(String subject, BodyParts bodyParts, List<String> recipients, List<String> attachments) {
        if (subject == null) {
            throw new IllegalArgumentException("Subject cannot be null");
        }
        if (bodyParts == null) {
            throw new IllegalArgumentException("BodyParts cannot be null");
        }
        if (recipients == null || recipients.isEmpty()) {
            throw new IllegalArgumentException("Recipients cannot be empty");
        }
        if (attachments == null) {
            throw new IllegalArgumentException("Attachments cannot be null");
        }
        return (MessageStatus)Invoker.invokeSync(EMAIL_MANAGER_SERVER_ALIAS, "send", new Object[]{subject, bodyParts, recipients, attachments});
    }

    @Override
    public void sendTextEmail(String subject, String messageBody, List<String> recipients, AsyncCallback<MessageStatus> responder) {
        this.sendEmail(subject, new BodyParts(messageBody, null), recipients, new ArrayList<String>(), responder);
    }

    @Override
    public void sendTextEmail(String subject, String messageBody, String recipient, AsyncCallback<MessageStatus> responder) {
        this.sendEmail(subject, new BodyParts(messageBody, null), Arrays.asList(recipient), new ArrayList<String>(), responder);
    }

    @Override
    public void sendHTMLEmail(String subject, String messageBody, List<String> recipients, AsyncCallback<MessageStatus> responder) {
        this.sendEmail(subject, new BodyParts(null, messageBody), recipients, new ArrayList<String>(), responder);
    }

    @Override
    public void sendHTMLEmail(String subject, String messageBody, String recipient, AsyncCallback<MessageStatus> responder) {
        this.sendEmail(subject, new BodyParts(null, messageBody), Arrays.asList(recipient), new ArrayList<String>(), responder);
    }

    @Override
    public void sendEmail(String subject, BodyParts bodyParts, String recipient, List<String> attachments, AsyncCallback<MessageStatus> responder) {
        this.sendEmail(subject, bodyParts, Arrays.asList(recipient), attachments, responder);
    }

    @Override
    public void sendEmail(String subject, BodyParts bodyParts, String recipient, AsyncCallback<MessageStatus> responder) {
        this.sendEmail(subject, bodyParts, Arrays.asList(recipient), new ArrayList<String>(), responder);
    }

    @Override
    public void sendEmail(String subject, BodyParts bodyParts, List<String> recipients, List<String> attachments, AsyncCallback<MessageStatus> responder) {
        block6: {
            try {
                if (subject == null) {
                    throw new IllegalArgumentException("Subject cannot be null");
                }
                if (bodyParts == null) {
                    throw new IllegalArgumentException("BodyParts cannot be null");
                }
                if (recipients == null || recipients.isEmpty()) {
                    throw new IllegalArgumentException("Recipients cannot be empty");
                }
                if (attachments == null) {
                    throw new IllegalArgumentException("Attachments cannot be null");
                }
                Invoker.invokeAsync(EMAIL_MANAGER_SERVER_ALIAS, "send", new Object[]{subject, bodyParts, recipients, attachments}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block6;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public MessageStatus sendEmailFromTemplate(String templateName, EmailEnvelope envelope) {
        return this.sendEmailFromTemplate(templateName, envelope, (Map<String, String>)null);
    }

    @Override
    public MessageStatus sendEmailFromTemplate(String templateName, EmailEnvelope envelope, Map<String, String> templateValues) {
        return this.sendEmailFromTemplate(templateName, envelope, templateValues, new ArrayList<String>());
    }

    @Override
    public MessageStatus sendEmailFromTemplate(String templateName, EmailEnvelope envelope, List<String> attachments) {
        return this.sendEmailFromTemplate(templateName, envelope, null, attachments);
    }

    @Override
    public MessageStatus sendEmailFromTemplate(String templateName, EmailEnvelope envelope, Map<String, String> templateValues, List<String> attachments) {
        if (templateName == null || templateName.isEmpty()) {
            throw new IllegalArgumentException("Template name can not be null or empty.");
        }
        if (envelope == null) {
            throw new IllegalArgumentException("EmailEnvelope can not be null.");
        }
        return (MessageStatus)Invoker.invokeSync(EMAIL_TEMPLATE_SENDER_SERVER_ALIAS, "sendEmails", new Object[]{templateName, envelope, templateValues, attachments});
    }

    @Override
    public void sendEmailFromTemplate(String templateName, EmailEnvelope envelope, AsyncCallback<MessageStatus> responder) {
        this.sendEmailFromTemplate(templateName, envelope, (Map<String, String>)null, responder);
    }

    @Override
    public void sendEmailFromTemplate(String templateName, EmailEnvelope envelope, Map<String, String> templateValues, AsyncCallback<MessageStatus> responder) {
        this.sendEmailFromTemplate(templateName, envelope, templateValues, new ArrayList<String>(), responder);
    }

    @Override
    public void sendEmailFromTemplate(String templateName, EmailEnvelope envelope, List<String> attachments, AsyncCallback<MessageStatus> responder) {
        this.sendEmailFromTemplate(templateName, envelope, null, attachments, responder);
    }

    @Override
    public void sendEmailFromTemplate(String templateName, EmailEnvelope envelope, Map<String, String> templateValues, List<String> attachments, AsyncCallback<MessageStatus> responder) {
        block4: {
            try {
                if (templateName == null || templateName.isEmpty()) {
                    throw new IllegalArgumentException("Template name can not be null or empty.");
                }
                if (envelope == null) {
                    throw new IllegalArgumentException("EmailEnvelope can not be null.");
                }
                Invoker.invokeAsync(EMAIL_TEMPLATE_SENDER_SERVER_ALIAS, "sendEmails", new Object[]{templateName, envelope, templateValues, attachments}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block4;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }
}

